/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research.costs;

import com.google.gson.JsonObject;
import com.minecolonies.api.research.ModResearchCostTypes;
import com.minecolonies.api.research.costs.IResearchCost;
import com.minecolonies.coremod.research.GlobalResearch;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SimpleItemCost
implements IResearchCost {
    private final ModResearchCostTypes.ResearchCostType type;
    private int count;
    private Item item;

    public SimpleItemCost(ModResearchCostTypes.ResearchCostType type) {
        this.type = type;
    }

    @Override
    public ModResearchCostTypes.ResearchCostType getType() {
        return this.type;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public List<Item> getItems() {
        return List.of(this.item);
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        if (compound.m_128441_("cost-count")) {
            this.item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.m_128461_("cost-item")));
            this.count = compound.m_128451_("cost-count");
        } else {
            String[] costParts = compound.m_128461_("cost-item").split(":");
            if (costParts.length == 3) {
                ItemStack is = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(costParts[0], costParts[1])));
                if (compound.m_128441_("cost-nbt")) {
                    is.m_41751_(compound.m_128469_("cost-nbt"));
                }
                this.item = is.m_41720_();
                this.count = Integer.parseInt(costParts[2]);
            }
        }
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        compound.m_128359_("cost-item", ForgeRegistries.ITEMS.getKey((Object)this.item).toString());
        compound.m_128405_("cost-count", this.count);
    }

    @Override
    public void serialize(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.count);
        buf.writeRegistryId(ForgeRegistries.ITEMS, (Object)this.item);
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.count = buf.readInt();
        this.item = (Item)buf.readRegistryIdSafe(Item.class);
    }

    @Override
    public boolean hasCorrectJsonFields(JsonObject jsonObject) {
        return jsonObject.has("item") && jsonObject.get("item").isJsonPrimitive() && jsonObject.getAsJsonPrimitive("item").isString();
    }

    @Override
    public void parseFromJson(JsonObject jsonObject) {
        this.item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jsonObject.getAsJsonPrimitive("item").getAsString()));
        this.count = GlobalResearch.parseItemCount(jsonObject);
    }

    public int hashCode() {
        int result = this.count;
        result = 31 * result + this.item.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleItemCost that = (SimpleItemCost)o;
        if (this.count != that.count) {
            return false;
        }
        return this.item.equals(that.item);
    }
}

