/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research.costs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.research.ModResearchCostTypes;
import com.minecolonies.api.research.costs.IResearchCost;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.research.GlobalResearch;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ListItemCost
implements IResearchCost {
    private final ModResearchCostTypes.ResearchCostType type;
    private int count;
    private List<Item> items;

    public ListItemCost(ModResearchCostTypes.ResearchCostType type) {
        this.type = type;
    }

    @Override
    public ModResearchCostTypes.ResearchCostType getType() {
        return this.type;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public List<Item> getItems() {
        return this.items;
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        this.items = NBTUtils.streamCompound(compound.m_128437_("cost-items", 10)).map(itemCompound -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemCompound.m_128461_("cost-item")))).toList();
        this.count = compound.m_128451_("cost-count");
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        ListTag itemList = this.items.stream().map(item -> {
            CompoundTag itemCompound = new CompoundTag();
            itemCompound.m_128359_("cost-item", ForgeRegistries.ITEMS.getKey(item).toString());
            return itemCompound;
        }).collect(NBTUtils.toListNBT());
        compound.m_128365_("cost-items", (Tag)itemList);
        compound.m_128405_("cost-count", this.count);
    }

    @Override
    public void serialize(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.count);
        buf.writeInt(this.items.size());
        for (Item item : this.items) {
            buf.writeRegistryId(ForgeRegistries.ITEMS, (Object)item);
        }
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.count = buf.readInt();
        this.items = new ArrayList<Item>();
        int itemCount = buf.readInt();
        for (int i = 0; i < itemCount; ++i) {
            this.items.add((Item)buf.readRegistryIdSafe(Item.class));
        }
    }

    @Override
    public boolean hasCorrectJsonFields(JsonObject jsonObject) {
        return jsonObject.has("item") && jsonObject.get("item").isJsonObject() && jsonObject.getAsJsonObject("item").has("items");
    }

    @Override
    public void parseFromJson(JsonObject jsonObject) {
        this.items = new ArrayList<Item>();
        for (JsonElement arrayItem : jsonObject.getAsJsonObject("item").getAsJsonArray("items")) {
            this.items.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(arrayItem.getAsJsonPrimitive().getAsString())));
        }
        this.count = GlobalResearch.parseItemCount(jsonObject);
    }

    public int hashCode() {
        int result = this.count;
        result = 31 * result + this.items.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListItemCost listItemCost = (ListItemCost)o;
        if (this.count != listItemCost.count) {
            return false;
        }
        return this.items.equals(listItemCost.items);
    }
}

