/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchCostTypes;
import com.minecolonies.api.research.costs.IResearchCost;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.effects.registry.IResearchEffectRegistry;
import com.minecolonies.api.research.effects.registry.ResearchEffectEntry;
import com.minecolonies.api.research.factories.IGlobalResearchFactory;
import com.minecolonies.api.research.registry.IResearchRequirementRegistry;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.research.GlobalResearch;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class GlobalResearchFactory
implements IGlobalResearchFactory {
    @Override
    @NotNull
    public TypeToken<GlobalResearch> getFactoryOutputType() {
        return TypeToken.of(GlobalResearch.class);
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public IGlobalResearch getNewInstance(ResourceLocation id, ResourceLocation branch, ResourceLocation parent, TranslatableContents desc, int universityLevel, int sortOrder, ResourceLocation iconTexture, ItemStack iconStack, TranslatableContents subtitle, boolean onlyChild, boolean hidden, boolean autostart, boolean instant, boolean immutable) {
        return new GlobalResearch(id, branch, parent, desc, universityLevel, sortOrder, iconTexture, iconStack, subtitle, onlyChild, hidden, autostart, instant, immutable);
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull IGlobalResearch research) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("parent", research.getParent().toString());
        compound.m_128359_("id", research.getId().toString());
        compound.m_128359_("branch", research.getBranch().toString());
        compound.m_128359_("name", research.getName().m_237508_());
        compound.m_128405_("depth", research.getDepth());
        compound.m_128405_("sort", research.getSortOrder());
        compound.m_128379_("onlyChild", research.hasOnlyChild());
        compound.m_128359_("icon_tex", research.getIconTextureResourceLocation().toString());
        compound.m_128359_("icon_is", ForgeRegistries.ITEMS.getKey((Object)research.getIconItemStack().m_41720_()) + ":" + research.getIconItemStack().m_41613_());
        compound.m_128359_("subtitle", research.getSubtitle().m_237508_());
        compound.m_128379_("instant", research.isInstant());
        compound.m_128379_("autostart", research.isAutostart());
        compound.m_128379_("immutable", research.isImmutable());
        compound.m_128379_("hidden", research.isHidden());
        @NotNull ListTag costTagList = research.getCostList().stream().map(cost -> {
            CompoundTag costCompound = new CompoundTag();
            costCompound.m_128359_("cost-type", cost.getType().getId().toString());
            cost.write(costCompound);
            return compound;
        }).collect(NBTUtils.toListNBT());
        compound.m_128365_("cost", (Tag)costTagList);
        @NotNull ListTag reqTagList = research.getResearchRequirement().stream().map(req -> {
            CompoundTag reqCompound = new CompoundTag();
            reqCompound.m_128359_("requirement-type", req.getRegistryEntry().getRegistryName().toString());
            reqCompound.m_128365_("requirement-item", (Tag)req.writeToNBT());
            return reqCompound;
        }).collect(NBTUtils.toListNBT());
        compound.m_128365_("requirements", (Tag)reqTagList);
        @NotNull ListTag effectTagList = research.getEffects().stream().map(eff -> {
            CompoundTag effectCompound = new CompoundTag();
            effectCompound.m_128359_("effect-type", eff.getRegistryEntry().getRegistryName().toString());
            effectCompound.m_128365_("effect-item", (Tag)eff.writeToNBT());
            return effectCompound;
        }).collect(NBTUtils.toListNBT());
        compound.m_128365_("effects", (Tag)effectTagList);
        @NotNull ListTag childTagList = research.getChildren().stream().map(child -> {
            CompoundTag childCompound = new CompoundTag();
            childCompound.m_128359_("child", child.toString());
            return childCompound;
        }).collect(NBTUtils.toListNBT());
        compound.m_128365_("hasResearchedChild", (Tag)childTagList);
        return compound;
    }

    @Override
    @NotNull
    public IGlobalResearch deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        ResourceLocation parent = new ResourceLocation(nbt.m_128461_("parent"));
        ResourceLocation id = new ResourceLocation(nbt.m_128461_("id"));
        ResourceLocation branch = new ResourceLocation(nbt.m_128461_("branch"));
        TranslatableContents desc = new TranslatableContents(nbt.m_128461_("name"), null, TranslatableContents.f_237494_);
        int depth = nbt.m_128451_("depth");
        int sortOrder = nbt.m_128451_("sort");
        boolean onlyChild = nbt.m_128471_("onlyChild");
        ResourceLocation iconTexture = new ResourceLocation(nbt.m_128461_("icon_tex"));
        String[] iconStackParts = nbt.m_128461_("icon_is").split(":");
        ItemStack iconStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(iconStackParts[0], iconStackParts[1])));
        iconStack.m_41764_(Integer.parseInt(iconStackParts[2]));
        TranslatableContents subtitle = new TranslatableContents(nbt.m_128461_("subtitle"), null, TranslatableContents.f_237494_);
        boolean instant = nbt.m_128471_("instant");
        boolean autostart = nbt.m_128471_("autostart");
        boolean immutable = nbt.m_128471_("immutable");
        boolean hidden = nbt.m_128471_("hidden");
        IGlobalResearch research = this.getNewInstance(id, branch, parent, desc, depth, sortOrder, iconTexture, iconStack, subtitle, onlyChild, hidden, autostart, instant, immutable);
        NBTUtils.streamCompound(nbt.m_128437_("cost", 10)).forEach(compound -> {
            ResourceLocation res = compound.m_128441_("cost-type") ? new ResourceLocation(compound.m_128461_("cost-type")) : ModResearchCostTypes.SIMPLE_ITEM_COST_ID;
            ModResearchCostTypes.ResearchCostType researchCostType = (ModResearchCostTypes.ResearchCostType)IMinecoloniesAPI.getInstance().getResearchCostRegistry().getValue(res);
            IResearchCost instance = researchCostType.createInstance();
            instance.read((CompoundTag)compound);
            research.addCost(instance);
        });
        NBTUtils.streamCompound(nbt.m_128437_("requirements", 10)).forEach(compound -> research.addRequirement(Objects.requireNonNull((ResearchRequirementEntry)IResearchRequirementRegistry.getInstance().getValue(ResourceLocation.m_135820_((String)compound.m_128461_("requirement-type")))).readFromNBT(compound.m_128469_("requirement-item"))));
        NBTUtils.streamCompound(nbt.m_128437_("effects", 10)).forEach(compound -> research.addEffect(Objects.requireNonNull((ResearchEffectEntry)IResearchEffectRegistry.getInstance().getValue(ResourceLocation.m_135820_((String)compound.m_128461_("effect-type")))).readFromNBT(compound.m_128469_("effect-item"))));
        NBTUtils.streamCompound(nbt.m_128437_("hasResearchedChild", 10)).forEach(compound -> research.addChild(new ResourceLocation(compound.m_128461_("child"))));
        return research;
    }

    @Override
    public void serialize(@NotNull IFactoryController controller, IGlobalResearch input, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130085_(input.getParent());
        packetBuffer.m_130085_(input.getId());
        packetBuffer.m_130085_(input.getBranch());
        packetBuffer.m_130070_(input.getName().m_237508_());
        packetBuffer.m_130130_(input.getDepth());
        packetBuffer.m_130130_(input.getSortOrder());
        packetBuffer.writeBoolean(input.hasOnlyChild());
        packetBuffer.m_130055_(input.getIconItemStack());
        packetBuffer.m_130085_(input.getIconTextureResourceLocation());
        packetBuffer.m_130070_(input.getSubtitle().m_237508_());
        packetBuffer.writeBoolean(input.isInstant());
        packetBuffer.writeBoolean(input.isAutostart());
        packetBuffer.writeBoolean(input.isImmutable());
        packetBuffer.writeBoolean(input.isHidden());
        packetBuffer.m_130130_(input.getCostList().size());
        for (IResearchCost iResearchCost : input.getCostList()) {
            packetBuffer.writeRegistryId(IMinecoloniesAPI.getInstance().getResearchCostRegistry(), (Object)iResearchCost.getType());
            iResearchCost.serialize(packetBuffer);
        }
        packetBuffer.m_130130_(input.getResearchRequirement().size());
        for (IResearchRequirement iResearchRequirement : input.getResearchRequirement()) {
            packetBuffer.m_130085_(iResearchRequirement.getRegistryEntry().getRegistryName());
            packetBuffer.m_130079_(iResearchRequirement.writeToNBT());
        }
        packetBuffer.m_130130_(input.getEffects().size());
        for (IResearchEffect iResearchEffect : input.getEffects()) {
            packetBuffer.m_130085_(iResearchEffect.getRegistryEntry().getRegistryName());
            packetBuffer.m_130079_(iResearchEffect.writeToNBT());
        }
        packetBuffer.m_130130_(input.getChildren().size());
        for (ResourceLocation resourceLocation : input.getChildren()) {
            packetBuffer.m_130085_(resourceLocation);
        }
    }

    @Override
    @NotNull
    public IGlobalResearch deserialize(@NotNull IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        ResourceLocation parent = buffer.m_130281_();
        ResourceLocation id = buffer.m_130281_();
        ResourceLocation branch = buffer.m_130281_();
        TranslatableContents desc = new TranslatableContents(buffer.m_130277_(), null, TranslatableContents.f_237494_);
        int depth = buffer.m_130242_();
        int sortOrder = buffer.m_130242_();
        boolean hasOnlyChild = buffer.readBoolean();
        ItemStack iconStack = buffer.m_130267_();
        ResourceLocation iconTexture = buffer.m_130281_();
        TranslatableContents subtitle = new TranslatableContents(buffer.m_130277_(), null, TranslatableContents.f_237494_);
        boolean instant = buffer.readBoolean();
        boolean autostart = buffer.readBoolean();
        boolean immutable = buffer.readBoolean();
        boolean hidden = buffer.readBoolean();
        IGlobalResearch research = this.getNewInstance(id, branch, parent, desc, depth, sortOrder, iconTexture, iconStack, subtitle, hasOnlyChild, hidden, autostart, instant, immutable);
        int costSize = buffer.m_130242_();
        for (int i = 0; i < costSize; ++i) {
            ModResearchCostTypes.ResearchCostType researchCostType = (ModResearchCostTypes.ResearchCostType)buffer.readRegistryIdSafe(ModResearchCostTypes.ResearchCostType.class);
            IResearchCost cost = researchCostType.createInstance();
            cost.deserialize(buffer);
            research.addCost(cost);
        }
        int reqCount = buffer.m_130242_();
        for (int i = 0; i < reqCount; ++i) {
            ResourceLocation reqId = buffer.m_130281_();
            research.addRequirement(Objects.requireNonNull((ResearchRequirementEntry)IResearchRequirementRegistry.getInstance().getValue(reqId)).readFromNBT(buffer.m_130260_()));
        }
        int effectCount = buffer.m_130242_();
        for (int i = 0; i < effectCount; ++i) {
            ResourceLocation effectId = buffer.m_130281_();
            research.addEffect(Objects.requireNonNull((ResearchEffectEntry)IResearchEffectRegistry.getInstance().getValue(effectId)).readFromNBT(buffer.m_130260_()));
        }
        int childCount = buffer.m_130242_();
        for (int i = 0; i < childCount; ++i) {
            research.addChild(buffer.m_130281_());
        }
        return research;
    }

    @Override
    public short getSerializationId() {
        return 28;
    }
}

