/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.quests.rewards;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestRewardTemplate;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.CitizenData;
import net.minecraft.world.entity.player.Player;

public class RelationshipRewardTemplate
implements IQuestRewardTemplate {
    private final int target1;
    private final int target2;
    private final String type;

    public RelationshipRewardTemplate(int target1, int target2, String type) {
        this.target1 = target1;
        this.target2 = target2;
        this.type = type;
    }

    public static IQuestRewardTemplate createReward(JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int target1 = details.get("target1").getAsInt();
        int target2 = details.get("target2").getAsInt();
        String type = jsonObject.get("type").getAsString();
        return new RelationshipRewardTemplate(target1, target2, type);
    }

    @Override
    public void applyReward(IColony colony, Player player, IQuestInstance colonyQuest) {
        try {
            CitizenData citTarget1 = this.target1 == 0 ? (CitizenData)colonyQuest.getQuestGiver() : (CitizenData)colonyQuest.getParticipant(this.target1);
            CitizenData citTarget2 = this.target2 == 0 ? (CitizenData)colonyQuest.getQuestGiver() : (CitizenData)colonyQuest.getParticipant(this.target2);
            if (citTarget1 != null && citTarget2 != null) {
                if (this.type.equals("couple")) {
                    if (citTarget1.getPartner() == null && citTarget2.getPartner() == null) {
                        citTarget1.setPartner(citTarget2.getId());
                        citTarget2.setPartner(citTarget1.getId());
                    }
                } else if (citTarget1.getPartner() != null && citTarget2.getPartner() != null && citTarget1.getPartner().getId() == citTarget2.getId() && citTarget2.getPartner().getId() == citTarget1.getId()) {
                    citTarget1.setPartner(0);
                    citTarget2.setPartner(0);
                }
            }
        }
        catch (Exception ex) {
            Log.getLogger().warn("Couldn't apply relationship quest reward. Probably one of the citizens is missing.");
        }
    }
}

