/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.quests.objectives;

import com.google.gson.JsonObject;
import com.minecolonies.api.quests.IDialogueObjectiveTemplate;
import com.minecolonies.api.quests.IObjectiveInstance;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.event.QuestObjectiveEventHandler;
import com.minecolonies.coremod.quests.objectives.DialogueObjectiveTemplateTemplate;
import com.minecolonies.coremod.quests.objectives.IBreakBlockObjectiveTemplate;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BreakBlockObjectiveTemplate
extends DialogueObjectiveTemplateTemplate
implements IBreakBlockObjectiveTemplate {
    private final int blocksToMine;
    private final Block blockToMine;
    private final int nextObjective;

    public BreakBlockObjectiveTemplate(int target, int blocksToMine, Block blockToMine, int nextObjective, List<Integer> rewards) {
        super(target, BreakBlockObjectiveTemplate.buildDialogueTree(blockToMine), rewards);
        this.blocksToMine = blocksToMine;
        this.nextObjective = nextObjective;
        this.blockToMine = blockToMine;
    }

    @NotNull
    private static IDialogueObjectiveTemplate.DialogueElement buildDialogueTree(Block blockToMine) {
        MutableComponent text = Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.breakblock", (Object[])new Object[]{blockToMine.m_49954_()});
        IDialogueObjectiveTemplate.AnswerElement answer1 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.later"), new IQuestDialogueAnswer.CloseUIDialogueAnswer());
        IDialogueObjectiveTemplate.AnswerElement answer2 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.cancel"), new IQuestDialogueAnswer.QuestCancellationDialogueAnswer());
        return new IDialogueObjectiveTemplate.DialogueElement((Component)text, List.of(answer1, answer2));
    }

    public static IQuestObjectiveTemplate createObjective(JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int target = details.get("target").getAsInt();
        int quantity = details.get("qty").getAsInt();
        Block block = (Block)((Holder)ForgeRegistries.BLOCKS.getHolder(new ResourceLocation(details.get("block").getAsString())).get()).get();
        int nextObj = details.has("next-objective") ? details.get("next-objective").getAsInt() : -1;
        return new BreakBlockObjectiveTemplate(target, quantity, block, nextObj, BreakBlockObjectiveTemplate.parseRewards(jsonObject));
    }

    @Override
    public IObjectiveInstance startObjective(IQuestInstance colonyQuest) {
        super.startObjective(colonyQuest);
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.addQuestMineObjectiveListener(this.blockToMine, colonyQuest.getAssignedPlayer(), colonyQuest);
        }
        return this.createObjectiveInstance();
    }

    @Override
    public Component getProgressText(IQuestInstance quest, Style style) {
        IObjectiveInstance iObjectiveInstance = quest.getCurrentObjectiveInstance();
        if (iObjectiveInstance instanceof BlockMiningProgressInstance) {
            BlockMiningProgressInstance progress = (BlockMiningProgressInstance)iObjectiveInstance;
            return Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.breakblock.progress", (Object[])new Object[]{progress.currentProgress, this.blocksToMine, this.blockToMine.m_49954_().m_6270_(style)});
        }
        return Component.m_237119_();
    }

    @Override
    @NotNull
    public IObjectiveInstance createObjectiveInstance() {
        return new BlockMiningProgressInstance(this);
    }

    @Override
    public void onCancellation(IQuestInstance colonyQuest) {
        this.cleanupListener(colonyQuest);
    }

    private void cleanupListener(IQuestInstance colonyQuest) {
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.removeQuestMineObjectiveListener(this.blockToMine, colonyQuest.getAssignedPlayer(), colonyQuest);
        }
    }

    @Override
    public void onBlockBreak(IObjectiveInstance blockMiningProgressData, IQuestInstance colonyQuest, Player player) {
        if (blockMiningProgressData.isFulfilled()) {
            return;
        }
        ++((BlockMiningProgressInstance)blockMiningProgressData).currentProgress;
        if (blockMiningProgressData.isFulfilled()) {
            this.cleanupListener(colonyQuest);
            colonyQuest.advanceObjective(player, this.nextObjective);
        }
    }

    @Override
    public void onWorldLoad(IQuestInstance colonyQuest) {
        super.onWorldLoad(colonyQuest);
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.addQuestMineObjectiveListener(this.blockToMine, colonyQuest.getAssignedPlayer(), colonyQuest);
        }
    }

    private static class BlockMiningProgressInstance
    implements IObjectiveInstance {
        private int currentProgress = 0;
        private final BreakBlockObjectiveTemplate template;

        public BlockMiningProgressInstance(IQuestObjectiveTemplate template) {
            this.template = (BreakBlockObjectiveTemplate)template;
        }

        @Override
        public boolean isFulfilled() {
            return this.currentProgress >= this.template.blocksToMine;
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("quantity", this.currentProgress);
            return compoundTag;
        }

        @Override
        public int getMissingQuantity() {
            return this.template.blocksToMine > this.currentProgress ? this.template.blocksToMine - this.currentProgress : 0;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.currentProgress = nbt.m_128451_("quantity");
        }
    }
}

