/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.placementhandlers.main;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.StructurePlacementUtils;
import com.ldtteam.structurize.storage.ISurvivalBlueprintHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.coremod.MineColonies;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SuppliesHandler
implements ISurvivalBlueprintHandler {
    public static final String ID = "minecolonies:supplies";

    public String getId() {
        return ID;
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)"com.minecolonies.coremod.supplies.placement");
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canHandle(Blueprint blueprint, ClientLevel clientLevel, Player player, BlockPos blockPos, PlacementSettings placementSettings) {
        return false;
    }

    public void handle(Blueprint blueprint, String packName, String blueprintPath, boolean clientPack, Level world, Player playerArg, BlockPos blockPos, PlacementSettings placementSettings) {
        int slot;
        if (clientPack || !StructurePacks.hasPack((String)packName)) {
            MessageUtils.format("com.minecolonies.coremod.structures.nocustomcamps", new Object[0]).sendTo(playerArg);
            SoundUtils.playErrorSound(playerArg, playerArg.m_20183_());
            return;
        }
        ServerPlayer player = (ServerPlayer)playerArg;
        blueprint.rotateWithMirror(placementSettings.rotation, placementSettings.mirror == Mirror.NONE ? Mirror.NONE : Mirror.FRONT_BACK, world);
        if (!(player.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)ModItems.supplyChest)) <= 0 || ((Boolean)MineColonies.getConfig().getServer().allowInfiniteSupplyChests.get()).booleanValue() || this.isFreeInstantPlacementMH(player) || player.m_7500_())) {
            MessageUtils.format("com.minecolonies.coremod.error.supplychestalreadyplaced", new Object[0]).sendTo(new Player[]{player});
            SoundUtils.playErrorSound((Player)player, player.m_20183_());
            return;
        }
        Predicate<ItemStack> searchPredicate = stack -> !stack.m_41619_();
        if (blueprintPath.contains("supplyship")) {
            searchPredicate = searchPredicate.and(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, new ItemStack((ItemLike)ModItems.supplyChest), true, false));
        }
        if (blueprintPath.contains("supplycamp")) {
            searchPredicate = searchPredicate.and(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, new ItemStack((ItemLike)ModItems.supplyCamp), true, false));
        }
        if (this.isFreeInstantPlacementMH(player)) {
            searchPredicate = searchPredicate.and(stack -> stack.m_41782_() && stack.m_41783_().m_128423_(Constants.PLACEMENT_NBT) != null && stack.m_41783_().m_128461_(Constants.PLACEMENT_NBT).equals(Constants.INSTANT_PLACEMENT));
        }
        if ((slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)new InvWrapper((Container)player.m_150109_()), searchPredicate)) != -1 && !ItemStackUtils.isEmpty(player.m_150109_().m_8016_(slot))) {
            if (player.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)ModItems.supplyChest)) < 1) {
                MessageUtils.format("com.minecolonies.coremod.progress.supplies_placed", new Object[0]).sendTo(new Player[]{player});
                player.m_6278_(Stats.f_12982_.m_12902_((Object)ModItems.supplyChest), 1);
                AdvancementTriggers.PLACE_SUPPLY.trigger(player);
            }
            SoundUtils.playSuccessSound((Player)player, player.m_20183_());
            StructurePlacementUtils.loadAndPlaceStructureWithRotation((Level)player.f_19853_, (Blueprint)blueprint, (BlockPos)blockPos, (Rotation)placementSettings.getRotation(), (Mirror)(placementSettings.getMirror() != Mirror.NONE ? Mirror.FRONT_BACK : Mirror.NONE), (boolean)true, (ServerPlayer)player);
        } else {
            MessageUtils.format("item.supplychestdeployer.missing", new Object[0]).sendTo(new Player[]{player});
        }
    }

    private boolean isFreeInstantPlacementMH(ServerPlayer playerEntity) {
        ItemStack mhItem = playerEntity.m_21205_();
        return !ItemStackUtils.isEmpty(mhItem) && mhItem.m_41783_() != null && mhItem.m_41783_().m_128461_(Constants.PLACEMENT_NBT).equals(Constants.INSTANT_PLACEMENT);
    }
}

