/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.worker;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IAssignsCitizen;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class BuildingHiringModeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private HiringMode mode;
    private int moduleId;

    public BuildingHiringModeMessage() {
    }

    public BuildingHiringModeMessage(@NotNull IBuildingView building, HiringMode mode, int moduleId) {
        super(building);
        this.mode = mode;
        this.moduleId = moduleId;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.mode = HiringMode.values()[buf.readInt()];
        this.moduleId = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.mode.ordinal());
        buf.writeInt(this.moduleId);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.moduleId);
        if (iBuildingModule instanceof IAssignsCitizen) {
            IAssignsCitizen module = (IAssignsCitizen)iBuildingModule;
            module.setHiringMode(this.mode);
        }
    }
}

