/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.fields;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.modules.FieldsModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AssignmentModeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int id;
    private boolean assignmentMode;

    public AssignmentModeMessage() {
    }

    public AssignmentModeMessage(@NotNull IBuildingView building, boolean assignmentMode, int runtimeID) {
        super(building);
        this.assignmentMode = assignmentMode;
        this.id = runtimeID;
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.assignmentMode);
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.assignmentMode = buf.readBoolean();
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        if (building.hasModule(FieldsModule.class)) {
            ((FieldsModule)building.getModule(this.id)).setAssignManually(this.assignmentMode);
        }
    }
}

