/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IMinimumStockModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class RemoveMinimumStockFromBuildingModuleMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int moduleId;
    private ItemStack itemStack;

    public RemoveMinimumStockFromBuildingModuleMessage() {
    }

    public RemoveMinimumStockFromBuildingModuleMessage(IBuildingView building, ItemStack itemStack, int moduleId) {
        super(building);
        this.itemStack = itemStack;
        this.moduleId = moduleId;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.itemStack = buf.m_130267_();
        this.moduleId = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.m_130055_(this.itemStack);
        buf.writeInt(this.moduleId);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.moduleId);
        if (iBuildingModule instanceof IMinimumStockModule) {
            IMinimumStockModule module = (IMinimumStockModule)iBuildingModule;
            module.removeMinimumStock(this.itemStack);
        }
    }
}

