/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.modules.QuarryModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class QuarryHiringModeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private HiringMode mode;
    private int moduleID;

    public QuarryHiringModeMessage() {
    }

    public QuarryHiringModeMessage(@NotNull IBuildingView building, HiringMode mode, int moduleID) {
        super(building);
        this.mode = mode;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.mode = HiringMode.values()[buf.readInt()];
        this.moduleID = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.mode.ordinal());
        buf.writeInt(this.moduleID);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.moduleID);
        if (iBuildingModule instanceof QuarryModule) {
            QuarryModule module = (QuarryModule)iBuildingModule;
            module.setHiringMode(this.mode);
        }
    }
}

