/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class HireFireMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private boolean hire;
    private int citizenID;
    private int moduleId;

    public HireFireMessage() {
    }

    public HireFireMessage(@NotNull IBuildingView building, boolean hire, int citizenID, int moduleId) {
        super(building);
        this.hire = hire;
        this.citizenID = citizenID;
        this.moduleId = moduleId;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.hire = buf.readBoolean();
        this.citizenID = buf.readInt();
        this.moduleId = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(this.hire);
        buf.writeInt(this.citizenID);
        buf.writeInt(this.moduleId);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.moduleId);
        if (iBuildingModule instanceof IAssignsJob) {
            IAssignsJob module = (IAssignsJob)iBuildingModule;
            ICitizenData citizen = colony.getCitizenManager().getCivilian(this.citizenID);
            citizen.setPaused(false);
            if (this.hire) {
                module.assignCitizen(citizen);
            } else {
                module.removeCitizen(citizen);
            }
        }
    }
}

