/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.modules.CourierAssignmentModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class CourierHiringModeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int id;
    private HiringMode mode;

    public CourierHiringModeMessage() {
    }

    public CourierHiringModeMessage(@NotNull IBuildingView building, HiringMode mode, int id) {
        super(building);
        this.mode = mode;
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.mode = HiringMode.values()[buf.readInt()];
        this.id = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.mode.ordinal());
        buf.writeInt(this.id);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (iBuildingModule instanceof CourierAssignmentModule) {
            CourierAssignmentModule module = (CourierAssignmentModule)iBuildingModule;
            module.setHiringMode(this.mode);
        }
    }
}

