/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AssignFilterableItemMessage
extends AbstractBuildingServerMessage<AbstractBuilding> {
    private boolean assign;
    private ItemStorage item;
    private int id;

    public AssignFilterableItemMessage() {
    }

    public AssignFilterableItemMessage(IBuildingView building, int id, ItemStorage item, boolean assign) {
        super(building);
        this.assign = assign;
        this.item = item;
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.assign = buf.readBoolean();
        this.item = new ItemStorage(buf.m_130267_());
        this.id = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(this.assign);
        buf.m_130055_(this.item.getItemStack());
        buf.writeInt(this.id);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, AbstractBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (iBuildingModule instanceof ItemListModule) {
            ItemListModule module = (ItemListModule)iBuildingModule;
            if (this.assign) {
                module.addItem(this.item);
            } else {
                module.removeItem(this.item);
            }
        }
    }
}

