/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import com.minecolonies.coremod.network.messages.server.colony.ChangeFreeToInteractBlockMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ItemScepterPermission
extends AbstractItemMinecolonies {
    private static final String TAG_ITEM_MODE = "scepterMode";
    private static final String TAG_VALUE_MODE_BLOCK = "modeBlock";
    private static final String TAG_VALUE_MODE_LOCATION = "modeLocation";

    public ItemScepterPermission(Item.Properties properties) {
        super("scepterpermission", properties.m_41487_(1).m_41503_(2));
    }

    @NotNull
    private static InteractionResult handleAddBlockType(Player playerIn, Level worldIn, BlockPos pos, IColonyView iColonyView) {
        BlockState blockState = iColonyView.getWorld().m_8055_(pos);
        Block block = blockState.m_60734_();
        ChangeFreeToInteractBlockMessage message = new ChangeFreeToInteractBlockMessage(iColonyView, block, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK);
        Network.getNetwork().sendToServer(message);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    private static InteractionResult handleAddLocation(Player playerIn, Level worldIn, BlockPos pos, IColonyView iColonyView) {
        ChangeFreeToInteractBlockMessage message = new ChangeFreeToInteractBlockMessage(iColonyView, pos, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK);
        Network.getNetwork().sendToServer(message);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        IColonyView iColonyView;
        if (!ctx.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack scepter = ctx.m_43723_().m_21120_(ctx.m_43724_());
        if (!scepter.m_41782_()) {
            scepter.m_41751_(new CompoundTag());
        }
        if ((iColonyView = IColonyManager.getInstance().getClosestColonyView(ctx.m_43725_(), ctx.m_8083_())) == null) {
            return InteractionResult.FAIL;
        }
        CompoundTag compound = scepter.m_41783_();
        return ItemScepterPermission.handleItemAction(compound, ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), iColonyView);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack scepter = playerIn.m_21120_(hand);
        if (worldIn.f_46443_) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)scepter);
        }
        if (!scepter.m_41782_()) {
            scepter.m_41751_(new CompoundTag());
        }
        CompoundTag compound = scepter.m_41783_();
        ItemScepterPermission.toggleItemMode(playerIn, compound);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)scepter);
    }

    private static void toggleItemMode(Player playerIn, CompoundTag compound) {
        String itemMode;
        switch (itemMode = compound.m_128461_(TAG_ITEM_MODE)) {
            case "modeBlock": {
                compound.m_128359_(TAG_ITEM_MODE, TAG_VALUE_MODE_LOCATION);
                MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.setmode", MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.mode.location", new Object[0]).create()).sendTo(playerIn);
                break;
            }
            default: {
                compound.m_128359_(TAG_ITEM_MODE, TAG_VALUE_MODE_BLOCK);
                MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.setmode", MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.mode.block", new Object[0]).create()).sendTo(playerIn);
            }
        }
    }

    @NotNull
    private static InteractionResult handleItemAction(CompoundTag compound, Player playerIn, Level worldIn, BlockPos pos, IColonyView iColonyView) {
        String tagItemMode;
        switch (tagItemMode = compound.m_128461_(TAG_ITEM_MODE)) {
            case "modeBlock": {
                return ItemScepterPermission.handleAddBlockType(playerIn, worldIn, pos, iColonyView);
            }
            case "modeLocation": {
                return ItemScepterPermission.handleAddLocation(playerIn, worldIn, pos, iColonyView);
            }
        }
        ItemScepterPermission.toggleItemMode(playerIn, compound);
        return ItemScepterPermission.handleItemAction(compound, playerIn, worldIn, pos, iColonyView);
    }
}

