/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults.workers;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.generation.CustomRecipeAndLootTableProvider;
import com.minecolonies.coremod.generation.CustomRecipeProvider;
import com.minecolonies.coremod.generation.DatagenLootTableManager;
import com.minecolonies.coremod.generation.SimpleLootTableProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DefaultNetherWorkerLootProvider
extends CustomRecipeAndLootTableProvider {
    public static final String NETHERWORKER = ModJobs.NETHERWORKER_ID.m_135815_();
    private static final int MAX_BUILDING_LEVEL = 5;
    private final DatagenLootTableManager lootTableManager;
    private final List<LootTable.Builder> levels;

    public DefaultNetherWorkerLootProvider(@NotNull PackOutput packOutput, @NotNull DatagenLootTableManager lootTableManager) {
        super(packOutput);
        this.lootTableManager = lootTableManager;
        this.levels = new ArrayList<LootTable.Builder>();
        for (int buildingLevel = 1; buildingLevel <= 5; ++buildingLevel) {
            this.levels.add(this.createTripLoot(buildingLevel));
        }
    }

    private LootTable.Builder createTripLoot(int buildingLevel) {
        return new LootTable.Builder().m_79161_(this.createBlocksPool(buildingLevel)).m_79161_(this.createMobsPool(buildingLevel));
    }

    @NotNull
    private LootPool.Builder createBlocksPool(int buildingLevel) {
        LootPool.Builder blocks = new LootPool.Builder().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)10.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.3f));
        blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42048_).m_79707_(20).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)25.0f))));
        blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42049_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)7.0f))));
        blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42050_).m_79707_(8).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f))));
        blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41832_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)10.0f))));
        blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42154_).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))));
        if (buildingLevel >= 2) {
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42054_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f))));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41952_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41953_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42488_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f))));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41954_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41843_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
        }
        if (buildingLevel >= 3) {
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42051_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42541_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f))));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41955_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41844_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_220220_).m_79707_(2));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_220222_).m_79707_(1));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_220221_).m_79707_(1));
        }
        if (buildingLevel >= 4) {
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41836_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))));
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42755_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
        }
        if (buildingLevel >= 5) {
            blocks.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42792_).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))));
        }
        return blocks;
    }

    @NotNull
    private LootPool.Builder createMobsPool(int buildingLevel) {
        LootPool.Builder mobs = new LootPool.Builder().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)6.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.1f));
        mobs.m_79076_((LootPoolEntryContainer.Builder)this.createAdventureToken(EntityType.f_20531_, 5, 5).m_79707_(5500).m_79711_(-10));
        mobs.m_79076_((LootPoolEntryContainer.Builder)this.createAdventureToken(EntityType.f_20468_, 3, 4).m_79707_(300).m_79711_(10));
        mobs.m_79076_((LootPoolEntryContainer.Builder)this.createAdventureToken(EntityType.f_20456_, 3, 5).m_79707_(500).m_79711_(-1));
        mobs.m_79076_((LootPoolEntryContainer.Builder)this.createAdventureToken(EntityType.f_20453_, 12, 5).m_79707_(300).m_79711_(-3));
        mobs.m_79076_((LootPoolEntryContainer.Builder)this.createAdventureToken(EntityType.f_20566_, 7, 5).m_79707_(300).m_79711_(-3));
        mobs.m_79076_((LootPoolEntryContainer.Builder)this.createAdventureToken(EntityType.f_20551_, 5, 10).m_79707_(100).m_79711_(1));
        return mobs;
    }

    private LootPoolSingletonContainer.Builder<?> createAdventureToken(@NotNull EntityType<?> mob, int damage_done, int xp_gained) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("entity-type", ForgeRegistries.ENTITY_TYPES.getKey(mob).toString());
        nbt.m_128405_("damage-done", damage_done);
        nbt.m_128405_("xp-dropped", xp_gained);
        ItemStack stack = new ItemStack((ItemLike)ModItems.adventureToken);
        stack.m_41751_(nbt);
        return SimpleLootTableProvider.itemStack(stack);
    }

    @NotNull
    public String m_6055_() {
        return "NetherWorkerLootProvider";
    }

    @Override
    protected void registerRecipes(@NotNull Consumer<FinishedRecipe> consumer) {
        List<ItemStorage> inputs = Arrays.asList(new ItemStorage(new ItemStack((ItemLike)Items.f_42594_, 64)), new ItemStorage(new ItemStack((ItemLike)Items.f_42000_, 32)), new ItemStorage(new ItemStack((ItemLike)Items.f_41963_, 16)));
        for (int i = 0; i < this.levels.size(); ++i) {
            int buildingLevel = i + 1;
            List<LootTableAnalyzer.LootDrop> drops = LootTableAnalyzer.toDrops((LootDataManager)this.lootTableManager, this.levels.get(i).m_79167_());
            Stream<ItemStack> loot = drops.stream().flatMap(drop -> drop.getItemStacks().stream().sorted(Comparator.comparing(ItemStack::m_41613_).reversed().thenComparing(ItemStack::m_41778_)).map(ItemStack::m_41720_));
            CustomRecipeProvider.CustomRecipeBuilder.create(NETHERWORKER, "custom", "trip" + buildingLevel).minBuildingLevel(buildingLevel).maxBuildingLevel(buildingLevel).inputs(inputs).secondaryOutputs(loot.map(ItemStack::new).collect(Collectors.toList())).lootTable(new ResourceLocation("minecolonies", "recipes/" + NETHERWORKER + "/trip" + buildingLevel)).build(consumer);
        }
        CustomRecipeProvider.CustomRecipeBuilder.create(NETHERWORKER, "custom", "lava").inputs(Collections.singletonList(new ItemStorage(new ItemStack((ItemLike)Items.f_42446_)))).result(new ItemStack((ItemLike)Items.f_42448_)).build(consumer);
    }

    @Override
    protected void registerTables(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        for (int i = 0; i < this.levels.size(); ++i) {
            int buildingLevel = i + 1;
            LootTable.Builder lootTable = this.levels.get(i);
            registrar.register(new ResourceLocation("minecolonies", "recipes/" + NETHERWORKER + "/trip" + buildingLevel), LootContextParamSets.f_81420_, lootTable);
        }
    }
}

