/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenItemHandler;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.client.BlockParticleEffectMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenItemHandler
implements ICitizenItemHandler {
    private final AbstractEntityCitizen citizen;

    public CitizenItemHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void tryPickupItemEntity(@NotNull ItemEntity itemEntity) {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).f_46443_) {
            if (itemEntity.m_32063_()) {
                return;
            }
            ItemStack itemStack = itemEntity.m_32055_();
            ItemStack compareStack = itemStack.m_41777_();
            if (this.citizen.getCitizenJobHandler().getColonyJob() == null || this.citizen.getCitizenJobHandler().getColonyJob().pickupSuccess(compareStack)) {
                int resultingStackSize;
                ItemStack resultStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)this.citizen.getInventoryCitizen(), itemStack);
                int n = resultingStackSize = ItemStackUtils.isEmpty(resultStack) ? 0 : ItemStackUtils.getSize(resultStack);
                if (ItemStackUtils.isEmpty(resultStack) || ItemStackUtils.getSize(resultStack) != ItemStackUtils.getSize(compareStack)) {
                    CompatibilityUtils.getWorldFromCitizen(this.citizen).m_5594_(null, this.citizen.m_20183_(), SoundEvents.f_12019_, SoundSource.AMBIENT, 0.2f, (float)((this.citizen.m_217043_().m_188583_() * 0.7 + 1.0) * 2.0));
                    this.citizen.m_7938_((Entity)itemEntity, ItemStackUtils.getSize(itemStack) - resultingStackSize);
                    ItemStack overrulingStack = itemStack.m_41777_();
                    overrulingStack.m_41764_(ItemStackUtils.getSize(itemStack) - resultingStackSize);
                    if (this.citizen.getCitizenJobHandler().getColonyJob() != null) {
                        this.citizen.getCitizenJobHandler().getColonyJob().onStackPickUp(overrulingStack);
                    }
                    if (ItemStackUtils.isEmpty(resultStack)) {
                        itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                }
            } else {
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    public void removeHeldItem() {
        this.citizen.m_8061_(EquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
    }

    @Override
    public void setHeldItem(InteractionHand hand, int slot) {
        this.citizen.getCitizenData().getInventory().setHeldItem(hand, slot);
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            this.citizen.m_8061_(EquipmentSlot.MAINHAND, this.citizen.getCitizenData().getInventory().getStackInSlot(slot));
        } else if (hand.equals((Object)InteractionHand.OFF_HAND)) {
            this.citizen.m_8061_(EquipmentSlot.OFFHAND, this.citizen.getCitizenData().getInventory().getStackInSlot(slot));
        }
    }

    @Override
    public void setMainHeldItem(int slot) {
        this.citizen.getCitizenData().getInventory().setHeldItem(InteractionHand.MAIN_HAND, slot);
        this.citizen.m_8061_(EquipmentSlot.MAINHAND, this.citizen.getCitizenData().getInventory().getStackInSlot(slot));
    }

    @Override
    public void hitBlockWithToolInHand(@Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        this.hitBlockWithToolInHand(blockPos, false);
    }

    @Override
    public void hitBlockWithToolInHand(@Nullable BlockPos blockPos, boolean breakBlock) {
        if (blockPos == null) {
            return;
        }
        this.citizen.m_21563_().m_24950_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 10.0f, (float)this.citizen.m_8132_());
        this.citizen.m_6674_(this.citizen.m_7655_());
        BlockState blockState = CompatibilityUtils.getWorldFromCitizen(this.citizen).m_8055_(blockPos);
        Block block = blockState.m_60734_();
        if (breakBlock) {
            if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).f_46443_) {
                Network.getNetwork().sendToPosition(new BlockParticleEffectMessage(blockPos, CompatibilityUtils.getWorldFromCitizen(this.citizen).m_8055_(blockPos), -1), new PacketDistributor.TargetPoint((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 16.0, this.citizen.f_19853_.m_46472_()));
            }
            CompatibilityUtils.getWorldFromCitizen(this.citizen).m_5594_(null, blockPos, block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).m_56775_(), SoundSource.BLOCKS, block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).m_56773_(), block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).m_56774_());
            WorldUtil.removeBlock((LevelAccessor)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, false);
            this.damageItemInHand(this.citizen.m_7655_(), 1);
        } else {
            if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).f_46443_) {
                BlockPos vector = blockPos.m_121996_((Vec3i)this.citizen.m_20183_());
                Direction facing = Direction.m_122372_((float)vector.m_123341_(), (float)vector.m_123342_(), (float)vector.m_123343_()).m_122424_();
                Network.getNetwork().sendToPosition(new BlockParticleEffectMessage(blockPos, CompatibilityUtils.getWorldFromCitizen(this.citizen).m_8055_(blockPos), facing.ordinal()), new PacketDistributor.TargetPoint((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 16.0, this.citizen.f_19853_.m_46472_()));
            }
            CompatibilityUtils.getWorldFromCitizen(this.citizen).m_5594_(null, blockPos, block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).m_56775_(), SoundSource.BLOCKS, block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).m_56773_(), block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).m_56774_());
        }
    }

    @Override
    public void damageItemInHand(InteractionHand hand, int damage) {
        ItemStack heldItem = this.citizen.getCitizenData().getInventory().getHeldItem(hand);
        if (heldItem == null || heldItem.m_41619_()) {
            return;
        }
        if (this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.TOOL_DURABILITY) > 0.0 && this.citizen.m_217043_().m_188500_() > 1.0 / (1.0 + this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.TOOL_DURABILITY))) {
            return;
        }
        if (this.citizen.getCitizenData().getInventory().damageInventoryItem(this.citizen.getCitizenData().getInventory().getHeldItemSlot(hand), damage, this.citizen, item -> item.m_21190_(hand))) {
            if (hand == InteractionHand.MAIN_HAND) {
                this.citizen.m_8061_(EquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
            } else {
                this.citizen.m_8061_(EquipmentSlot.OFFHAND, ItemStackUtils.EMPTY);
            }
        }
    }

    @Override
    public void pickupItems() {
        for (ItemEntity item : CompatibilityUtils.getWorldFromCitizen(this.citizen).m_45976_(ItemEntity.class, new AABB(this.citizen.m_20183_()).m_82363_(2.0, 1.0, 2.0).m_82363_(-2.0, -1.0, -2.0))) {
            if (item == null || !item.m_6084_()) continue;
            this.tryPickupItemEntity(item);
        }
    }

    @Override
    public void breakBlockWithToolInHand(@Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        this.hitBlockWithToolInHand(blockPos, true);
    }

    @Override
    public ItemEntity entityDropItem(@NotNull ItemStack itemstack) {
        return this.citizen.m_5552_(itemstack, 0.0f);
    }

    @Override
    public void updateArmorDamage(double damage) {
        if (this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARMOR_DURABILITY) > 0.0 && this.citizen.m_217043_().m_188500_() > 1.0 / (1.0 + this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARMOR_DURABILITY))) {
            return;
        }
        int armorDmg = Math.max(1, (int)(damage / 4.0));
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot equipmentSlot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i);
            ItemStack equipment = this.citizen.getInventoryCitizen().getArmorInSlot(equipmentSlot);
            equipment.m_41622_(armorDmg, (LivingEntity)this.citizen, s -> {
                s.m_21166_(equipmentSlot);
                this.citizen.onArmorRemove(equipment, equipmentSlot);
                this.citizen.getInventoryCitizen().markDirty();
            });
        }
    }

    @Override
    public double applyMending(double xp) {
        double localXp = xp;
        int toolSlot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.citizen.getInventoryCitizen(), stack -> stack.m_41793_() && EnchantmentHelper.m_44831_((ItemStack)stack).containsKey(Enchantments.f_44962_));
        if (toolSlot == -1) {
            return localXp;
        }
        ItemStack tool = this.citizen.getInventoryCitizen().getStackInSlot(toolSlot);
        if (!ItemStackUtils.isEmpty(tool) && tool.m_41768_()) {
            double dmgHealed = Math.min(localXp / 2.0, (double)tool.m_41773_());
            localXp -= dmgHealed * 2.0;
            tool.m_41721_(tool.m_41773_() - (int)Math.ceil(dmgHealed));
        }
        return localXp;
    }
}

