/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.Objects;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.damagesource.FallLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CitizenCombatTracker
extends CombatTracker {
    private static final Style INTENTIONAL_GAME_DESIGN_STYLE = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bugs.mojang.com/browse/MCPE-28723")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"MCPE-28723")));
    private final EntityCitizen citizen;

    public CitizenCombatTracker(EntityCitizen citizen) {
        super((LivingEntity)citizen);
        this.citizen = citizen;
    }

    @NotNull
    public Component m_19293_() {
        ItemStack itemStack;
        Component component;
        IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
        MutableComponent nameComponent = job != null ? Component.m_237110_((String)"block.blockhuttownhall.messageworkerdesc", (Object[])new Object[]{Component.m_237115_((String)job.getJobRegistryEntry().getTranslationKey()), this.citizen.getCitizenData().getName()}) : Component.m_237110_((String)"block.blockhuttownhall.messagecolonistdesc", (Object[])new Object[]{this.citizen.getCitizenData().getName()});
        if (this.f_19276_.isEmpty()) {
            return Component.m_237110_((String)"death.attack.generic", (Object[])new Object[]{nameComponent});
        }
        DamageSource lastSource = ((CombatEntry)this.f_19276_.get(this.f_19276_.size() - 1)).f_19250_();
        DeathMessageType messageType = lastSource.m_269415_().f_268472_();
        CombatEntry fallEntry = this.m_19298_();
        if (messageType == DeathMessageType.FALL_VARIANTS && fallEntry != null) {
            DamageSource fallSource = fallEntry.f_19250_();
            Entity lastEntity = lastSource.m_7639_();
            if (!fallSource.m_269533_(DamageTypeTags.f_268549_) && !fallSource.m_269533_(DamageTypeTags.f_268518_)) {
                Component lastMessage;
                Entity fallEntity = fallSource.m_7639_();
                Component fallMessage = fallEntity == null ? null : fallEntity.m_5446_();
                Component component2 = lastMessage = lastEntity == null ? null : lastEntity.m_5446_();
                if (fallMessage != null && !fallMessage.equals(lastMessage)) {
                    ItemStack itemStack2;
                    if (fallEntity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)fallEntity;
                        itemStack2 = living.m_21205_();
                    } else {
                        itemStack2 = ItemStack.f_41583_;
                    }
                    ItemStack stack = itemStack2;
                    return !stack.m_41619_() && stack.m_41788_() ? Component.m_237110_((String)"death.fell.assist.item", (Object[])new Object[]{nameComponent, fallMessage, stack.m_41611_()}) : Component.m_237110_((String)"death.fell.assist", (Object[])new Object[]{nameComponent, fallMessage});
                }
                if (lastMessage != null) {
                    ItemStack itemStack3;
                    if (lastEntity instanceof LivingEntity) {
                        LivingEntity livingentity = (LivingEntity)lastEntity;
                        itemStack3 = livingentity.m_21205_();
                    } else {
                        itemStack3 = ItemStack.f_41583_;
                    }
                    ItemStack stack = itemStack3;
                    return !stack.m_41619_() && stack.m_41788_() ? Component.m_237110_((String)"death.fell.finish.item", (Object[])new Object[]{nameComponent, lastMessage, stack.m_41611_()}) : Component.m_237110_((String)"death.fell.finish", (Object[])new Object[]{nameComponent, lastMessage});
                }
                return Component.m_237110_((String)"death.fell.killer", (Object[])new Object[]{nameComponent});
            }
            return Component.m_237110_((String)Objects.requireNonNullElse(fallEntry.f_289042_(), FallLocation.f_289040_).m_289192_(), (Object[])new Object[]{nameComponent});
        }
        if (messageType == DeathMessageType.INTENTIONAL_GAME_DESIGN) {
            String s = "death.attack." + lastSource.m_19385_();
            return Component.m_237110_((String)(s + ".message"), (Object[])new Object[]{nameComponent, ComponentUtils.m_130748_((Component)Component.m_237115_((String)(s + ".link"))).m_130948_(INTENTIONAL_GAME_DESIGN_STYLE)});
        }
        String s = "death.attack." + lastSource.m_269415_().f_268677_();
        Entity entity = lastSource.m_7639_();
        Entity directEntity = lastSource.m_7640_();
        if (directEntity == null && entity == null) {
            LivingEntity living = this.citizen.m_21232_();
            return living != null ? Component.m_237110_((String)(s + ".player"), (Object[])new Object[]{nameComponent, living.m_5446_()}) : Component.m_237110_((String)s, (Object[])new Object[]{nameComponent});
        }
        Component component3 = component = entity == null ? directEntity.m_5446_() : entity.m_5446_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            itemStack = living.m_21205_();
        } else {
            itemStack = ItemStack.f_41583_;
        }
        ItemStack stack = itemStack;
        return !stack.m_41619_() && stack.m_41788_() ? Component.m_237110_((String)(s + ".item"), (Object[])new Object[]{nameComponent, component, stack.m_41611_()}) : Component.m_237110_((String)s, (Object[])new Object[]{nameComponent, component});
    }
}

