/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingChickenHerder;
import com.minecolonies.coremod.colony.jobs.JobChickenHerder;
import com.minecolonies.coremod.entity.ai.citizen.herders.AbstractEntityAIHerder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkChickenHerder
extends AbstractEntityAIHerder<JobChickenHerder, BuildingChickenHerder> {
    private static final VisibleCitizenStatus FIND_CHICKEN = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/chickenherder.png"), "com.minecolonies.gui.visiblestatus.chickenherder");

    public EntityAIWorkChickenHerder(@NotNull JobChickenHerder job) {
        super(job);
    }

    @Override
    public Class<BuildingChickenHerder> getExpectedBuildingClass() {
        return BuildingChickenHerder.class;
    }

    @Override
    protected IAIState breedAnimals() {
        this.worker.getCitizenData().setVisibleStatus(FIND_CHICKEN);
        return super.breedAnimals();
    }

    @Override
    protected IAIState butcherAnimals() {
        this.worker.getCitizenData().setVisibleStatus(FIND_CHICKEN);
        return super.butcherAnimals();
    }

    @Override
    protected void butcherAnimal(@Nullable Animal animal) {
        if (animal != null && !this.walkingToAnimal(animal) && !ItemStackUtils.isEmpty(this.worker.m_21205_())) {
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            if (this.worker.m_217043_().m_188503_(1 + (100 - this.getSecondarySkillLevel()) / 5) <= 1) {
                animal.m_6469_(this.world.m_269111_().m_269298_(DamageSourceKeys.DEFAULT, (Entity)this.worker), (float)this.getButcheringAttackDamage());
                this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
            }
        }
    }
}

