/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.guardtype.registry.ModGuardTypes;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.PathingOptions;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobDruid;
import com.minecolonies.coremod.entity.DruidPotionEntity;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.combat.AttackMoveAI;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobCanSee;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobMoveAwayFromLocation;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;

public class DruidCombatAI
extends AttackMoveAI<EntityCitizen> {
    private static final ImmutableList<MobEffect> SUPPORT_EFFECTS = ImmutableList.of((Object)MobEffects.f_19600_, (Object)MobEffects.f_19618_, (Object)MobEffects.f_19601_, (Object)MobEffects.f_19606_);
    private static final ImmutableList<MobEffect> ADVERSE_EFFECTS = ImmutableList.of((Object)MobEffects.f_19597_, (Object)MobEffects.f_19613_);
    private static final double PER_POTION_XP = 0.05;
    private static final double COMBAT_SPEED = 1.0;
    public static final float POTION_VELOCITY = 0.5f;
    private static final int FLEE_CHANCE = 3;
    private final AbstractEntityAIGuard<JobDruid, AbstractBuildingGuards> parentAI;
    private final PathingOptions combatPathingOptions;
    private boolean instantEffect;

    public DruidCombatAI(EntityCitizen owner, ITickRateStateMachine stateMachine, AbstractEntityAIGuard parentAI) {
        super(owner, stateMachine);
        this.parentAI = parentAI;
        this.combatPathingOptions = new PathingOptions();
        this.combatPathingOptions.setEnterDoors(true);
        this.combatPathingOptions.setCanOpenDoors(true);
        this.combatPathingOptions.setCanSwim(true);
        this.combatPathingOptions.withOnPathCost(0.8);
        this.combatPathingOptions.withJumpCost(0.01);
        this.combatPathingOptions.withDropCost(1.5);
    }

    @Override
    protected void doAttack(LivingEntity target) {
        BiPredicate<LivingEntity, MobEffect> predicate;
        MobEffect effect;
        if (((EntityCitizen)this.user).m_20280_((Entity)target) < 7.0) {
            if (((EntityCitizen)this.user).m_217043_().m_188503_(3) == 0 && !((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
                ((EntityCitizen)this.user).getNavigation().moveAwayFromLivingEntity((Entity)target, this.getAttackDistance() / 2.0, this.getCombatMovementSpeed());
            }
        } else {
            ((EntityCitizen)this.user).getNavigation().m_26573_();
        }
        ((EntityCitizen)this.user).m_6674_(InteractionHand.MAIN_HAND);
        int level = ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(((GuardType)ModGuardTypes.druid.get()).getSecondarySkill());
        int time = ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(((GuardType)ModGuardTypes.druid.get()).getPrimarySkill()) * 20;
        float inaccuracy = 99.0f / (float)level;
        ItemStack stack = new ItemStack((ItemLike)Items.f_42736_);
        boolean gotMaterial = false;
        if (((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.DRUID_USE_POTIONS) > 0.0 && InventoryUtils.hasItemInItemHandler((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), item -> item.m_41720_() == ModItems.magicpotion)) {
            gotMaterial = true;
        }
        if (AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, target)) {
            effect = (MobEffect)ADVERSE_EFFECTS.get(((EntityCitizen)this.user).m_217043_().m_188503_(gotMaterial ? 2 : 1));
            predicate = (entity, eff) -> AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, entity);
        } else {
            effect = (MobEffect)SUPPORT_EFFECTS.get(((EntityCitizen)this.user).m_217043_().m_188503_(gotMaterial ? 4 : 1));
            predicate = (entity, eff) -> !AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, entity);
        }
        PotionUtils.m_43552_((ItemStack)stack, Collections.singleton(new MobEffectInstance(effect, time, gotMaterial ? 2 : 0)));
        DruidPotionEntity.throwPotionAt(stack, target, (AbstractEntityCitizen)this.user, ((EntityCitizen)this.user).m_20193_(), 0.5f, inaccuracy, predicate);
        if (gotMaterial) {
            InventoryUtils.removeStackFromItemHandler((IItemHandler)((EntityCitizen)this.user).getCitizenData().getInventory(), new ItemStack((ItemLike)ModItems.magicpotion, 1), 1);
        }
        this.instantEffect = effect.m_8093_();
        ((EntityCitizen)this.user).m_21008_(InteractionHand.MAIN_HAND, stack);
        ((EntityCitizen)this.user).getThreatTable().removeCurrentTarget();
        ((EntityCitizen)this.user).decreaseSaturationForContinuousAction();
        ((EntityCitizen)this.user).getCitizenExperienceHandler().addExperience(0.05);
    }

    @Override
    protected int getAttackDelay() {
        return this.instantEffect ? super.getAttackDelay() * 2 : super.getAttackDelay();
    }

    @Override
    protected double getAttackDistance() {
        int attackDist = 3;
        if (((EntityCitizen)this.user).getCitizenData().getWorkBuilding() != null) {
            attackDist += ((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevel();
        }
        if (this.target != null) {
            attackDist = (int)((double)attackDist + (((EntityCitizen)this.user).m_20186_() - this.target.m_20186_()));
        }
        return attackDist;
    }

    @Override
    protected PathResult moveInAttackPosition(LivingEntity target) {
        if ((double)BlockPosUtil.getDistanceSquared(target.m_20183_(), ((EntityCitizen)this.user).m_20183_()) <= 4.0) {
            PathJobMoveAwayFromLocation job = new PathJobMoveAwayFromLocation(((EntityCitizen)this.user).f_19853_, AbstractPathJob.prepareStart(target), target.m_20183_(), 12, (int)((EntityCitizen)this.user).m_21051_(Attributes.f_22277_).m_22135_(), (LivingEntity)this.user);
            PathResult<AbstractPathJob> pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed(), true);
            job.setPathingOptions(this.combatPathingOptions);
            return pathResult;
        }
        if (BlockPosUtil.getDistance2D(target.m_20183_(), ((EntityCitizen)this.user).m_20183_()) >= 20L) {
            PathJobMoveToLocation job = new PathJobMoveToLocation(((EntityCitizen)this.user).f_19853_, AbstractPathJob.prepareStart((LivingEntity)this.user), target.m_20183_(), 200, (LivingEntity)this.user);
            PathResult<AbstractPathJob> pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed(), true);
            job.setPathingOptions(this.combatPathingOptions);
            return pathResult;
        }
        PathJobCanSee job = new PathJobCanSee((LivingEntity)this.user, target, ((EntityCitizen)this.user).f_19853_, ((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getGuardPos(), 40);
        PathResult<AbstractPathJob> pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed(), true);
        job.setPathingOptions(this.combatPathingOptions);
        return pathResult;
    }

    protected double getCombatMovementSpeed() {
        double levelAdjustment = (double)((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Mana) * 0.01;
        levelAdjustment += (double)(((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevel() - 1) * 0.01;
        levelAdjustment = Math.min(levelAdjustment, 0.3);
        return 1.0 + levelAdjustment;
    }

    @Override
    protected boolean isAttackableTarget(LivingEntity entity) {
        return (AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, entity) || entity instanceof IThreatTableEntity && ((IThreatTableEntity)entity).getThreatTable().getTarget() != null || entity instanceof Player && entity.m_21213_() != 0 && entity.f_19797_ > entity.m_21213_() && entity.f_19797_ - entity.m_21213_() < 600) && !this.wasAffectedByDruid(entity);
    }

    @Override
    protected boolean searchNearbyTarget() {
        if (this.checkForTarget()) {
            return true;
        }
        List entities = ((EntityCitizen)this.user).f_19853_.m_45976_(LivingEntity.class, this.getSearchArea());
        if (entities.isEmpty()) {
            return false;
        }
        int targetsUnderEffect = 0;
        boolean foundTarget = false;
        for (LivingEntity entity : entities) {
            if (!entity.m_6084_()) continue;
            if (this.skipSearch(entity)) {
                return false;
            }
            if (this.isEntityValidTarget(entity)) {
                if (!((EntityCitizen)this.user).m_142582_((Entity)entity)) continue;
                ((EntityCitizen)this.user).getThreatTable().addThreat(entity, 0);
                foundTarget = true;
                continue;
            }
            if (!this.wasAffectedByDruid(entity)) continue;
            ++targetsUnderEffect;
        }
        return foundTarget && targetsUnderEffect <= ((AbstractBuildingGuards)this.parentAI.building).getBuildingLevel() * 2;
    }

    private boolean wasAffectedByDruid(LivingEntity entity) {
        return entity.m_21023_(MobEffects.f_19597_) || entity.m_21023_(MobEffects.f_19618_) || entity.m_21023_(MobEffects.f_19600_) || entity.m_21023_(MobEffects.f_19613_) || entity.m_21023_(MobEffects.f_19606_) || entity.m_21023_(MobEffects.f_19601_);
    }

    @Override
    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return this.parentAI.isWithinPersecutionDistance(target.m_20183_(), this.getAttackDistance());
    }

    @Override
    protected boolean skipSearch(LivingEntity entity) {
        EntityCitizen citizen;
        if (entity instanceof EntityCitizen && ((EntityCitizen)this.user).m_217043_().m_188503_(10) < 1 && (citizen = (EntityCitizen)entity).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && ((AbstractJobGuard)citizen.getCitizenJobHandler().getColonyJob()).isAsleep() && ((EntityCitizen)this.user).m_21574_().m_148306_((Entity)citizen)) {
            this.parentAI.setWakeCitizen(citizen);
            return true;
        }
        return false;
    }

    @Override
    protected int getYSearchRange() {
        if (((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
            return 28;
        }
        return 3;
    }

    @Override
    protected void onTargetDied(LivingEntity entity) {
        this.parentAI.incrementActionsDoneAndDecSaturation();
        ((EntityCitizen)this.user).getCitizenExperienceHandler().addExperience(15.0);
    }
}

