/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAISkill;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIInteract<J extends AbstractJob<?, J>, B extends AbstractBuilding>
extends AbstractEntityAISkill<J, B> {
    public static final String RENDER_META_WORKING = "working";
    public static final double XP_PER_BLOCK = 0.05;
    private static final double LEVEL_MODIFIER = 0.85;
    private static final int MIN_WORKING_RANGE = 12;
    private static final int ITEM_PICKUP_RANGE = 3;
    private static final int STUCK_WAIT_TICKS = 20;
    public static final float RANGE_HORIZONTAL_PICKUP = 45.0f;
    public static final float RANGE_VERTICAL_PICKUP = 3.0f;
    private int stillTicks = 0;
    private int previousIndex = 0;
    @Nullable
    private List<BlockPos> items;
    private PathResult pathResult;
    protected int pathBackupFactor = 1;

    public AbstractEntityAIInteract(@NotNull J job) {
        super(job);
        super.registerTargets(new TickingTransition[0]);
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine) {
        return this.mineBlock(blockToMine, this.worker.m_20183_());
    }

    protected boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        return this.mineBlock(blockToMine, safeStand, true, true, null);
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand, boolean damageTool, boolean getDrops, Runnable blockBreakAction) {
        BlockState curBlockState = this.world.m_8055_(blockToMine);
        @Nullable Block curBlock = curBlockState.m_60734_();
        if (curBlock instanceof AirBlock || curBlock instanceof IBuilderUndestroyable || curBlock == Blocks.f_50752_) {
            if (curBlockState.m_278721_()) {
                this.world.m_7471_(blockToMine, false);
            }
            return true;
        }
        if (this.checkMiningLocation(blockToMine, safeStand)) {
            return false;
        }
        ItemStack tool = this.worker.m_21205_();
        if (getDrops) {
            int fortune = ItemStackUtils.getFortuneOf(tool);
            List<ItemStack> localItems = new ArrayList<ItemStack>();
            if (!tool.m_41619_() && this.shouldSilkTouchBlock(curBlockState)) {
                ItemStack fakeTool = tool.m_41777_();
                fakeTool.m_41663_(Enchantments.f_44985_, 1);
                localItems.addAll(BlockPosUtil.getBlockDrops(this.world, blockToMine, fortune, fakeTool, (LivingEntity)this.worker));
            } else {
                localItems.addAll(BlockPosUtil.getBlockDrops(this.world, blockToMine, fortune, tool, (LivingEntity)this.worker));
            }
            localItems = this.increaseBlockDrops(localItems);
            for (ItemStack item : localItems) {
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(item, (IItemHandler)this.worker.getInventoryCitizen());
            }
            this.onBlockDropReception(localItems);
        }
        this.triggerMinedBlock(curBlockState);
        if (blockBreakAction == null) {
            this.worker.getCitizenItemHandler().breakBlockWithToolInHand(blockToMine);
        } else {
            blockBreakAction.run();
        }
        if (tool != ItemStack.f_41583_ && damageTool) {
            tool.m_41720_().m_6883_(tool, this.world, (Entity)this.worker, this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(tool.m_41720_()), true);
        }
        this.worker.getCitizenExperienceHandler().addExperience(0.05);
        this.incrementActionsDone();
        return true;
    }

    public void onBlockDropReception(List<ItemStack> blockDrops) {
    }

    public boolean shouldSilkTouchBlock(BlockState curBlockState) {
        return false;
    }

    protected List<ItemStack> increaseBlockDrops(List<ItemStack> drops) {
        return drops;
    }

    protected void triggerMinedBlock(@NotNull BlockState blockToMine) {
    }

    private boolean checkMiningLocation(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        BlockState curBlock = this.world.m_8055_(blockToMine);
        if (!this.holdEfficientTool(curBlock, blockToMine)) {
            return true;
        }
        if (this.walkToBlock(safeStand) && MathUtils.twoDimDistance(this.worker.m_20183_(), safeStand) > 12.0) {
            return true;
        }
        this.currentWorkingLocation = blockToMine;
        return this.hasNotDelayed(this.getBlockMiningDelay(curBlock, blockToMine));
    }

    public int getBlockMiningDelay(@NotNull BlockState state, @NotNull BlockPos pos) {
        if (this.worker.m_21205_() == null) {
            return (int)state.m_60800_((BlockGetter)this.world, pos);
        }
        return (Boolean)MineColonies.getConfig().getServer().pvp_mode.get() != false ? (Integer)MineColonies.getConfig().getServer().blockMiningDelayModifier.get() / 2 : this.calculateWorkerMiningDelay(state, pos);
    }

    private int calculateWorkerMiningDelay(@NotNull BlockState state, @NotNull BlockPos pos) {
        double reduction = 1.0 - this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_BREAK_SPEED);
        return (int)((double)((Integer)MineColonies.getConfig().getServer().blockMiningDelayModifier.get()).intValue() * Math.pow(0.85, (double)this.getBreakSpeedLevel() / 2.0) * (double)this.world.m_8055_(pos).m_60800_((BlockGetter)this.world, pos) / (double)this.worker.m_21205_().m_41720_().m_8102_(this.worker.m_21205_(), state) * reduction);
    }

    public int getBreakSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    public void fillItemsList() {
        this.searchForItems(this.worker.m_20191_().m_82363_(45.0, 3.0, 45.0).m_82363_(-45.0, -3.0, -45.0));
    }

    public void searchForItems(AABB boundingBox) {
        this.items = this.world.m_45976_(ItemEntity.class, boundingBox).stream().filter(item -> item != null && item.m_6084_() && (!item.getPersistentData().m_128441_("PreventRemoteMovement") || !item.getPersistentData().m_128471_("PreventRemoteMovement")) && this.isItemWorthPickingUp(item.m_32055_())).map(BlockPosUtil::fromEntity).collect(Collectors.toList());
    }

    protected boolean isItemWorthPickingUp(ItemStack stack) {
        return true;
    }

    public void gatherItems() {
        this.worker.m_21553_(true);
        if (this.worker.getNavigation().m_26571_() || this.worker.getNavigation().m_26570_() == null) {
            BlockPos pos = this.getAndRemoveClosestItemPosition();
            this.worker.isWorkerAtSiteWithMove(pos, 3);
            return;
        }
        int currentIndex = this.worker.getNavigation().m_26570_().m_77399_();
        if (currentIndex != this.previousIndex) {
            this.stillTicks = 0;
            this.previousIndex = currentIndex;
            return;
        }
        ++this.stillTicks;
        if (this.stillTicks > 20) {
            this.worker.getNavigation().m_26573_();
            if (this.items != null && !this.items.isEmpty()) {
                this.items.remove(0);
            }
        }
    }

    private BlockPos getAndRemoveClosestItemPosition() {
        int index = 0;
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < this.items.size(); ++i) {
            double tempDistance = this.items.get(i).m_123331_((Vec3i)this.worker.m_20183_());
            if (!(tempDistance < distance)) continue;
            index = i;
            distance = tempDistance;
        }
        return this.items.remove(index);
    }

    protected BlockPos findRandomPositionToWalkTo(int range) {
        return this.findRandomPositionToWalkTo(range, this.worker.m_20183_());
    }

    protected BlockPos findRandomPositionToWalkTo(int range, BlockPos pos) {
        if (this.pathResult == null) {
            this.pathBackupFactor = 1;
            this.pathResult = this.getRandomNavigationPath(range, pos);
        } else if (this.pathResult.failedToReachDestination()) {
            ++this.pathBackupFactor;
            this.pathResult = this.getRandomNavigationPath(range * this.pathBackupFactor, pos);
        }
        if (this.pathResult.isPathReachingDestination()) {
            BlockPos resultPos = this.pathResult.getPath().m_77395_().m_77288_();
            this.pathResult = null;
            return resultPos;
        }
        if (this.pathResult.isCancelled()) {
            this.pathResult = null;
            return null;
        }
        if (this.pathBackupFactor > 10) {
            this.pathResult = null;
            return null;
        }
        return null;
    }

    protected PathResult getRandomNavigationPath(int range, BlockPos pos) {
        if (pos == null || pos == this.worker.m_20183_()) {
            return this.worker.getNavigation().moveToRandomPos(range, 1.0);
        }
        return this.worker.getNavigation().moveToRandomPosAroundX(range, 1.0, pos);
    }

    public void resetGatheringItems() {
        this.items = null;
    }

    @Nullable
    public List<BlockPos> getItemsForPickUp() {
        return this.items == null ? null : new ArrayList<BlockPos>(this.items);
    }
}

