/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.api.quests.IQuestRewardTemplate;
import com.minecolonies.api.quests.IQuestTemplate;
import com.minecolonies.api.quests.IQuestTriggerTemplate;
import com.minecolonies.api.quests.ITriggerReturnData;
import com.minecolonies.api.quests.registries.QuestRegistries;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.client.GlobalQuestSyncMessage;
import com.minecolonies.coremod.quests.QuestTemplate;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class QuestJsonListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Map<ResourceLocation, JsonElement> globalJsonElementMap = new HashMap<ResourceLocation, JsonElement>();

    public QuestJsonListener() {
        super(GSON, "quests");
    }

    public static void sendGlobalQuestPackets(ServerPlayer player) {
        FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
        byteBuf.writeInt(globalJsonElementMap.size());
        for (Map.Entry<ResourceLocation, JsonElement> entry : globalJsonElementMap.entrySet()) {
            byteBuf.m_130085_(entry.getKey());
            byteBuf.m_130087_(entry.getValue().toString().getBytes());
        }
        Network.getNetwork().sendToPlayer(new GlobalQuestSyncMessage(byteBuf), player);
    }

    public static void readGlobalQuestPackets(FriendlyByteBuf byteBuf) {
        globalJsonElementMap.clear();
        int size = byteBuf.readInt();
        for (int i = 0; i < size; ++i) {
            globalJsonElementMap.put(byteBuf.m_130281_(), (JsonElement)GSON.fromJson(new String(byteBuf.m_130052_()), JsonObject.class));
        }
        QuestJsonListener.apply(globalJsonElementMap);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        globalJsonElementMap.clear();
        globalJsonElementMap.putAll(jsonElementMap);
        QuestJsonListener.apply(jsonElementMap);
    }

    private static void apply(Map<ResourceLocation, JsonElement> jsonElementMap) {
        Log.getLogger().info("Loading quests from data");
        IQuestManager.GLOBAL_SERVER_QUESTS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            ResourceLocation fileResLoc = entry.getKey();
            JsonObject questDataJson = entry.getValue().getAsJsonObject();
            try {
                IQuestTemplate data = QuestJsonListener.loadDataFromJson(fileResLoc, questDataJson);
                IQuestManager.GLOBAL_SERVER_QUESTS.put(fileResLoc, data);
            }
            catch (Exception e) {
                Log.getLogger().error("Skipping quest: " + fileResLoc + " due to parsing error:", (Throwable)e);
            }
        }
        Log.getLogger().info("Finished loading quests from data");
    }

    public static IQuestTemplate loadDataFromJson(ResourceLocation questId, JsonObject jsonObject) throws Exception {
        ArrayList<IQuestTriggerTemplate> questTriggers = new ArrayList<IQuestTriggerTemplate>();
        for (Object triggerJson : jsonObject.get("triggers").getAsJsonArray()) {
            JsonObject triggerObj = triggerJson.getAsJsonObject();
            String type = triggerObj.get("type").getAsString();
            try {
                questTriggers.add(((QuestRegistries.TriggerEntry)IMinecoloniesAPI.getInstance().getQuestTriggerRegistry().getValue(new ResourceLocation(type))).produce(triggerObj));
            }
            catch (Exception ex) {
                throw new Exception("Failed loading triggers for type: " + type, ex);
            }
        }
        ArrayList<IQuestObjectiveTemplate> questObjectives = new ArrayList<IQuestObjectiveTemplate>();
        for (JsonElement objectivesJson : jsonObject.get("objectives").getAsJsonArray()) {
            JsonObject objectiveObj = objectivesJson.getAsJsonObject();
            String type = objectiveObj.get("type").getAsString();
            try {
                questObjectives.add(((QuestRegistries.ObjectiveEntry)IMinecoloniesAPI.getInstance().getQuestObjectiveRegistry().getValue(new ResourceLocation(type))).produce(objectiveObj));
            }
            catch (Exception ex) {
                throw new Exception("Failed loading objectives for type: " + type, ex);
            }
        }
        String order = "";
        if (jsonObject.has("triggerOrder")) {
            order = jsonObject.get("triggerOrder").getAsString();
        }
        int maxOccurrences = jsonObject.has("max-occurrences") ? jsonObject.get("max-occurrences").getAsInt() : 1;
        int questTimeout = jsonObject.has("timeout") ? jsonObject.get("timeout").getAsInt() : 10;
        MutableComponent questName = Component.m_237115_((String)jsonObject.get("name").getAsString());
        ArrayList<IQuestRewardTemplate> questRewards = new ArrayList<IQuestRewardTemplate>();
        for (JsonElement objectivesJson : jsonObject.get("rewards").getAsJsonArray()) {
            JsonObject objectiveObj = objectivesJson.getAsJsonObject();
            String type = objectiveObj.get("type").getAsString();
            try {
                questRewards.add(((QuestRegistries.RewardEntry)IMinecoloniesAPI.getInstance().getQuestRewardRegistry().getValue(new ResourceLocation(type))).produce(objectiveObj));
            }
            catch (Exception ex) {
                throw new Exception("Failed loading rewards for type: " + type, ex);
            }
        }
        ArrayList<ResourceLocation> parents = new ArrayList<ResourceLocation>();
        for (JsonElement objectivesJson : jsonObject.get("parents").getAsJsonArray()) {
            try {
                parents.add(new ResourceLocation(objectivesJson.getAsString()));
            }
            catch (Exception ex) {
                throw new Exception("Failed loading parents: ", ex);
            }
        }
        return new QuestTemplate(questId, (Component)questName, parents, maxOccurrences, QuestJsonListener.parseTriggerOrder(questId, order, questTriggers), questObjectives, questTimeout, questRewards);
    }

    private static Function<IColony, List<ITriggerReturnData<?>>> parseTriggerOrder(ResourceLocation questId, String order, List<IQuestTriggerTemplate> triggers) {
        if (order.isEmpty()) {
            return colony -> {
                ArrayList<ITriggerReturnData> returnList = new ArrayList<ITriggerReturnData>();
                for (IQuestTriggerTemplate trigger : triggers) {
                    ITriggerReturnData returnData = trigger.canTriggerQuest(questId, (IColony)colony);
                    if (returnData.isPositive()) {
                        returnList.add(returnData);
                        continue;
                    }
                    return null;
                }
                return returnList;
            };
        }
        List<String> values = Arrays.asList(order.replaceAll("\\s+", "").split("((?<=\\w)|(?=\\w)|(?<=[)(])|(?=[)(]))"));
        ArrayList<String> types = new ArrayList<String>();
        for (String value : values) {
            try {
                Integer.parseInt(value);
                if (types.contains(value)) continue;
                types.add(value);
            }
            catch (Exception exception) {}
        }
        if (types.size() != triggers.size()) {
            Log.getLogger().error("Failed to Parse Quest Triggers. Mismatch number of triggers in order for quest: " + questId.toString());
            return null;
        }
        HashMap<String, IQuestTriggerTemplate> triggerMap = new HashMap<String, IQuestTriggerTemplate>();
        for (int i = 0; i < triggers.size(); ++i) {
            triggerMap.put(String.valueOf(i + 1), triggers.get(i));
        }
        if (values.isEmpty()) {
            return colony -> new ArrayList();
        }
        ExpressionNode expressionTree = null;
        int[] depth = new int[100];
        int current = 0;
        block16: for (int i = values.size() - 1; i >= 0; --i) {
            String arg;
            switch (arg = values.get(i)) {
                case "(": {
                    for (int d = 0; d < depth[current]; ++d) {
                        expressionTree = expressionTree.parent;
                    }
                    depth[current] = 0;
                    --current;
                    continue block16;
                }
                case ")": {
                    ++current;
                    continue block16;
                }
                case "||": 
                case "&&": 
                case "!": {
                    ExpressionNode node = new ExpressionNode(arg);
                    if (expressionTree.parent != null) {
                        ExpressionNode previous = expressionTree.parent;
                        while (true) {
                            if (previous.childB == expressionTree) {
                                previous.childB = node;
                                break;
                            }
                            if (previous.childA == expressionTree) {
                                previous.childA = node;
                                break;
                            }
                            previous = previous.parent;
                        }
                        node.parent = previous;
                    }
                    int n = current;
                    depth[n] = depth[n] + 1;
                    node.childA = expressionTree;
                    node.childA.parent = node;
                    expressionTree = node;
                    continue block16;
                }
                default: {
                    expressionTree = expressionTree == null ? new ExpressionNode(arg) : expressionTree.append(arg);
                }
            }
        }
        ExpressionNode root = expressionTree;
        while (root.parent != null) {
            root = root.parent;
        }
        ExpressionNode finalExpressionTree = root;
        return colony -> QuestJsonListener.evaluate(colony, triggerMap, finalExpressionTree);
    }

    private static List<ITriggerReturnData<?>> evaluate(IColony colony, Map<String, IQuestTriggerTemplate> triggerMap, ExpressionNode expressionTree) {
        switch (expressionTree.expression) {
            case "||": {
                List<ITriggerReturnData<?>> immReturn;
                if (expressionTree.childA != null && (immReturn = QuestJsonListener.evaluate(colony, triggerMap, expressionTree.childA)) != null) {
                    return immReturn;
                }
                if (expressionTree.childB != null) {
                    return QuestJsonListener.evaluate(colony, triggerMap, expressionTree.childB);
                }
                return null;
            }
            case "&&": {
                List<ITriggerReturnData<?>> immReturn;
                ArrayList returnDataList = new ArrayList();
                if (expressionTree.childA != null) {
                    immReturn = QuestJsonListener.evaluate(colony, triggerMap, expressionTree.childA);
                    if (immReturn == null) {
                        return null;
                    }
                    returnDataList.addAll(immReturn);
                }
                if (expressionTree.childB != null) {
                    immReturn = QuestJsonListener.evaluate(colony, triggerMap, expressionTree.childB);
                    if (immReturn == null) {
                        return null;
                    }
                    returnDataList.addAll(immReturn);
                }
                return returnDataList;
            }
        }
        IQuestTriggerTemplate trigger = triggerMap.get(expressionTree.expression);
        ITriggerReturnData returnData = trigger.canTriggerQuest(colony);
        if (returnData.isPositive()) {
            return List.of(returnData);
        }
        return null;
    }

    public static class ExpressionNode {
        public String expression;
        public ExpressionNode childA;
        public ExpressionNode childB;
        public ExpressionNode parent;

        public ExpressionNode(String expression) {
            this.expression = expression;
        }

        public ExpressionNode append(String expression) {
            if (this.childA == null) {
                this.childA = new ExpressionNode(expression);
                this.childA.parent = this;
                return this.childA;
            }
            if (this.childB == null) {
                this.childB = new ExpressionNode(expression);
                this.childB.parent = this;
                return this.childB;
            }
            return null;
        }
    }
}

