/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.managers.RaidManager;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CommandColonyRaidsInfo
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        if (!((CommandSourceStack)context.getSource()).m_6761_(4) && !((Boolean)MineColonies.getConfig().getServer().canPlayerUseShowColonyInfoCommand.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.notenabledinconfig"), true);
            return 0;
        }
        List<RaidManager.RaidHistory> allRaids = ((RaidManager)colony.getRaiderManager()).getAllRaids();
        for (int i = 0; i < allRaids.size(); ++i) {
            RaidManager.RaidHistory history = allRaids.get(i);
            double hoursSince = (double)Math.round((double)(100L * (colony.getWorld().m_46467_() - history.raidTime)) / 72000.0) / 100.0;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)(hoursSince + " hours ago:" + history)), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "raidhistory";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute));
    }
}

