/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.managers.RaidManager;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.minecolonies.coremod.research.LocalResearchTree;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class CommandColonyPrintStats
implements IMCOPCommand {
    public static final String ID_TEXT = "ID: ";
    public static final String NAME_TEXT = "Name: ";
    private static final String MAYOR_TEXT = "Mayor: ";
    private static final String COORDINATES_TEXT = "Coordinates: ";
    private static final String COORDINATES_XYZ = "x=%s y=%s z=%s";
    private static final String CITIZENS = "Citizens: ";
    private static final String LAST_CONTACT_TEXT = "Last contact with Owner or Officer: %d hours ago!";
    private static final String IS_DELETABLE = "If true this colony cannot be deleted: ";
    private static final String CANNOT_BE_RAIDED = "This colony is unable to be raided";
    private String fullLog = "";

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        RaidManager.RaidHistory last;
        this.fullLog = "\n";
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), false);
            return 0;
        }
        BlockPos position = colony.getCenter();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> this.literalAndRemember(ID_TEXT + colony.getID() + NAME_TEXT + colony.getName()), false);
        String mayor = colony.getPermissions().getOwnerName();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> this.literalAndRemember(MAYOR_TEXT + mayor), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> this.literalAndRemember(CITIZENS + colony.getCitizenManager().getCurrentCitizenCount() + "/" + colony.getCitizenManager().getMaxCitizens()), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> this.literalAndRemember(COORDINATES_TEXT + String.format(COORDINATES_XYZ, position.m_123341_(), position.m_123342_(), position.m_123343_())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> this.literalAndRemember(String.format(LAST_CONTACT_TEXT, colony.getLastContactInHours())), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> this.literalAndRemember(IS_DELETABLE + !colony.canBeAutoDeleted()), false);
        if (!colony.getRaiderManager().canHaveRaiderEvents()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> this.literalAndRemember(CANNOT_BE_RAIDED), false);
        }
        if ((last = ((RaidManager)colony.getRaiderManager()).getLastRaid()) != null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> this.literalAndRemember(last.toString()), false);
        }
        if (colony.getBuildingManager().getBuildings().size() > 0) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> this.literalAndRemember("Buildings:" + colony.getBuildingManager().getBuildings().size() + " average level:" + colony.getBuildingManager().getBuildings().values().stream().filter(iBuilding -> iBuilding.getBuildingLevel() != 0).collect(Collectors.summingInt(ibuilding -> ibuilding.getBuildingLevel())) / colony.getBuildingManager().getBuildings().size()), false);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> this.literalAndRemember(colony.getBuildingManager().getBuildings().values().stream().filter(iBuilding -> iBuilding.getBuildingLevel() != 0).map(building -> building.getSchematicName() + building.getBuildingLevel() + " pos:" + building.getPosition().m_123344_()).collect(Collectors.joining("\n"))), false);
        }
        List<ResourceLocation> completed = ((LocalResearchTree)colony.getResearchManager().getResearchTree()).getCompletedList();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> this.literalAndRemember("Reasearches completed count:" + completed.size()), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> this.literalAndRemember(completed.stream().map(r -> r.toString()).collect(Collectors.joining("\n"))), false);
        Log.getLogger().info(this.fullLog);
        return 1;
    }

    MutableComponent literalAndRemember(String message) {
        this.fullLog = this.fullLog + message + "\n";
        return MutableComponent.m_237204_((ComponentContents)new LiteralContents(message));
    }

    @Override
    public String getName() {
        return "printStats";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute));
    }
}

