/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.manager;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IDataStore;
import com.minecolonies.api.colony.requestsystem.data.IDataStoreManager;
import com.minecolonies.api.colony.requestsystem.data.IProviderResolverAssignmentDataStore;
import com.minecolonies.api.colony.requestsystem.data.IRequestIdentitiesDataStore;
import com.minecolonies.api.colony.requestsystem.data.IRequestResolverIdentitiesDataStore;
import com.minecolonies.api.colony.requestsystem.data.IRequestResolverRequestAssignmentDataStore;
import com.minecolonies.api.colony.requestsystem.data.IRequestableTypeRequestResolverAssignmentDataStore;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.management.IProviderHandler;
import com.minecolonies.api.colony.requestsystem.management.IRequestHandler;
import com.minecolonies.api.colony.requestsystem.management.IResolverHandler;
import com.minecolonies.api.colony.requestsystem.management.ITokenHandler;
import com.minecolonies.api.colony.requestsystem.management.IUpdateHandler;
import com.minecolonies.api.colony.requestsystem.management.update.UpdateType;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverProvider;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.ProviderHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.RequestHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.ResolverHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.TokenHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.UpdateHandler;
import com.minecolonies.coremod.colony.requestsystem.management.manager.wrapped.WrappedStaticStateRequestManager;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardRequestManager
implements IStandardRequestManager {
    private static final String NBT_DATASTORE = "DataStores";
    private static final String NBT_ID_REQUEST_IDENTITIES = "RequestIdentitiesStoreId";
    private static final String NBT_ID_REQUEST_RESOLVER_IDENTITIES = "RequestResolverIdentitiesStoreId";
    private static final String NBT_ID_PROVIDER_ASSIGNMENTS = "ProviderAssignmentsStoreId";
    private static final String NBT_ID_REQUEST_RESOLVER_ASSIGNMENTS = "RequestResolverAssignmentsStoreId";
    private static final String NBT_ID_REQUESTABLE_TYPE_ASSIGNMENTS = "RequestableTypeAssignmentsStoreId";
    private static final String NBT_ID_PLAYER = "PlayerRequestResolverId";
    private static final String NBT_ID_RETRYING = "RetryingRequestResolverId";
    private static final String NBT_VERSION = "Version";
    private IToken<?> requestIdentitiesDataStoreId;
    private IToken<?> requestResolverIdentitiesDataStoreId;
    private IToken<?> providerRequestResolverAssignmentDataStoreId;
    private IToken<?> requestResolverRequestAssignmentDataStoreId;
    private IToken<?> requestableTypeRequestResolverAssignmentDataStoreId;
    private IToken<?> playerRequestResolverId;
    private IToken<?> retryingRequestResolverId;
    private IDataStoreManager dataStoreManager;
    private boolean dirty = true;
    @NotNull
    private final IColony colony;
    @NotNull
    private final Logger logger;
    @NotNull
    private final IUpdateHandler updateHandler = new UpdateHandler(this);
    @NotNull
    private final ITokenHandler tokenHandler = new TokenHandler(this);
    @NotNull
    private final IResolverHandler resolverHandler = new ResolverHandler(this);
    @NotNull
    private final IRequestHandler requestHandler = new RequestHandler(this);
    @NotNull
    private final IProviderHandler providerHandler = new ProviderHandler(this);
    private int version = -1;
    private boolean enableLogging;

    public StandardRequestManager(@NotNull IColony colony) {
        this.colony = colony;
        this.logger = LogManager.getLogger((String)String.format("%s.requestsystem.%s", "minecolonies", colony.getID()));
        this.reset();
    }

    private void setup() {
        this.dataStoreManager = StandardFactoryController.getInstance().getNewInstance(TypeConstants.DATA_STORE_MANAGER);
        this.enableLogging = (Boolean)IMinecoloniesAPI.getInstance().getConfig().getCommon().rsEnableDebugLogging.get();
        this.requestIdentitiesDataStoreId = this.registerDataStore(TypeConstants.REQUEST_IDENTITIES_DATA_STORE);
        this.requestResolverIdentitiesDataStoreId = this.registerDataStore(TypeConstants.REQUEST_RESOLVER_IDENTITIES_DATA_STORE);
        this.providerRequestResolverAssignmentDataStoreId = this.registerDataStore(TypeConstants.PROVIDER_REQUEST_RESOLVER_ASSIGNMENT_DATA_STORE);
        this.requestResolverRequestAssignmentDataStoreId = this.registerDataStore(TypeConstants.REQUEST_RESOLVER_REQUEST_ASSIGNMENT_DATA_STORE);
        this.requestableTypeRequestResolverAssignmentDataStoreId = this.registerDataStore(TypeConstants.REQUESTABLE_TYPE_REQUEST_RESOLVER_ASSIGNMENT_DATA_STORE);
        IRequestResolver playerRequestResolver = StandardFactoryController.getInstance().getNewInstance(TypeConstants.PLAYER_REQUEST_RESOLVER, this, new Object[0]);
        IRequestResolver retryingRequestResolver = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RETRYING_REQUEST_RESOLVER, this, new Object[0]);
        this.getResolverHandler().registerResolver(playerRequestResolver);
        this.getResolverHandler().registerResolver(retryingRequestResolver);
        this.playerRequestResolverId = playerRequestResolver.getId();
        this.retryingRequestResolverId = retryingRequestResolver.getId();
    }

    private IToken<?> registerDataStore(TypeToken<? extends IDataStore> typeToken) {
        return this.dataStoreManager.get(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), typeToken).getId();
    }

    @Override
    @NotNull
    public IColony getColony() {
        return this.colony;
    }

    @Override
    @NotNull
    public IFactoryController getFactoryController() {
        return StandardFactoryController.getInstance();
    }

    @Override
    @NotNull
    public <T extends IRequestable> IToken<?> createRequest(@NotNull IRequester requester, @NotNull T object) {
        IRequest<T> request = this.getRequestHandler().createRequest(requester, object);
        this.markDirty();
        return request.getId();
    }

    @Override
    public void markDirty() {
        this.setDirty(true);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.dirty = isDirty;
        if (this.isDirty()) {
            this.colony.markDirty();
        }
    }

    @Override
    public void assignRequest(@NotNull IToken<?> token) {
        this.getRequestHandler().assignRequest(this.getRequestHandler().getRequest(token));
        this.markDirty();
    }

    @Override
    @NotNull
    public <T extends IRequestable> IToken<?> createAndAssignRequest(@NotNull IRequester requester, @NotNull T object) {
        IToken<?> token = this.createRequest(requester, object);
        this.assignRequest(token);
        return token;
    }

    @Override
    @Nullable
    public IToken<?> reassignRequest(@NotNull IToken<?> token, @NotNull Collection<IToken<?>> resolverTokenBlackList) {
        IRequest<?> request = this.getRequestHandler().getRequest(token);
        this.markDirty();
        return this.getRequestHandler().reassignRequest(request, resolverTokenBlackList);
    }

    @Override
    @Nullable
    public IRequest<?> getRequestForToken(@NotNull IToken<?> token) throws IllegalArgumentException {
        IRequest<?> internalRequest = this.getRequestHandler().getRequestOrNull(token);
        return internalRequest;
    }

    @Override
    @NotNull
    public IRequestResolver<?> getResolverForToken(@NotNull IToken<?> token) throws IllegalArgumentException {
        return this.getResolverHandler().getResolver(token);
    }

    @Override
    @Nullable
    public IRequestResolver<?> getResolverForRequest(@NotNull IToken<?> requestToken) throws IllegalArgumentException {
        IRequest<?> request = this.getRequestHandler().getRequest(requestToken);
        return this.getResolverForToken(this.getResolverHandler().getResolverForRequest(request).getId());
    }

    @Override
    public void updateRequestState(@NotNull IToken<?> token, @NotNull RequestState state) {
        IRequest<?> request = this.getRequestHandler().getRequest(token);
        this.log("Updating request state from:" + token + ". With original state: " + request.getState() + " to : " + state);
        request.setState(new WrappedStaticStateRequestManager(this), state);
        this.markDirty();
        switch (request.getState()) {
            case RESOLVED: {
                this.log("Request resolved: " + token + ". Determining followup requests...");
                this.getRequestHandler().onRequestResolved(token);
                return;
            }
            case COMPLETED: {
                this.log("Request completed: " + token + ". Notifying parent and requester...");
                this.getRequestHandler().onRequestCompleted(token);
                return;
            }
            case OVERRULED: {
                this.log("Request overruled: " + token + ". Notifying parent, children and requester...");
                this.getRequestHandler().onRequestOverruled(token);
                return;
            }
            case FAILED: {
                this.log("Request failed: " + token + ". Notifying parent, children and requester...");
                this.getRequestHandler().onRequestCancelled(token);
                return;
            }
            case CANCELLED: {
                this.log("Request cancelled: " + token + ". Notifying parent, children and requester...");
                this.getRequestHandler().onRequestCancelled(token);
                return;
            }
            case RECEIVED: {
                this.log("Request received: " + token + ". Removing from system...");
                this.getRequestHandler().cleanRequestData(token);
                return;
            }
        }
    }

    @Override
    public void onProviderAddedToColony(@NotNull IRequestResolverProvider provider) {
        this.getProviderHandler().registerProvider(provider);
    }

    @Override
    public void overruleRequest(@NotNull IToken<?> token, @Nullable ItemStack stack) {
        IRequest<?> request = this.getRequestHandler().getRequest(token);
        if (!ItemStackUtils.isEmpty(stack)) {
            request.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.of((Object)stack));
        }
        this.updateRequestState(token, RequestState.OVERRULED);
    }

    @Override
    public void onProviderRemovedFromColony(@NotNull IRequestResolverProvider provider) throws IllegalArgumentException {
        this.getProviderHandler().removeProvider(provider);
    }

    @Override
    public void onRequesterRemovedFromColony(@NotNull IRequester requester) throws IllegalArgumentException {
        this.getRequestHandler().removeRequester(requester);
    }

    @Override
    public void onColonyUpdate(@NotNull Predicate<IRequest<?>> shouldTriggerReassign) {
        this.getResolverHandler().onColonyUpdate(shouldTriggerReassign);
    }

    @Override
    @NotNull
    public IPlayerRequestResolver getPlayerResolver() {
        return (IPlayerRequestResolver)this.getResolverHandler().getResolver(this.playerRequestResolverId);
    }

    @Override
    @NotNull
    public IRetryingRequestResolver getRetryingRequestResolver() {
        return (IRetryingRequestResolver)this.getResolverHandler().getResolver(this.retryingRequestResolverId);
    }

    @Override
    @NotNull
    public IDataStoreManager getDataStoreManager() {
        return this.dataStoreManager;
    }

    @Override
    public void reset() {
        this.reset(UpdateType.RESET);
    }

    private void reset(UpdateType type) {
        this.setup();
        this.version = -1;
        this.getUpdateHandler().handleUpdate(UpdateType.RESET);
    }

    public CompoundTag serializeNBT() {
        CompoundTag systemCompound = new CompoundTag();
        systemCompound.m_128405_(NBT_VERSION, this.version);
        systemCompound.m_128365_(NBT_DATASTORE, (Tag)this.getFactoryController().serialize(this.dataStoreManager));
        systemCompound.m_128365_(NBT_ID_REQUEST_IDENTITIES, (Tag)this.getFactoryController().serialize(this.requestIdentitiesDataStoreId));
        systemCompound.m_128365_(NBT_ID_REQUEST_RESOLVER_IDENTITIES, (Tag)this.getFactoryController().serialize(this.requestResolverIdentitiesDataStoreId));
        systemCompound.m_128365_(NBT_ID_PROVIDER_ASSIGNMENTS, (Tag)this.getFactoryController().serialize(this.providerRequestResolverAssignmentDataStoreId));
        systemCompound.m_128365_(NBT_ID_REQUEST_RESOLVER_ASSIGNMENTS, (Tag)this.getFactoryController().serialize(this.requestResolverRequestAssignmentDataStoreId));
        systemCompound.m_128365_(NBT_ID_REQUESTABLE_TYPE_ASSIGNMENTS, (Tag)this.getFactoryController().serialize(this.requestableTypeRequestResolverAssignmentDataStoreId));
        systemCompound.m_128365_(NBT_ID_PLAYER, (Tag)this.getFactoryController().serialize(this.playerRequestResolverId));
        systemCompound.m_128365_(NBT_ID_RETRYING, (Tag)this.getFactoryController().serialize(this.retryingRequestResolverId));
        return systemCompound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.executeDeserializationStepOrMarkForUpdate(nbt, NBT_VERSION, CompoundTag::m_128451_, v -> {
            this.version = v;
        });
        this.executeDeserializationStepOrMarkForUpdate(nbt, NBT_DATASTORE, CompoundTag::m_128469_, c -> {
            this.dataStoreManager = (IDataStoreManager)this.getFactoryController().deserialize((CompoundTag)c);
        });
        this.executeDeserializationStepOrMarkForUpdate(nbt, NBT_ID_REQUEST_IDENTITIES, CompoundTag::m_128469_, c -> {
            this.requestIdentitiesDataStoreId = (IToken)this.getFactoryController().deserialize((CompoundTag)c);
        });
        this.executeDeserializationStepOrMarkForUpdate(nbt, NBT_ID_REQUEST_RESOLVER_IDENTITIES, CompoundTag::m_128469_, c -> {
            this.requestResolverIdentitiesDataStoreId = (IToken)this.getFactoryController().deserialize((CompoundTag)c);
        });
        this.executeDeserializationStepOrMarkForUpdate(nbt, NBT_ID_PROVIDER_ASSIGNMENTS, CompoundTag::m_128469_, c -> {
            this.providerRequestResolverAssignmentDataStoreId = (IToken)this.getFactoryController().deserialize((CompoundTag)c);
        });
        this.executeDeserializationStepOrMarkForUpdate(nbt, NBT_ID_REQUEST_RESOLVER_ASSIGNMENTS, CompoundTag::m_128469_, c -> {
            this.requestResolverRequestAssignmentDataStoreId = (IToken)this.getFactoryController().deserialize((CompoundTag)c);
        });
        this.executeDeserializationStepOrMarkForUpdate(nbt, NBT_ID_REQUESTABLE_TYPE_ASSIGNMENTS, CompoundTag::m_128469_, c -> {
            this.requestableTypeRequestResolverAssignmentDataStoreId = (IToken)this.getFactoryController().deserialize((CompoundTag)c);
        });
        this.executeDeserializationStepOrMarkForUpdate(nbt, NBT_ID_PLAYER, CompoundTag::m_128469_, c -> {
            this.playerRequestResolverId = (IToken)this.getFactoryController().deserialize((CompoundTag)c);
        });
        this.executeDeserializationStepOrMarkForUpdate(nbt, NBT_ID_RETRYING, CompoundTag::m_128469_, c -> {
            this.retryingRequestResolverId = (IToken)this.getFactoryController().deserialize((CompoundTag)c);
        });
        if (this.dataStoreManager == null) {
            this.reset();
        }
        this.updateIfRequired();
    }

    @Override
    public void serialize(IFactoryController controller, FriendlyByteBuf buffer) {
        buffer.writeInt(this.version);
        controller.serialize(buffer, this.dataStoreManager);
        controller.serialize(buffer, this.requestIdentitiesDataStoreId);
        controller.serialize(buffer, this.requestResolverIdentitiesDataStoreId);
        controller.serialize(buffer, this.providerRequestResolverAssignmentDataStoreId);
        controller.serialize(buffer, this.requestResolverRequestAssignmentDataStoreId);
        controller.serialize(buffer, this.requestableTypeRequestResolverAssignmentDataStoreId);
        controller.serialize(buffer, this.playerRequestResolverId);
        controller.serialize(buffer, this.retryingRequestResolverId);
    }

    @Override
    public void deserialize(IFactoryController controller, FriendlyByteBuf buffer) {
        this.version = buffer.readInt();
        this.dataStoreManager = (IDataStoreManager)controller.deserialize(buffer);
        this.requestIdentitiesDataStoreId = (IToken)controller.deserialize(buffer);
        this.requestResolverIdentitiesDataStoreId = (IToken)controller.deserialize(buffer);
        this.providerRequestResolverAssignmentDataStoreId = (IToken)controller.deserialize(buffer);
        this.requestResolverRequestAssignmentDataStoreId = (IToken)controller.deserialize(buffer);
        this.requestableTypeRequestResolverAssignmentDataStoreId = (IToken)controller.deserialize(buffer);
        this.playerRequestResolverId = (IToken)controller.deserialize(buffer);
        this.retryingRequestResolverId = (IToken)controller.deserialize(buffer);
    }

    private <T> void executeDeserializationStepOrMarkForUpdate(@NotNull CompoundTag nbt, @NotNull String key, @NotNull BiFunction<CompoundTag, String, T> extractor, @NotNull Consumer<T> valueConsumer) {
        T base;
        if (!nbt.m_128441_(key)) {
            this.markForUpdate();
            return;
        }
        try {
            base = extractor.apply(nbt, key);
        }
        catch (Exception ex) {
            this.markForUpdate();
            return;
        }
        valueConsumer.accept(base);
    }

    private void markForUpdate() {
        this.version = -1;
    }

    @Override
    public void log(String message) {
        if (this.enableLogging) {
            this.logger.debug(message);
        }
    }

    @Override
    public void tick() {
        this.getRetryingRequestResolver().updateManager(this);
        this.getRetryingRequestResolver().tick();
    }

    @Override
    @NotNull
    public IRequestIdentitiesDataStore getRequestIdentitiesDataStore() {
        return this.dataStoreManager.get(this.requestIdentitiesDataStoreId, TypeConstants.REQUEST_IDENTITIES_DATA_STORE);
    }

    @Override
    @NotNull
    public IRequestResolverIdentitiesDataStore getRequestResolverIdentitiesDataStore() {
        return this.dataStoreManager.get(this.requestResolverIdentitiesDataStoreId, TypeConstants.REQUEST_RESOLVER_IDENTITIES_DATA_STORE);
    }

    @Override
    @NotNull
    public IProviderResolverAssignmentDataStore getProviderResolverAssignmentDataStore() {
        return this.dataStoreManager.get(this.providerRequestResolverAssignmentDataStoreId, TypeConstants.PROVIDER_REQUEST_RESOLVER_ASSIGNMENT_DATA_STORE);
    }

    @Override
    @NotNull
    public IRequestResolverRequestAssignmentDataStore getRequestResolverRequestAssignmentDataStore() {
        return this.dataStoreManager.get(this.requestResolverRequestAssignmentDataStoreId, TypeConstants.REQUEST_RESOLVER_REQUEST_ASSIGNMENT_DATA_STORE);
    }

    @Override
    @NotNull
    public IRequestableTypeRequestResolverAssignmentDataStore getRequestableTypeRequestResolverAssignmentDataStore() {
        return this.dataStoreManager.get(this.requestableTypeRequestResolverAssignmentDataStoreId, TypeConstants.REQUESTABLE_TYPE_REQUEST_RESOLVER_ASSIGNMENT_DATA_STORE);
    }

    @Override
    public IProviderHandler getProviderHandler() {
        return this.providerHandler;
    }

    @Override
    public IRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    @Override
    public IResolverHandler getResolverHandler() {
        return this.resolverHandler;
    }

    @Override
    public ITokenHandler getTokenHandler() {
        return this.tokenHandler;
    }

    @Override
    public IUpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    private void updateIfRequired() {
        if (this.version < this.updateHandler.getCurrentVersion()) {
            this.reset(UpdateType.DATA_LOAD);
        }
    }

    @Override
    public int getCurrentVersion() {
        return this.version;
    }

    @Override
    public void setCurrentVersion(int currentVersion) {
        this.version = currentVersion;
    }
}

