/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.data;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IDataStore;
import com.minecolonies.api.colony.requestsystem.data.IDataStoreManager;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class StandardDataStoreManager
implements IDataStoreManager {
    private final Map<IToken<?>, IDataStore> storeMap;

    public StandardDataStoreManager(Map<IToken<?>, IDataStore> storeMap) {
        this.storeMap = storeMap;
    }

    public StandardDataStoreManager() {
        this(new HashMap());
    }

    @Override
    public <T extends IDataStore> T get(IToken<?> id, TypeToken<T> type) {
        return (T)this.get(id, () -> (IDataStore)StandardFactoryController.getInstance().getNewInstance(type));
    }

    @Override
    public <T extends IDataStore> T get(IToken<?> id, Supplier<T> factory) {
        if (!this.storeMap.containsKey(id)) {
            IDataStore defaultInstance = (IDataStore)factory.get();
            defaultInstance.setId(id);
            this.storeMap.put(id, defaultInstance);
        }
        return (T)this.storeMap.get(id);
    }

    @Override
    public void remove(IToken<?> id) {
        this.storeMap.remove(id);
    }

    @Override
    public void removeAll() {
        this.storeMap.clear();
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardDataStoreManager> {
        @Override
        @NotNull
        public TypeToken<? extends StandardDataStoreManager> getFactoryOutputType() {
            return TypeToken.of(StandardDataStoreManager.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardDataStoreManager getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardDataStoreManager();
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardDataStoreManager standardDataStoreManager) {
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("List", (Tag)standardDataStoreManager.storeMap.keySet().stream().map(iToken -> {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.m_128365_("Token", (Tag)controller.serialize(iToken));
                entryCompound.m_128365_("Value", (Tag)controller.serialize(standardDataStoreManager.storeMap.get(iToken)));
                return entryCompound;
            }).collect(NBTUtils.toListNBT()));
            return compound;
        }

        @Override
        @NotNull
        public StandardDataStoreManager deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) throws Throwable {
            Map<IToken<?>, IDataStore> storeMap = NBTUtils.streamCompound(nbt.m_128437_("List", 10)).map(CompoundTag2 -> {
                IToken token = (IToken)controller.deserialize(CompoundTag2.m_128469_("Token"));
                IDataStore store = (IDataStore)controller.deserialize(CompoundTag2.m_128469_("Value"));
                return new Tuple((Object)token, (Object)store);
            }).collect(Collectors.toMap(Tuple::m_14418_, Tuple::m_14419_));
            return new StandardDataStoreManager(storeMap);
        }

        @Override
        public void serialize(IFactoryController controller, StandardDataStoreManager input, FriendlyByteBuf packetBuffer) {
            packetBuffer.writeInt(input.storeMap.size());
            input.storeMap.forEach((key, value) -> {
                controller.serialize(packetBuffer, key);
                controller.serialize(packetBuffer, value);
            });
        }

        @Override
        public StandardDataStoreManager deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
            HashMap storeMap = new HashMap();
            int storeSize = buffer.readInt();
            for (int i = 0; i < storeSize; ++i) {
                storeMap.put((IToken)controller.deserialize(buffer), (IDataStore)controller.deserialize(buffer));
            }
            return new StandardDataStoreManager(storeMap);
        }

        @Override
        public short getSerializationId() {
            return 40;
        }
    }
}

