/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.colony.managers.interfaces.IStatisticsManager;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class StatisticsManager
implements IStatisticsManager {
    private static final String TAG_STAT_MANAGER = "stat_manager";
    private static final String TAG_STAT = "stat";
    private final Map<String, Int2IntLinkedOpenHashMap> stats = new HashMap<String, Int2IntLinkedOpenHashMap>();

    @Override
    public void increment(@NotNull String id, int day) {
        this.incrementBy(id, 1, day);
    }

    @Override
    public void incrementBy(@NotNull String id, int qty, int day) {
        Int2IntLinkedOpenHashMap innerMap = this.stats.computeIfAbsent(id, k -> new Int2IntLinkedOpenHashMap());
        innerMap.addTo(day, qty);
    }

    @Override
    public int getStatTotal(@NotNull String id) {
        Int2IntLinkedOpenHashMap stats = this.stats.getOrDefault(id, new Int2IntLinkedOpenHashMap());
        int totalCount = 0;
        IntIterator intIterator = stats.values().iterator();
        while (intIterator.hasNext()) {
            int count = (Integer)intIterator.next();
            totalCount += count;
        }
        return totalCount;
    }

    @Override
    public int getStatsInPeriod(@NotNull String id, int startDay, int endDay) {
        Int2IntLinkedOpenHashMap stats = this.stats.getOrDefault(id, new Int2IntLinkedOpenHashMap());
        int count = 0;
        for (int day = startDay; day <= endDay; ++day) {
            count += stats.get(day);
        }
        return count;
    }

    @Override
    @NotNull
    public Set<String> getStatTypes() {
        return this.stats.keySet();
    }

    @Override
    public void serialize(@NotNull FriendlyByteBuf buf) {
        buf.m_130130_(this.stats.size());
        for (Map.Entry<String, Int2IntLinkedOpenHashMap> dataEntry : this.stats.entrySet()) {
            buf.m_130070_(dataEntry.getKey());
            buf.m_130130_(dataEntry.getValue().size());
            for (Int2IntMap.Entry valueEntry : dataEntry.getValue().int2IntEntrySet()) {
                buf.m_130130_(valueEntry.getIntKey());
                buf.m_130130_(valueEntry.getIntValue());
            }
        }
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.stats.clear();
        int statSize = buf.m_130242_();
        for (int i = 0; i < statSize; ++i) {
            String id = buf.m_130277_();
            int statEntrySize = buf.m_130242_();
            Int2IntLinkedOpenHashMap statValues = new Int2IntLinkedOpenHashMap(statEntrySize);
            for (int j = 0; j < statEntrySize; ++j) {
                statValues.put(buf.m_130242_(), buf.m_130242_());
            }
            this.stats.put(id, statValues);
        }
    }

    @Override
    public void writeToNBT(@NotNull CompoundTag compound) {
        ListTag statManagerNBT = new ListTag();
        for (Map.Entry<String, Int2IntLinkedOpenHashMap> stat : this.stats.entrySet()) {
            CompoundTag statCompound = new CompoundTag();
            statCompound.m_128359_("id", stat.getKey());
            ListTag statNBT = new ListTag();
            for (Map.Entry dailyStats : stat.getValue().entrySet()) {
                CompoundTag timeStampTag = new CompoundTag();
                timeStampTag.m_128405_("time", ((Integer)dailyStats.getKey()).intValue());
                timeStampTag.m_128405_("quantity", ((Integer)dailyStats.getValue()).intValue());
                statNBT.add((Object)timeStampTag);
            }
            statCompound.m_128365_(TAG_STAT, (Tag)statNBT);
            statManagerNBT.add((Object)statCompound);
        }
        compound.m_128365_(TAG_STAT_MANAGER, (Tag)statManagerNBT);
    }

    @Override
    public void readFromNBT(@NotNull CompoundTag compound) {
        this.stats.clear();
        if (compound.m_128441_(TAG_STAT_MANAGER)) {
            ListTag statsNbts = compound.m_128437_(TAG_STAT_MANAGER, 10);
            for (int i = 0; i < statsNbts.size(); ++i) {
                CompoundTag statCompound = statsNbts.m_128728_(i);
                String id = statCompound.m_128461_("id");
                ListTag timeStampNbts = statCompound.m_128437_(TAG_STAT, 10);
                Int2IntLinkedOpenHashMap timeStamps = new Int2IntLinkedOpenHashMap();
                for (int j = 0; j < timeStampNbts.size(); ++j) {
                    CompoundTag compoundTag = timeStampNbts.m_128728_(j);
                    int day = compoundTag.m_128451_("time");
                    int qty = compoundTag.m_128451_("quantity");
                    timeStamps.put(day, qty);
                }
                this.stats.put(id, timeStamps);
            }
        }
    }
}

