/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewWorkOrderMessage;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;

public class ColonyPackageManager
implements IColonyPackageManager {
    @NotNull
    private Set<ServerPlayer> closeSubscribers = new HashSet<ServerPlayer>();
    private Set<ServerPlayer> importantColonyPlayers = new HashSet<ServerPlayer>();
    private Set<ServerPlayer> newSubscribers = new HashSet<ServerPlayer>();
    private boolean isDirty = false;
    private int ticksPassed = 0;
    private int lastContactInHours = 0;
    private final Colony colony;

    public ColonyPackageManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public int getLastContactInHours() {
        return this.lastContactInHours;
    }

    @Override
    public void setLastContactInHours(int lastContactInHours) {
        this.lastContactInHours = lastContactInHours;
    }

    @Override
    public Set<ServerPlayer> getCloseSubscribers() {
        return this.closeSubscribers;
    }

    @Override
    public void updateSubscribers() {
        Level world = this.colony.getWorld();
        if (world == null || world.m_7654_() == null) {
            return;
        }
        this.updateClosePlayers();
        this.updateColonyViews();
    }

    private void updateClosePlayers() {
        Iterator<ServerPlayer> iterator = this.closeSubscribers.iterator();
        while (iterator.hasNext()) {
            ServerPlayer player = iterator.next();
            if (!player.m_6084_() || this.colony.getWorld() != player.f_19853_ || !WorldUtil.isChunkLoaded((LevelAccessor)player.f_19853_, player.m_146902_().f_45578_, player.m_146902_().f_45579_)) {
                iterator.remove();
                continue;
            }
            LevelChunk chunk = this.colony.getWorld().m_6325_(player.m_146902_().f_45578_, player.m_146902_().f_45579_);
            if (chunk.m_6430_()) {
                iterator.remove();
                continue;
            }
            IColonyTagCapability colonyCap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
            if (colonyCap == null) {
                iterator.remove();
                continue;
            }
            if (colonyCap.getOwningColony() == this.colony.getID()) continue;
            iterator.remove();
        }
    }

    @Override
    public void updateAwayTime() {
        if (this.importantColonyPlayers.isEmpty()) {
            if (this.ticksPassed >= 72000) {
                this.ticksPassed = 0;
                ++this.lastContactInHours;
                this.colony.markDirty();
            }
            this.ticksPassed += 100;
        } else if (this.lastContactInHours != 0) {
            this.lastContactInHours = 0;
            this.ticksPassed = 0;
            this.colony.markDirty();
        }
    }

    public void updateColonyViews() {
        if (!this.closeSubscribers.isEmpty() || !this.newSubscribers.isEmpty()) {
            this.sendColonyViewPackets();
            this.sendPermissionsPackets();
            this.sendWorkOrderPackets();
            this.colony.getCitizenManager().sendPackets(this.closeSubscribers, this.newSubscribers);
            this.colony.getVisitorManager().sendPackets(this.closeSubscribers, this.newSubscribers);
            this.colony.getBuildingManager().sendPackets(this.closeSubscribers, this.newSubscribers);
            this.colony.getResearchManager().sendPackets(this.closeSubscribers, this.newSubscribers);
        }
        if (this.newSubscribers.isEmpty()) {
            this.isDirty = false;
        }
        this.colony.getPermissions().clearDirty();
        this.colony.getBuildingManager().clearDirty();
        this.colony.getCitizenManager().clearDirty();
        this.colony.getVisitorManager().clearDirty();
        this.colony.getResearchManager().clearDirty();
        this.newSubscribers = new HashSet<ServerPlayer>();
    }

    @Override
    public void sendColonyViewPackets() {
        if (this.isDirty || !this.newSubscribers.isEmpty()) {
            FriendlyByteBuf colonyFriendlyByteBuf = new FriendlyByteBuf(Unpooled.buffer());
            ColonyView.serializeNetworkData(this.colony, colonyFriendlyByteBuf, !this.newSubscribers.isEmpty());
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.isDirty) {
                players.addAll(this.closeSubscribers);
            }
            players.addAll(this.newSubscribers);
            ColonyViewMessage message = new ColonyViewMessage(this.colony, colonyFriendlyByteBuf);
            for (ServerPlayer player : players) {
                message.setIsNewSubscription(this.newSubscribers.contains(player));
                Network.getNetwork().sendToPlayer(message, player);
            }
        }
        this.colony.getRequestManager().setDirty(false);
    }

    @Override
    public void sendPermissionsPackets() {
        Permissions permissions = this.colony.getPermissions();
        if (permissions.isDirty() || !this.newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.isDirty) {
                players.addAll(this.closeSubscribers);
            }
            players.addAll(this.newSubscribers);
            players.forEach(player -> Network.getNetwork().sendToPlayer(new PermissionsMessage.View(this.colony, permissions.getRank((Player)player)), (ServerPlayer)player));
        }
    }

    @Override
    public void sendWorkOrderPackets() {
        IWorkManager workManager = this.colony.getWorkManager();
        if (workManager.isDirty() || !this.newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            players.addAll(this.closeSubscribers);
            players.addAll(this.newSubscribers);
            ArrayList<IWorkOrder> workOrders = new ArrayList<IWorkOrder>(workManager.getWorkOrders().values());
            ColonyViewWorkOrderMessage message = new ColonyViewWorkOrderMessage(this.colony, workOrders);
            players.forEach(player -> Network.getNetwork().sendToPlayer(message, (ServerPlayer)player));
            workManager.setDirty(false);
        }
    }

    @Override
    public void setDirty() {
        this.isDirty = true;
    }

    @Override
    public void addCloseSubscriber(@NotNull ServerPlayer subscriber) {
        if (!this.closeSubscribers.contains(subscriber)) {
            this.closeSubscribers.add(subscriber);
            this.newSubscribers.add(subscriber);
            this.updateColonyViews();
        }
    }

    @Override
    public void removeCloseSubscriber(@NotNull ServerPlayer player) {
        this.newSubscribers.remove(player);
        this.closeSubscribers.remove(player);
    }

    @Override
    public void addImportantColonyPlayer(@NotNull ServerPlayer subscriber) {
        this.importantColonyPlayers.add(subscriber);
        this.newSubscribers.add(subscriber);
    }

    @Override
    public void removeImportantColonyPlayer(@NotNull ServerPlayer subscriber) {
        this.importantColonyPlayers.remove(subscriber);
        this.newSubscribers.remove(subscriber);
    }

    @Override
    public Set<ServerPlayer> getImportantColonyPlayers() {
        return this.importantColonyPlayers;
    }
}

