/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.jobs.IJobWithExternalWorkStations;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.colony.buildings.modules.QuarryModule;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.entity.ai.citizen.miner.EntityAIQuarrier;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import org.jetbrains.annotations.NotNull;

public class JobQuarrier
extends AbstractJobStructure<EntityAIQuarrier, JobQuarrier>
implements IJobWithExternalWorkStations {
    public JobQuarrier(ICitizenData entity) {
        super(entity);
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.MINER_ID;
    }

    @Override
    @NotNull
    public EntityAIQuarrier generateAI() {
        return new EntityAIQuarrier(this);
    }

    @Override
    public int getDiseaseModifier() {
        return 2;
    }

    public IBuilding findQuarry() {
        for (IBuilding building : this.getColony().getBuildingManager().getBuildings().values()) {
            if (!building.getBuildingType().getRegistryName().m_135815_().contains("quarry") || !((QuarryModule)building.getFirstModuleOccurance(QuarryModule.class)).hasAssignedCitizen(this.getCitizen())) continue;
            return building;
        }
        return null;
    }

    @Override
    public boolean assignTo(IAssignsJob module) {
        if (module == null || !module.getJobEntry().equals(this.getJobRegistryEntry())) {
            return false;
        }
        if (module instanceof QuarryModule) {
            return true;
        }
        return super.assignTo(module);
    }

    @Override
    public List<IBuilding> getWorkStations() {
        IBuilding building = this.findQuarry();
        return building == null ? Collections.emptyList() : ImmutableList.of((Object)building);
    }

    @Override
    public boolean ignoresDamage(@NotNull DamageSource damageSource) {
        if (damageSource.m_269150_().m_203565_(DamageTypes.f_268546_) || damageSource.m_269150_().m_203565_(DamageTypes.f_268631_) || damageSource.m_269150_().m_203565_(DamageTypes.f_268468_)) {
            return this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FIRE_RES) > 0.0;
        }
        return super.ignoresDamage(damageSource);
    }
}

