/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.citizen.netherworker.EntityAIWorkNether;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class JobNetherWorker
extends AbstractJobCrafter<EntityAIWorkNether, JobNetherWorker> {
    private boolean citizenInNether = false;
    private Queue<ItemStack> craftedResults = new LinkedList<ItemStack>();
    private Queue<ItemStack> processedResults = new LinkedList<ItemStack>();
    private final String TAG_IN_NETHER = "inNether";
    private final String TAG_CRAFTED = "craftedResults";
    private final String TAG_PROCESSED = "processedResults";

    public JobNetherWorker(ICitizenData entity) {
        super(entity);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag craftedList = new ListTag();
        this.craftedResults.forEach(item -> {
            @NotNull CompoundTag itemCompound = item.serializeNBT();
            craftedList.add((Object)itemCompound);
        });
        compound.m_128365_("craftedResults", (Tag)craftedList);
        @NotNull ListTag processedList = new ListTag();
        this.processedResults.forEach(item -> {
            @NotNull CompoundTag itemCompound = item.serializeNBT();
            processedList.add((Object)itemCompound);
        });
        compound.m_128365_("processedResults", (Tag)processedList);
        compound.m_128379_("inNether", this.citizenInNether);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag craftedList = compound.m_128437_("craftedResults", 10);
        for (int i = 0; i < craftedList.size(); ++i) {
            CompoundTag itemCompound = craftedList.m_128728_(i);
            this.craftedResults.add(ItemStack.m_41712_((CompoundTag)itemCompound));
        }
        ListTag processedList = compound.m_128437_("processedResults", 10);
        for (int i = 0; i < processedList.size(); ++i) {
            CompoundTag itemCompound = processedList.m_128728_(i);
            this.processedResults.add(ItemStack.m_41712_((CompoundTag)itemCompound));
        }
        if (compound.m_128441_("inNether")) {
            this.citizenInNether = compound.m_128471_("inNether");
        }
    }

    @Override
    public EntityAIWorkNether generateAI() {
        return new EntityAIWorkNether(this);
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.NETHERWORKER_ID;
    }

    @Override
    public int getDiseaseModifier() {
        if (this.getCitizen().getEntity().isPresent() && this.getCitizen().getEntity().get().m_20145_()) {
            return 0;
        }
        return super.getDiseaseModifier();
    }

    @Override
    public int getIdleSeverity(boolean isDemand) {
        if (isDemand) {
            return super.getIdleSeverity(isDemand);
        }
        return 4;
    }

    public void setInNether(boolean away) {
        this.citizenInNether = away;
    }

    public boolean isInNether() {
        return this.citizenInNether;
    }

    public Queue<ItemStack> getCraftedResults() {
        return this.craftedResults;
    }

    public boolean addCraftedResultsList(Collection<ItemStack> newResults) {
        return this.craftedResults.addAll(newResults);
    }

    public Queue<ItemStack> getProcessedResults() {
        return this.processedResults;
    }

    public boolean addProcessedResultsList(Collection<ItemStack> newResults) {
        return this.processedResults.addAll(newResults);
    }

    @Override
    public boolean ignoresDamage(@NotNull DamageSource damageSource) {
        if (damageSource.m_269150_().m_203565_(DamageTypes.f_268546_) || damageSource.m_269150_().m_203565_(DamageTypes.f_268631_) || damageSource.m_269150_().m_203565_(DamageTypes.f_268468_)) {
            return this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FIRE_RES) > 0.0;
        }
        return super.ignoresDamage(damageSource);
    }
}

