/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModRecipeTypes;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRecipe {
    public static final String RECIPE_TYPE_PROP = "type";
    public static final String RECIPE_TYPE_RECIPE = "recipe";
    public static final String RECIPE_TYPE_RECIPE_MULT_OUT = "recipe-multi-out";
    public static final String RECIPE_TYPE_RECIPE_MULT_IN = "recipe-multi-in";
    public static final String RECIPE_TYPE_TEMPLATE = "recipe-template";
    public static final String RECIPE_TYPE_REMOVE = "remove";
    public static final String RECIPE_ID_TO_REMOVE_PROP = "recipe-id-to-remove";
    public static final String RECIPE_CRAFTER_PROP = "crafter";
    public static final String RECIPE_INPUTS_PROP = "inputs";
    public static final String RECIPE_SECONDARY_PROP = "additional-output";
    public static final String RECIPE_ALTERNATE_PROP = "alternate-output";
    public static final String RECIPE_RESULT_PROP = "result";
    public static final String RECIPE_LOOTTABLE_PROP = "loot-table";
    public static final String RECIPE_TOOL_PROP = "tool";
    public static final String RECIPE_INTERMEDIATE_PROP = "intermediate";
    public static final String RECIPE_RESEARCHID_PROP = "research-id";
    public static final String RECIPE_EXCLUDED_RESEARCHID_PROP = "not-research-id";
    public static final String RECIPE_BUILDING_MIN_LEVEL_PROP = "min-building-level";
    public static final String RECIPE_BUILDING_MAX_LEVEL_PROP = "max-building-level";
    public static final String RECIPE_MUST_EXIST = "must-exist";
    public static final String RECIPE_SHOW_TOOLTIP = "show-tooltip";
    public static final String RECIPE_TAG = "tag";
    public static final String RECIPE_FILTER = "filter";
    private String crafter = "unknown";
    private ResourceLocation recipeId = null;
    private List<ItemStorage> inputs = new ArrayList<ItemStorage>();
    private List<ItemStack> altOutputs = new ArrayList<ItemStack>();
    private ItemStack result = null;
    private List<ItemStack> secondary = new ArrayList<ItemStack>();
    private Block intermediate = Blocks.f_50016_;
    private ResourceLocation researchId = null;
    private ResourceLocation excludedResearchId = null;
    private int minBldgLevel = 0;
    private int maxBldgLevel = 5;
    private boolean mustExist = false;
    private boolean showTooltip = false;
    private ResourceLocation lootTable;
    private IToolType requiredTool = ToolType.NONE;
    private RecipeStorage cachedRecipeStorage;

    private CustomRecipe() {
    }

    public static CustomRecipe parse(@NotNull ResourceLocation recipeId, @NotNull JsonObject recipeJson) {
        ItemStack stack;
        JsonObject ingredient;
        CustomRecipe recipe = new CustomRecipe();
        recipe.recipeId = recipeId;
        if (recipeJson.has(RECIPE_CRAFTER_PROP)) {
            recipe.crafter = recipeJson.get(RECIPE_CRAFTER_PROP).getAsString();
        }
        if (recipeJson.has(RECIPE_INPUTS_PROP)) {
            for (JsonElement e : recipeJson.get(RECIPE_INPUTS_PROP).getAsJsonArray()) {
                ItemStorage parsed;
                if (!e.isJsonObject() || (parsed = new ItemStorage(ingredient = e.getAsJsonObject())).isEmpty()) continue;
                recipe.inputs.add(parsed);
            }
        }
        recipe.result = recipeJson.has(RECIPE_RESULT_PROP) ? ItemStackUtils.idToItemStack(recipeJson.get(RECIPE_RESULT_PROP).getAsString()) : ItemStack.f_41583_;
        if (recipeJson.has(RECIPE_LOOTTABLE_PROP)) {
            recipe.lootTable = new ResourceLocation(recipeJson.get(RECIPE_LOOTTABLE_PROP).getAsString());
        }
        if (recipeJson.has(RECIPE_TOOL_PROP)) {
            recipe.requiredTool = ToolType.getToolType(recipeJson.get(RECIPE_TOOL_PROP).getAsString());
        }
        if (recipeJson.has(RECIPE_SECONDARY_PROP)) {
            for (JsonElement e : recipeJson.get(RECIPE_SECONDARY_PROP).getAsJsonArray()) {
                if (!e.isJsonObject() || !(ingredient = e.getAsJsonObject()).has("item")) continue;
                stack = ItemStackUtils.idToItemStack(ingredient.get("item").getAsString());
                if (ingredient.has("count")) {
                    stack.m_41764_(ingredient.get("count").getAsInt());
                }
                recipe.secondary.add(stack);
            }
        }
        if (recipeJson.has(RECIPE_ALTERNATE_PROP)) {
            for (JsonElement e : recipeJson.get(RECIPE_ALTERNATE_PROP).getAsJsonArray()) {
                if (!e.isJsonObject() || !(ingredient = e.getAsJsonObject()).has("item")) continue;
                stack = ItemStackUtils.idToItemStack(ingredient.get("item").getAsString());
                if (ingredient.has("count")) {
                    stack.m_41764_(ingredient.get("count").getAsInt());
                }
                recipe.altOutputs.add(stack);
            }
        }
        if (recipeJson.has("count") && !ItemStackUtils.isEmpty(recipe.result)) {
            recipe.result.m_41764_(recipeJson.get("count").getAsInt());
        }
        recipe.intermediate = recipeJson.has(RECIPE_INTERMEDIATE_PROP) ? (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(recipeJson.get(RECIPE_INTERMEDIATE_PROP).getAsString())) : Blocks.f_50016_;
        if (recipeJson.has(RECIPE_RESEARCHID_PROP)) {
            recipe.researchId = new ResourceLocation(recipeJson.get(RECIPE_RESEARCHID_PROP).getAsString());
        }
        if (recipeJson.has(RECIPE_EXCLUDED_RESEARCHID_PROP)) {
            recipe.excludedResearchId = new ResourceLocation(recipeJson.get(RECIPE_EXCLUDED_RESEARCHID_PROP).getAsString());
        }
        if (recipeJson.has(RECIPE_BUILDING_MIN_LEVEL_PROP)) {
            recipe.minBldgLevel = recipeJson.get(RECIPE_BUILDING_MIN_LEVEL_PROP).getAsInt();
        }
        if (recipeJson.has(RECIPE_BUILDING_MAX_LEVEL_PROP)) {
            recipe.maxBldgLevel = recipeJson.get(RECIPE_BUILDING_MAX_LEVEL_PROP).getAsInt();
        }
        if (recipeJson.has(RECIPE_MUST_EXIST)) {
            recipe.mustExist = recipeJson.get(RECIPE_MUST_EXIST).getAsBoolean();
        }
        if (recipeJson.has(RECIPE_SHOW_TOOLTIP)) {
            recipe.showTooltip = recipeJson.get(RECIPE_SHOW_TOOLTIP).getAsBoolean();
        }
        return recipe;
    }

    @NotNull
    public static List<CustomRecipe> parseTemplate(@NotNull ResourceLocation baseId, @NotNull JsonObject templateJson) {
        Predicate<ResourceLocation> filter;
        ArrayList<CustomRecipe> recipes = new ArrayList<CustomRecipe>();
        ResourceLocation tagId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)templateJson, (String)RECIPE_TAG));
        JsonObject baseRecipeJson = GsonHelper.m_13930_((JsonObject)templateJson, (String)RECIPE_TYPE_RECIPE);
        JsonElement filterJson = templateJson.get(RECIPE_FILTER);
        if (filterJson != null && filterJson.isJsonObject()) {
            Predicate<ResourceLocation> include = CustomRecipe.parseArrayOrStringFilter(filterJson.getAsJsonObject().get("include"), true);
            Predicate<ResourceLocation> exclude = CustomRecipe.parseArrayOrStringFilter(filterJson.getAsJsonObject().get("exclude"), false);
            filter = id -> include.test((ResourceLocation)id) && !exclude.test((ResourceLocation)id);
        } else {
            filter = CustomRecipe.parseArrayOrStringFilter(filterJson, true);
        }
        boolean logStatus = (Boolean)IMinecoloniesAPI.getInstance().getConfig().getServer().auditCraftingTags.get();
        for (Item item : ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)tagId))) {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
            if (!filter.test(itemId)) continue;
            ResourceLocation recipeId = new ResourceLocation(baseId.m_135827_(), baseId.m_135815_() + "/" + itemId.m_135827_() + "/" + itemId.m_135815_());
            JsonObject recipeJson = CustomRecipe.populateTemplate(baseId, baseRecipeJson, itemId, logStatus);
            if (recipeJson == null) continue;
            recipes.add(CustomRecipe.parse(recipeId, recipeJson));
        }
        return recipes;
    }

    @NotNull
    private static Predicate<ResourceLocation> parseArrayOrStringFilter(@Nullable JsonElement filterJson, boolean defaultResult) {
        if (filterJson == null) {
            return id -> defaultResult;
        }
        if (filterJson.isJsonArray()) {
            List<String> strings = StreamSupport.stream(filterJson.getAsJsonArray().spliterator(), false).map(JsonElement::getAsString).toList();
            return id -> strings.stream().anyMatch(f -> id.toString().contains((CharSequence)f));
        }
        String filterString = filterJson.getAsString();
        return id -> id.toString().contains(filterString);
    }

    @Nullable
    private static JsonObject populateTemplate(@NotNull ResourceLocation templateId, @NotNull JsonObject baseRecipeJson, @NotNull ResourceLocation itemId, boolean logStatus) {
        Tuple<Boolean, String> result;
        Tuple<Boolean, String> output;
        JsonObject recipeJson = baseRecipeJson.deepCopy();
        if (recipeJson.has(RECIPE_INPUTS_PROP)) {
            for (Object e : recipeJson.get(RECIPE_INPUTS_PROP).getAsJsonArray()) {
                Tuple<Boolean, String> result2;
                if (!e.isJsonObject() || !Boolean.FALSE.equals((result2 = CustomRecipe.populateTemplateItem(e.getAsJsonObject(), "item", itemId)).getA())) continue;
                if (logStatus) {
                    Log.getLogger().error("Template {} with {}: rejecting {} {}", (Object)templateId, (Object)itemId, (Object)RECIPE_INPUTS_PROP, (Object)result2.getB());
                }
                return null;
            }
        }
        if (Boolean.FALSE.equals((output = CustomRecipe.populateTemplateItem(recipeJson, RECIPE_RESULT_PROP, itemId)).getA())) {
            if (logStatus) {
                Log.getLogger().error("Template {} with {}: rejecting {} {}", (Object)templateId, (Object)itemId, (Object)RECIPE_RESULT_PROP, (Object)output.getB());
            }
            return null;
        }
        if (recipeJson.has(RECIPE_SECONDARY_PROP)) {
            for (JsonElement e : recipeJson.get(RECIPE_SECONDARY_PROP).getAsJsonArray()) {
                if (!e.isJsonObject() || !Boolean.FALSE.equals((result = CustomRecipe.populateTemplateItem(e.getAsJsonObject(), "item", itemId)).getA())) continue;
                if (logStatus) {
                    Log.getLogger().error("Template {} with {}: rejecting {} {}", (Object)templateId, (Object)itemId, (Object)RECIPE_SECONDARY_PROP, (Object)result.getB());
                }
                return null;
            }
        }
        if (recipeJson.has(RECIPE_ALTERNATE_PROP)) {
            Iterator iterator = recipeJson.get(RECIPE_ALTERNATE_PROP).getAsJsonArray().iterator();
            while (iterator.hasNext()) {
                JsonElement e;
                e = (JsonElement)iterator.next();
                if (!e.isJsonObject() || !Boolean.FALSE.equals((result = CustomRecipe.populateTemplateItem(e.getAsJsonObject(), "item", itemId)).getA())) continue;
                if (logStatus) {
                    Log.getLogger().warn("Template {} with {}: ignoring {} {}", (Object)templateId, (Object)itemId, (Object)RECIPE_ALTERNATE_PROP, (Object)result.getB());
                }
                iterator.remove();
            }
        }
        if (!(recipeJson.has(RECIPE_RESULT_PROP) || recipeJson.has(RECIPE_LOOTTABLE_PROP) || recipeJson.has(RECIPE_ALTERNATE_PROP) && !recipeJson.getAsJsonArray(RECIPE_ALTERNATE_PROP).isEmpty())) {
            if (logStatus) {
                Log.getLogger().warn("Template {} with {}: rejecting, no outputs", (Object)templateId, (Object)itemId);
            }
            return null;
        }
        if (logStatus) {
            Log.getLogger().info("Template {} with {}: success", (Object)templateId, (Object)itemId);
        }
        return recipeJson;
    }

    private static Tuple<Boolean, String> populateTemplateItem(@NotNull JsonObject obj, @NotNull String prop, @NotNull ResourceLocation itemId) {
        if (obj.has(prop)) {
            Tuple<Boolean, String> result = ItemStackUtils.parseIdTemplate(GsonHelper.m_13906_((JsonObject)obj, (String)prop), itemId);
            obj.addProperty(prop, result.getB());
            return result;
        }
        return new Tuple<Boolean, Object>(true, null);
    }

    public CustomRecipe(String crafter, int minBldgLevel, int maxBldgLevel, boolean mustExist, boolean showTooltip, ResourceLocation recipeId, @Nullable ResourceLocation researchReq, @Nullable ResourceLocation researchExclude, @Nullable ResourceLocation lootTable, IToolType requiredTool, List<ItemStorage> inputs, ItemStack primaryOutput, List<ItemStack> secondaryOutput, List<ItemStack> altOutputs, Block intermediate) {
        this.crafter = crafter;
        this.recipeId = recipeId;
        this.researchId = researchReq;
        this.excludedResearchId = researchExclude;
        this.minBldgLevel = minBldgLevel;
        this.maxBldgLevel = maxBldgLevel;
        this.mustExist = mustExist;
        this.showTooltip = showTooltip;
        this.inputs = inputs;
        this.result = primaryOutput;
        this.secondary = secondaryOutput;
        this.altOutputs = altOutputs;
        this.lootTable = lootTable;
        this.requiredTool = requiredTool;
        this.intermediate = intermediate;
    }

    public String getCrafter() {
        return this.crafter;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public List<ItemStorage> getInputs() {
        return this.inputs;
    }

    public ItemStack getPrimaryOutput() {
        return this.result;
    }

    public List<ItemStack> getSecondaryOutput() {
        return this.secondary;
    }

    public List<ItemStack> getAltOutputs() {
        return this.altOutputs;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    @NotNull
    public IToolType getRequiredTool() {
        return this.requiredTool;
    }

    public ResourceLocation getRequiredResearchId() {
        return this.researchId;
    }

    public ResourceLocation getExcludedResearchId() {
        return this.excludedResearchId;
    }

    public int getMinBuildingLevel() {
        return this.minBldgLevel;
    }

    public int getMaxBuildingLevel() {
        return this.maxBldgLevel;
    }

    public boolean isValidForBuilding(IBuilding building) {
        IColony colony = building.getColony();
        boolean requiredEffectPresent = this.researchId != null ? this.isUnlockEffectResearched(this.researchId, colony) : false;
        boolean excludedEffectPresent = this.excludedResearchId != null ? this.isUnlockEffectResearched(this.excludedResearchId, colony) : false;
        if (this.isPrecursorRecipeMissing(building)) {
            return false;
        }
        int bldgLevel = building.getBuildingLevel();
        return !(this.researchId != null && !requiredEffectPresent || this.excludedResearchId != null && excludedEffectPresent || bldgLevel < this.minBldgLevel || bldgLevel > this.maxBldgLevel);
    }

    private boolean isUnlockEffectResearched(ResourceLocation researchId, IColony colony) {
        if (!IGlobalResearchTree.getInstance().hasResearchEffect(researchId) && !IGlobalResearchTree.getInstance().hasResearch(researchId)) {
            return false;
        }
        if (IGlobalResearchTree.getInstance().hasResearchEffect(researchId) && colony.getResearchManager().getResearchEffects().getEffectStrength(researchId) > 0.0) {
            return true;
        }
        return IGlobalResearchTree.getInstance().hasResearch(researchId) && colony.getResearchManager().getResearchTree().hasCompletedResearch(researchId);
    }

    private boolean isPrecursorRecipeMissing(IBuilding building) {
        if (this.mustExist) {
            IRecipeStorage compareStorage = this.getRecipeStorage();
            ResourceLocation recipeSource = this.getRecipeId();
            for (ICraftingBuildingModule module : building.getModulesByType(ICraftingBuildingModule.class)) {
                for (IToken<?> recipeToken : module.getRecipes()) {
                    IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(recipeToken);
                    if ((storage.getRecipeSource() == null || !storage.getRecipeSource().equals((Object)recipeSource)) && (!ItemStackUtils.compareItemStacksIgnoreStackSize(storage.getPrimaryOutput(), compareStorage.getPrimaryOutput(), false, true) || !storage.getCleanedInput().containsAll(compareStorage.getCleanedInput()) || !compareStorage.getCleanedInput().containsAll(storage.getCleanedInput()))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public IRecipeStorage getRecipeStorage() {
        if (this.cachedRecipeStorage == null) {
            this.cachedRecipeStorage = this.altOutputs.isEmpty() ? StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{this.inputs, 1, this.result, this.intermediate, this.getRecipeId(), ModRecipeTypes.CLASSIC_ID, null, this.secondary, this.lootTable, this.requiredTool}) : StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{this.inputs, 1, this.result, this.intermediate, this.getRecipeId(), ModRecipeTypes.MULTI_OUTPUT_ID, this.altOutputs, this.secondary, this.lootTable, this.requiredTool});
            IRecipeManager recipeManager = IColonyManager.getInstance().getRecipeManager();
            IToken<?> cachedRecipeToken = recipeManager.getRecipeId(this.cachedRecipeStorage);
            if (cachedRecipeToken != null && !cachedRecipeToken.equals(this.cachedRecipeStorage.getToken())) {
                this.cachedRecipeStorage = (RecipeStorage)recipeManager.getRecipes().get(cachedRecipeToken);
            }
            recipeManager.registerUse(this.cachedRecipeStorage.getToken());
        }
        return this.cachedRecipeStorage;
    }

    public int hashCode() {
        return Objects.hash(this.result, this.researchId, this.excludedResearchId, this.lootTable, this.requiredTool, this.inputs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomRecipe that = (CustomRecipe)o;
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.result, that.result) != false && Objects.equals(this.researchId, that.researchId) && Objects.equals(this.excludedResearchId, that.excludedResearchId) && Objects.equals(this.lootTable, that.lootTable) && Objects.equals(this.requiredTool, that.requiredTool) && this.inputs.equals(that.inputs);
    }

    public boolean getMustExist() {
        return this.mustExist;
    }

    public Block getIntermediate() {
        return this.intermediate;
    }

    public boolean getShowTooltip() {
        return this.showTooltip;
    }
}

