/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents;

import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyStructureSpawnEvent;
import com.minecolonies.api.entity.mobs.AbstractEntityRaiderMob;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipBasedRaiderUtils;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipSize;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractShipRaidEvent
implements IColonyRaidEvent,
IColonyStructureSpawnEvent {
    private static final int WAYPOINT_SPACING = 30;
    public static final String TAG_DAYS_LEFT = "pirateDaysLeft";
    public static final String TAG_SPAWNER_COUNT = "spawnerCount";
    public static final String TAG_POS = "pos";
    public static final String TAG_SPAWNERS = "spawners";
    public static final String TAG_SHIPSIZE = "shipSize";
    public static final String TAG_SHIPROTATION = "shipRotation";
    public static final String TAG_KILLED = "killed";
    private static final int MAX_LANDING_DISTANCE = 200;
    private static final int MIN_CENTER_DISTANCE = 200;
    private static final int ADD_MAX_PIRATES = 10;
    private EventStatus status = EventStatus.STARTING;
    protected final ServerBossEvent raidBar = new ServerBossEvent((Component)Component.m_237113_((String)"Colony Raid"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
    private int id;
    private IColony colony;
    private BlockPos spawnPoint;
    private ShipSize shipSize;
    private int daysToGo;
    private Map<Entity, UUID> raiders;
    private List<Tuple<EntityType<?>, BlockPos>> respawns;
    private int shipRotation;
    private List<BlockPos> spawners;
    private int maxSpawners;
    private PathResult spawnPathResult;
    private List<BlockPos> wayPoints;

    public AbstractShipRaidEvent(@NotNull IColony colony) {
        this.daysToGo = (Integer)MineColonies.getConfig().getServer().daysUntilPirateshipsDespawn.get();
        this.raiders = new WeakHashMap<Entity, UUID>();
        this.respawns = new ArrayList();
        this.shipRotation = 0;
        this.spawners = new ArrayList<BlockPos>();
        this.maxSpawners = 0;
        this.wayPoints = new ArrayList<BlockPos>();
        this.colony = colony;
        this.id = colony.getEventManager().getAndTakeNextEventID();
    }

    @Override
    public void onStart() {
        this.status = EventStatus.PREPARING;
        this.daysToGo = (Integer)MineColonies.getConfig().getServer().daysUntilPirateshipsDespawn.get();
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)"Minecolonies Original", (String)("decorations/ships/" + this.shipSize.schematicPrefix + this.getShipDesc() + ".blueprint")), this.colony.getWorld(), blueprint -> {
            blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(this.shipRotation), Mirror.NONE, this.colony.getWorld());
            if (this.spawnPathResult != null && this.spawnPathResult.isDone()) {
                BlockPos endpoint;
                Path path = this.spawnPathResult.getPath();
                if (path != null && path.m_77403_() && ShipBasedRaiderUtils.canPlaceShipAt(endpoint = path.m_77395_().m_77288_().m_7495_(), blueprint, this.colony.getWorld())) {
                    this.spawnPoint = endpoint;
                }
                this.wayPoints = ShipBasedRaiderUtils.createWaypoints(this.colony.getWorld(), path, 30);
            }
            if (!ShipBasedRaiderUtils.canPlaceShipAt(this.spawnPoint, blueprint, this.colony.getWorld())) {
                this.spawnPoint = this.spawnPoint.m_7495_();
            }
            if (!ShipBasedRaiderUtils.spawnPirateShip(this.spawnPoint, this.colony, blueprint, this)) {
                this.status = EventStatus.CANCELED;
                return;
            }
            this.updateRaidBar();
            MessageUtils.format("event.minecolonies.raidmessage_p" + this.shipSize.messageID, BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint), this.colony.getName()).with(ChatFormatting.DARK_RED).sendTo(this.colony).forManagers();
            this.colony.markDirty();
        }));
    }

    protected void updateRaidBar() {
        Component directionName = BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint);
        this.raidBar.m_6456_((Component)this.getDisplayName().m_130946_(" - ").m_7220_(directionName));
        for (Player player : this.colony.getPackageManager().getCloseSubscribers()) {
            this.raidBar.m_6543_((ServerPlayer)player);
        }
        this.raidBar.m_8321_(true);
    }

    protected abstract MutableComponent getDisplayName();

    @Override
    public void onUpdate() {
        BlockPos spawnPos;
        this.status = EventStatus.PROGRESSING;
        this.colony.getRaiderManager().setNightsSinceLastRaid(0);
        if (this.spawners.size() <= 0 && this.raiders.size() == 0 && this.respawns.isEmpty()) {
            this.status = EventStatus.WAITING;
            return;
        }
        this.updateRaidBar();
        if (!this.respawns.isEmpty()) {
            for (Tuple<EntityType<?>, BlockPos> entry : this.respawns) {
                BlockPos spawnPos2 = ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(entry.getB(), this.colony, 200, this.spawnPoint, 200, 10);
                if (spawnPos2 == null) continue;
                RaiderMobUtils.spawn(entry.getA(), 1, spawnPos2, this.colony.getWorld(), this.colony, this.id);
            }
            this.respawns.clear();
            return;
        }
        this.spawners.removeIf(spawner -> this.colony.getWorld() != null && WorldUtil.isBlockLoaded((LevelAccessor)this.colony.getWorld(), spawner) && this.colony.getWorld().m_8055_(spawner).m_60734_() != Blocks.f_50085_);
        if (this.raiders.size() < this.spawners.size() * 2 && (spawnPos = ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(this.spawnPoint, this.colony, 200, this.spawnPoint, 200, 10)) != null) {
            if (spawnPos.m_123331_((Vec3i)this.spawnPoint) < 25.0) {
                spawnPos = ShipBasedRaiderUtils.findSpawnPosOnShip(spawnPos, this.colony.getWorld(), 3);
            }
            RaiderMobUtils.spawn(this.getNormalRaiderType(), this.shipSize.normal, spawnPos, this.colony.getWorld(), this.colony, this.id);
            RaiderMobUtils.spawn(this.getArcherRaiderType(), this.shipSize.archer, spawnPos, this.colony.getWorld(), this.colony, this.id);
            RaiderMobUtils.spawn(this.getBossRaiderType(), this.shipSize.boss, spawnPos, this.colony.getWorld(), this.colony, this.id);
        }
        if (this.colony.getRaiderManager().areSpiesEnabled()) {
            for (Entity entity : this.getEntities()) {
                if (!(entity instanceof LivingEntity)) continue;
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 550));
            }
        }
    }

    @Override
    public void setMercyEnd() {
    }

    @Override
    public void onFinish() {
        MessageUtils.format("com.minecolonies.coremod.pirates.sailing.away", BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint), this.colony.getName()).sendTo(this.colony).forManagers();
        for (Entity entity : this.raiders.keySet()) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.raidBar.m_8321_(false);
        this.raidBar.m_7706_();
    }

    @Override
    public void onTileEntityBreak(BlockEntity te) {
        if (te instanceof SpawnerBlockEntity) {
            this.spawners.remove(te.m_58899_());
            this.raidBar.m_142711_((float)this.spawners.size() / (float)this.maxSpawners);
            if (this.spawners.isEmpty()) {
                this.daysToGo = 2;
                MessageUtils.format("com.minecolonies.coremod.pirates.spawners.destroyed", this.colony.getName()).sendTo(this.colony).forManagers();
            }
        }
    }

    @Override
    public void onNightFall() {
        --this.daysToGo;
        if (this.daysToGo <= 0) {
            this.status = EventStatus.DONE;
        }
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        this.raiders.remove(entity);
        if (this.raiders.isEmpty() && this.spawners.isEmpty()) {
            this.status = EventStatus.WAITING;
            MessageUtils.format("com.minecolonies.coremod.pirates.killed", this.colony.getName()).sendTo(this.colony).forManagers();
        }
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityRaiderMob) || !entity.m_6084_() || this.status != EventStatus.PROGRESSING) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.raiders.keySet().size() < this.getMaxRaiders()) {
            this.raiders.put(entity, entity.m_20148_());
        } else {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public void unregisterEntity(Entity entity) {
        if (!this.raiders.containsKey(entity) || this.status != EventStatus.PROGRESSING || this.colony.getState() != ColonyState.ACTIVE) {
            return;
        }
        this.raiders.remove(entity);
        this.respawns.add(new Tuple<EntityType, BlockPos>(entity.m_6095_(), entity.m_20183_()));
    }

    private int getMaxRaiders() {
        return this.spawners.size() * 2 + 10;
    }

    public void setShipSize(ShipSize shipSize) {
        this.shipSize = shipSize;
    }

    public void setShipRotation(int shipRotation) {
        this.shipRotation = shipRotation;
    }

    @Override
    public void setColony(@NotNull IColony colony) {
        this.colony = colony;
    }

    @Override
    public void setSpawnPoint(BlockPos spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    @Override
    public BlockPos getSpawnPos() {
        return this.spawnPoint;
    }

    @Override
    public List<Entity> getEntities() {
        return new ArrayList<Entity>(this.raiders.keySet());
    }

    @Override
    public EventStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EventStatus status) {
        this.status = status;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public List<Tuple<String, BlockPos>> getSchematicSpawns() {
        ArrayList<Tuple<String, BlockPos>> paths = new ArrayList<Tuple<String, BlockPos>>();
        paths.add(new Tuple<CallSite, BlockPos>((CallSite)((Object)("decorations/ships/" + this.shipSize.schematicPrefix + this.getShipDesc() + ".blueprint")), this.spawnPoint));
        return paths;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("mc_event_id", this.id);
        compound.m_128405_(TAG_DAYS_LEFT, this.daysToGo);
        compound.m_128405_("eventStatus", this.status.ordinal());
        @NotNull ListTag spawnerListCompound = new ListTag();
        for (BlockPos entry : this.spawners) {
            @NotNull CompoundTag spawnerCompound = new CompoundTag();
            spawnerCompound.m_128365_(TAG_POS, (Tag)NbtUtils.m_129224_((BlockPos)entry));
            spawnerListCompound.add((Object)spawnerCompound);
        }
        compound.m_128365_(TAG_SPAWNERS, (Tag)spawnerListCompound);
        compound.m_128405_(TAG_SPAWNER_COUNT, this.maxSpawners);
        BlockPosUtil.write(compound, "spawnPos", this.spawnPoint);
        compound.m_128405_(TAG_SHIPSIZE, this.shipSize.ordinal());
        compound.m_128405_(TAG_SHIPROTATION, this.shipRotation);
        BlockPosUtil.writePosListToNBT(compound, "waypoints", this.wayPoints);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.id = compound.m_128451_("mc_event_id");
        this.status = EventStatus.values()[compound.m_128451_("eventStatus")];
        this.daysToGo = compound.m_128451_(TAG_DAYS_LEFT);
        @NotNull ListTag spawnerListCompound = compound.m_128437_(TAG_SPAWNERS, 10);
        for (int i = 0; i < spawnerListCompound.size(); ++i) {
            this.spawners.add(NbtUtils.m_129239_((CompoundTag)spawnerListCompound.m_128728_(i).m_128469_(TAG_POS)));
        }
        this.maxSpawners = compound.m_128451_(TAG_SPAWNER_COUNT);
        this.spawnPoint = BlockPosUtil.read(compound, "spawnPos");
        this.shipSize = ShipSize.values()[compound.m_128451_(TAG_SHIPSIZE)];
        this.shipRotation = compound.m_128451_(TAG_SHIPROTATION);
        this.wayPoints = BlockPosUtil.readPosListFromNBT(compound, "waypoints");
    }

    @Override
    public void addSpawner(BlockPos pos) {
        this.spawners.add(pos);
        ++this.maxSpawners;
    }

    @Override
    public List<BlockPos> getWayPoints() {
        return this.wayPoints;
    }

    public void setSpawnPath(PathResult result) {
        this.spawnPathResult = result;
    }

    @Override
    public boolean isRaidActive() {
        if (this.getStatus() == EventStatus.PROGRESSING) {
            return !this.spawners.isEmpty() || !this.raiders.isEmpty() || !this.respawns.isEmpty();
        }
        return this.getStatus() == EventStatus.PROGRESSING || this.getStatus() == EventStatus.PREPARING;
    }
}

