/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IHasRequiredItemsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.IntSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingCowboy
extends AbstractBuilding {
    private static final String COWBOY = "cowboy";
    private static final String HUT_NAME = "cowboyhut";
    private static final int MAX_BUILDING_LEVEL = 5;
    public static final ISettingKey<IntSetting> MILKING_AMOUNT = new SettingKey<IntSetting>(IntSetting.class, new ResourceLocation("minecolonies", "milking_amount"));
    public static final ISettingKey<IntSetting> STEWING_AMOUNT = new SettingKey<IntSetting>(IntSetting.class, new ResourceLocation("minecolonies", "stewing_amount"));
    public static final ISettingKey<IntSetting> MILKING_DAYS = new SettingKey<IntSetting>(IntSetting.class, new ResourceLocation("minecolonies", "milking_days"));

    public BuildingCowboy(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COWBOY;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42405_) {
            return false;
        }
        return super.canEat(stack);
    }

    public static class HerdingModule
    extends AnimalHerdingModule
    implements IBuildingEventsModule,
    IHasRequiredItemsModule,
    IPersistentModule {
        private int currentMilk;
        private int currentStew;
        private int currentMilkDays;

        public HerdingModule() {
            super((JobEntry)ModJobs.cowboy.get(), a -> a instanceof Cow, new ItemStack((ItemLike)Items.f_42405_, 2));
        }

        @Override
        public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
            int days = Math.max(1, this.getBuilding().getSetting(MILKING_DAYS).getValue());
            int bucketsToKeep = (int)Math.ceil(2.0 * (double)this.getBuilding().getSetting(MILKING_AMOUNT).getValue().intValue() / (double)days);
            int bowlsToKeep = (int)Math.ceil(2.0 * (double)this.getBuilding().getSetting(STEWING_AMOUNT).getValue().intValue() / (double)days);
            HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> requiredItems = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>();
            if (bucketsToKeep > 0) {
                requiredItems.put(s -> s.m_150930_(Items.f_42446_), (Tuple<Integer, Boolean>)new Tuple((Object)bucketsToKeep, (Object)false));
            }
            if (bowlsToKeep > 0) {
                requiredItems.put(s -> s.m_150930_(Items.f_42399_), (Tuple<Integer, Boolean>)new Tuple((Object)bowlsToKeep, (Object)false));
            }
            return requiredItems;
        }

        @Override
        public Map<ItemStorage, Integer> reservedStacksExcluding(@Nullable IRequest<? extends IDeliverable> excluded) {
            return Collections.emptyMap();
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getRecipesForDisplayPurposesOnly(@NotNull Animal animal) {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getRecipesForDisplayPurposesOnly(animal));
            if (animal instanceof MushroomCow) {
                recipes.add(new GenericRecipe(null, new ItemStack((ItemLike)Items.f_42400_), Collections.singletonList(new ItemStack((ItemLike)Items.f_42718_)), Collections.emptyList(), Collections.singletonList(Collections.singletonList(new ItemStack((ItemLike)Items.f_42399_))), 1, Blocks.f_50016_, null, ToolType.NONE, (LivingEntity)animal, Collections.emptyList(), 0));
            } else if (animal instanceof Cow) {
                recipes.add(new GenericRecipe(null, new ItemStack((ItemLike)Items.f_42455_), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(Collections.singletonList(new ItemStack((ItemLike)Items.f_42446_))), 1, Blocks.f_50016_, null, ToolType.NONE, (LivingEntity)animal, Collections.emptyList(), 0));
            }
            return recipes;
        }

        @Override
        public void serializeNBT(@NotNull CompoundTag compound) {
            compound.m_128405_("milkValue", this.currentMilk);
            compound.m_128405_("stewValue", this.currentStew);
            compound.m_128405_("milkDays", this.currentMilkDays);
        }

        @Override
        public void deserializeNBT(CompoundTag compound) {
            this.currentMilk = compound.m_128451_("milkValue");
            this.currentStew = compound.m_128451_("stewValue");
            this.currentMilkDays = compound.m_128451_("milkDays");
        }

        @Override
        public void onWakeUp() {
            ++this.currentMilkDays;
            if (this.currentMilkDays >= this.getBuilding().getSetting(MILKING_DAYS).getValue()) {
                this.currentMilk = 0;
                this.currentStew = 0;
                this.currentMilkDays = 0;
            }
        }

        public boolean canTryToMilk() {
            return this.currentMilk < this.getBuilding().getSetting(MILKING_AMOUNT).getValue();
        }

        public boolean canTryToStew() {
            return this.currentStew < this.getBuilding().getSetting(STEWING_AMOUNT).getValue();
        }

        public void onMilked() {
            ++this.currentMilk;
        }

        public void onStewed() {
            ++this.currentStew;
        }
    }
}

