/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.WorkAtHomeBuildingModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.HayBlock;
import org.jetbrains.annotations.NotNull;

public class BuildingCombatAcademy
extends AbstractBuilding {
    private static final String SCHEMATIC_NAME = "combatacademy";
    private static final String DESC = "combatacademy";
    private final List<BlockPos> fightingPos = new ArrayList<BlockPos>();
    private final BiMap<Integer, Integer> trainingPartners = HashBiMap.create();

    public BuildingCombatAcademy(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        if (block instanceof CarvedPumpkinBlock && world.m_8055_(pos.m_7495_()).m_60734_() instanceof HayBlock) {
            this.fightingPos.add(pos.m_7495_());
        }
        super.registerBlockPosition(block, pos, world);
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.fightingPos.clear();
        ListTag targetList = compound.m_128437_("combatTarget", 10);
        this.fightingPos.addAll(NBTUtils.streamCompound(targetList).map(targetCompound -> BlockPosUtil.read(targetCompound, "target")).collect(Collectors.toList()));
        ListTag partnersTagList = compound.m_128437_("combatPartner", 10);
        this.trainingPartners.putAll(NBTUtils.streamCompound(partnersTagList).collect(Collectors.toMap(targetCompound -> targetCompound.m_128451_("combatPartner1"), targetCompound -> targetCompound.m_128451_("combatPartner2"))));
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        ListTag targetList = this.fightingPos.stream().map(target -> BlockPosUtil.write(new CompoundTag(), "target", target)).collect(NBTUtils.toListNBT());
        compound.m_128365_("combatTarget", (Tag)targetList);
        ListTag partnersTagList = this.trainingPartners.entrySet().stream().map(BuildingCombatAcademy::writePartnerTupleToNBT).collect(NBTUtils.toListNBT());
        compound.m_128365_("combatPartner", (Tag)partnersTagList);
        return compound;
    }

    private static CompoundTag writePartnerTupleToNBT(Map.Entry<Integer, Integer> tuple) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("combatPartner1", tuple.getKey().intValue());
        compound.m_128405_("combatPartner2", tuple.getValue().intValue());
        return compound;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return "combatacademy";
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public BlockPos getRandomCombatTarget(RandomSource random) {
        if (!this.fightingPos.isEmpty()) {
            return this.fightingPos.get(random.m_188503_(this.fightingPos.size()));
        }
        return null;
    }

    public AbstractEntityCitizen getRandomCombatPartner(AbstractEntityCitizen citizen) {
        ICitizenData citizenData = citizen.getCitizenData();
        if (citizenData != null) {
            ICitizenData partner = ((WorkAtHomeBuildingModule)this.getFirstModuleOccurance(WorkAtHomeBuildingModule.class)).getAssignedCitizen().stream().filter(data -> data.getId() != citizenData.getId()).filter(data -> !this.trainingPartners.containsKey((Object)data.getId())).filter(data -> !this.trainingPartners.containsValue((Object)data.getId())).findFirst().orElse(null);
            if (partner != null) {
                this.trainingPartners.put((Object)citizenData.getId(), (Object)partner.getId());
                return partner.getEntity().orElse(null);
            }
            return null;
        }
        return null;
    }

    public boolean hasCombatPartner(AbstractEntityCitizen citizen) {
        return this.getCombatPartner(citizen) != null;
    }

    public AbstractEntityCitizen getCombatPartner(AbstractEntityCitizen citizen) {
        ICitizenData data = citizen.getCitizenData();
        if (data != null) {
            int citizenId;
            if (this.trainingPartners.containsKey((Object)data.getId())) {
                citizenId = (Integer)this.trainingPartners.get((Object)data.getId());
            } else if (this.trainingPartners.containsValue((Object)data.getId())) {
                citizenId = (Integer)this.trainingPartners.inverse().get((Object)data.getId());
            } else {
                return null;
            }
            ICitizenData citizenData = ((WorkAtHomeBuildingModule)this.getFirstModuleOccurance(WorkAtHomeBuildingModule.class)).getAssignedCitizen().stream().filter(cit -> cit.getId() != data.getId()).filter(cit -> cit.getId() == citizenId).findFirst().orElse(null);
            if (citizenData != null) {
                return citizenData.getEntity().orElse(null);
            }
        }
        return null;
    }

    public void resetPartner(AbstractEntityCitizen worker) {
        ICitizenData data = worker.getCitizenData();
        if (data != null) {
            if (this.trainingPartners.containsKey((Object)data.getId())) {
                this.trainingPartners.remove((Object)data.getId());
            } else if (this.trainingPartners.containsValue((Object)data.getId())) {
                this.trainingPartners.inverse().remove((Object)data.getId());
            }
        }
    }
}

