/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.moduleviews;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.coremod.network.messages.server.colony.building.fields.AssignFieldMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.fields.AssignmentModeMessage;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FieldsModuleView
extends AbstractBuildingModuleView {
    private boolean shouldAssignFieldManually;
    private int maxFieldCount;

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.shouldAssignFieldManually = buf.readBoolean();
        this.maxFieldCount = buf.readInt();
    }

    @Override
    public String getIcon() {
        return "field";
    }

    @Override
    public String getDesc() {
        return "com.minecolonies.coremod.gui.workerhuts.fields";
    }

    public boolean assignFieldManually() {
        return this.shouldAssignFieldManually;
    }

    public void setAssignFieldManually(boolean assignFieldManually) {
        this.shouldAssignFieldManually = assignFieldManually;
        Network.getNetwork().sendToServer(new AssignmentModeMessage(this.buildingView, assignFieldManually, this.getProducer().getRuntimeID()));
    }

    public void assignField(IField field) {
        if (this.buildingView != null && this.canAssignField(field)) {
            Network.getNetwork().sendToServer(new AssignFieldMessage(this.buildingView, field, true, this.getProducer().getRuntimeID()));
            WorkerBuildingModuleView buildingModuleView = this.buildingView.getModuleViewMatching(WorkerBuildingModuleView.class, view -> true);
            if (buildingModuleView != null) {
                field.setBuilding(this.buildingView.getID());
            }
        }
    }

    public final boolean canAssignField(IField field) {
        return this.getOwnedFields().size() < this.maxFieldCount && this.canAssignFieldOverride(field);
    }

    @NotNull
    public List<IField> getOwnedFields() {
        return this.getFields().stream().filter(field -> this.buildingView.getID().equals((Object)field.getBuildingId())).distinct().sorted(new FieldsComparator(this.buildingView)).toList();
    }

    protected abstract boolean canAssignFieldOverride(IField var1);

    @NotNull
    public List<IField> getFields() {
        return this.getFieldsInColony().stream().filter(field -> !field.isTaken() || this.buildingView.getID().equals((Object)field.getBuildingId())).distinct().sorted(new FieldsComparator(this.buildingView)).toList();
    }

    protected abstract List<IField> getFieldsInColony();

    public void freeField(IField field) {
        if (this.buildingView != null) {
            Network.getNetwork().sendToServer(new AssignFieldMessage(this.buildingView, field, false, this.getProducer().getRuntimeID()));
            WorkerBuildingModuleView buildingModuleView = this.buildingView.getModuleViewMatching(WorkerBuildingModuleView.class, view -> true);
            if (buildingModuleView != null) {
                field.resetOwningBuilding();
            }
        }
    }

    @Nullable
    public MutableComponent getFieldWarningTooltip(IField field) {
        if (this.getOwnedFields().size() >= this.maxFieldCount) {
            return Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.fields.fieldcount.reached");
        }
        return null;
    }

    public int getMaxFieldCount() {
        return this.maxFieldCount;
    }

    static class FieldsComparator
    implements Comparator<IField> {
        private final IBuildingView assignedBuilding;

        public FieldsComparator(IBuildingView assignedBuilding) {
            this.assignedBuilding = assignedBuilding;
        }

        @Override
        public int compare(IField field1, IField field2) {
            if (field1.isTaken() && field2.isTaken()) {
                return field1.getSqDistance(this.assignedBuilding) - field2.getSqDistance(this.assignedBuilding);
            }
            if (field1.isTaken()) {
                return -1;
            }
            if (field2.isTaken()) {
                return 1;
            }
            return field1.getSqDistance(this.assignedBuilding) - field2.getSqDistance(this.assignedBuilding);
        }
    }
}

