/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IntSetting
implements ISetting<Integer> {
    private final int defaultValue;
    private int value;

    public IntSetting(int init) {
        this.value = init;
        this.defaultValue = init;
    }

    public IntSetting(int value, int def) {
        this.value = value;
        this.defaultValue = def;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public int getDefault() {
        return this.defaultValue;
    }

    @Override
    public ResourceLocation getLayoutItem() {
        return new ResourceLocation("minecolonies:gui/layouthuts/layoutintsetting.xml");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        ((TextField)pane.findPaneOfTypeByID("trigger", TextField.class)).setHandler(input -> {
            try {
                if (input.getText().isEmpty()) {
                    this.value = 0;
                } else {
                    this.value = Integer.parseInt(input.getText());
                    settingsModuleView.trigger(key);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        TextField field = (TextField)pane.findPaneOfTypeByID("trigger", TextField.class);
        field.setEnabled(this.isActive(settingsModuleView));
        this.setInActiveHoverPane((Pane)field, settingsModuleView);
        if (!field.getText().equals(String.valueOf(this.value))) {
            field.setText(String.valueOf(this.value));
        }
    }

    @Override
    public void copyValue(ISetting setting) {
        if (setting instanceof IntSetting) {
            IntSetting other = (IntSetting)setting;
            this.setValue(other.getValue());
        }
    }

    public void setValue(int value) {
        this.value = value;
    }
}

