/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.modules.BuildingModules;
import com.minecolonies.coremod.colony.buildings.modules.settings.StringSettingWithDesc;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class GuardTaskSetting
extends StringSettingWithDesc {
    public static final String PATROL = "com.minecolonies.core.guard.setting.patrol";
    public static final String GUARD = "com.minecolonies.core.guard.setting.guard";
    public static final String FOLLOW = "com.minecolonies.core.guard.setting.follow";
    public static final String PATROL_MINE = "com.minecolonies.core.guard.setting.patrol_mine";
    private static final int SET_POS_BUTTON_WIDTH = 60;
    private static final int HELP_BUTTON_WIDTH = 125;

    public GuardTaskSetting() {
        super(PATROL, GUARD, FOLLOW, PATROL_MINE);
    }

    public GuardTaskSetting(String ... list) {
        super(list);
    }

    public GuardTaskSetting(List<String> settings, int currentIndex) {
        super(settings, currentIndex);
    }

    @Override
    public ResourceLocation getLayoutItem() {
        return new ResourceLocation("minecolonies:gui/layouthuts/layoutguardtasksetting.xml");
    }

    @Override
    public void onUpdate(IBuilding building, ServerPlayer sender) {
        if (building instanceof AbstractBuildingGuards) {
            AbstractBuildingGuards guardBuilding = (AbstractBuildingGuards)building;
            if (this.getValue().equals(FOLLOW)) {
                guardBuilding.setPlayerToFollow((Player)sender);
            }
        }
    }

    @Override
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        super.setupHandler(key, pane, settingsModuleView, building, window);
        ButtonImage setPositionsButton = (ButtonImage)pane.findPaneOfTypeByID("setPositions", ButtonImage.class);
        setPositionsButton.setHandler(button -> building.getModuleView(BuildingModules.GUARD_TOOL).getWindow().open());
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        super.render(key, pane, settingsModuleView, building, window);
        ButtonImage setPositionsButton = (ButtonImage)pane.findPaneOfTypeByID("setPositions", ButtonImage.class);
        ButtonImage helpButton = (ButtonImage)pane.findPaneOfTypeByID("helpButton", ButtonImage.class);
        switch (this.getValue()) {
            case "com.minecolonies.core.guard.setting.patrol": {
                String patrolMode = settingsModuleView.getSetting(AbstractBuildingGuards.PATROL_MODE).getValue();
                setPositionsButton.setVisible(patrolMode.equals("com.minecolonies.core.guard.setting.patrol.manual"));
                helpButton.setVisible(false);
                break;
            }
            case "com.minecolonies.core.guard.setting.guard": {
                setPositionsButton.setVisible(true);
                break;
            }
            case "com.minecolonies.core.guard.setting.patrol_mine": {
                setPositionsButton.setVisible(false);
                helpButton.setVisible(true);
                this.setPatrolMineHelpLabel(helpButton, (AbstractBuildingGuards.View)building);
                break;
            }
            default: {
                setPositionsButton.setVisible(false);
                helpButton.setVisible(false);
            }
        }
    }

    @Override
    protected int getButtonWidth(ISettingsModuleView settingsModuleView) {
        return switch (this.getValue()) {
            case PATROL -> {
                String patrolMode = settingsModuleView.getSetting(AbstractBuildingGuards.PATROL_MODE).getValue();
                if (patrolMode.equals("com.minecolonies.core.guard.setting.patrol.manual")) {
                    yield 60;
                }
                yield 145;
            }
            case GUARD -> 60;
            case PATROL_MINE -> 125;
            default -> 145;
        };
    }

    private void setPatrolMineHelpLabel(ButtonImage button, AbstractBuildingGuards.View building) {
        MutableComponent component = building.getMinePos() != null ? Component.m_237110_((String)"com.minecolonies.coremod.gui.worherhuts.patrollingmine", (Object[])new Object[]{building.getMinePos().m_123344_()}) : Component.m_237115_((String)"com.minecolonies.coremod.job.guard.assignmine");
        ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append((Component)component)).hoverPane((Pane)button).build();
    }
}

