/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoolSetting
implements ISetting<Boolean> {
    private final boolean defaultValue;
    private boolean value;

    public BoolSetting(boolean init) {
        this.value = init;
        this.defaultValue = init;
    }

    public BoolSetting(boolean value, boolean def) {
        this.value = value;
        this.defaultValue = def;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    public boolean getDefault() {
        return this.defaultValue;
    }

    @Override
    public ResourceLocation getLayoutItem() {
        return new ResourceLocation("minecolonies:gui/layouthuts/layoutboolsetting.xml");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> settingsModuleView.trigger(key));
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        ButtonImage triggerButton = (ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class);
        triggerButton.setEnabled(this.isActive(settingsModuleView));
        triggerButton.setText(Component.m_237115_((String)(this.value ? "com.minecolonies.coremod.gui.workerhuts.retrieveon" : "com.minecolonies.coremod.gui.workerhuts.retrieveoff")));
        this.setInActiveHoverPane((Pane)triggerButton, settingsModuleView);
    }

    @Override
    public void trigger() {
        this.value = !this.value;
    }

    @Override
    public void copyValue(ISetting setting) {
        if (setting instanceof BoolSetting) {
            BoolSetting other = (BoolSetting)setting;
            this.value = other.value;
        }
    }
}

