/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.GuardFollowModeSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.GuardPatrolModeSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.GuardTaskSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.requestsystem.locations.EntityLocation;
import com.minecolonies.coremod.colony.requestsystem.locations.StaticLocation;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobRandomPos;
import com.minecolonies.coremod.items.ItemBannerRallyGuards;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import com.minecolonies.coremod.util.ServerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingGuards
extends AbstractBuilding
implements IGuardBuilding {
    public static final ISettingKey<BoolSetting> RETREAT = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "retreat"));
    public static final ISettingKey<BoolSetting> HIRE_TRAINEE = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "hiretrainee"));
    public static final ISettingKey<GuardPatrolModeSetting> PATROL_MODE = new SettingKey<GuardPatrolModeSetting>(GuardPatrolModeSetting.class, new ResourceLocation("minecolonies", "patrolmode"));
    public static final ISettingKey<GuardFollowModeSetting> FOLLOW_MODE = new SettingKey<GuardFollowModeSetting>(GuardFollowModeSetting.class, new ResourceLocation("minecolonies", "followmode"));
    public static final ISettingKey<GuardTaskSetting> GUARD_TASK = new SettingKey<GuardTaskSetting>(GuardTaskSetting.class, new ResourceLocation("minecolonies", "guardtask"));
    private static final String NBT_JOB = "guardType";
    private static final String NBT_PATROL_TARGETS = "patrol targets";
    private static final String NBT_TARGET = "target";
    private static final String NBT_GUARD = "guard";
    private static final String NBT_MINE_POS = "minePos";
    private static final String NBT_PLAYER_UUID = "playeruuid";
    private static final int PATROL_BASE_DIST = 50;
    private static final int BONUS_HEALTH_PER_LEVEL = 2;
    private static final int VISION_RANGE_PER_LEVEL = 3;
    private static final int BASE_VISION_RANGE = 15;
    private BlockPos guardPos = this.getID();
    protected List<BlockPos> patrolTargets = new ArrayList<BlockPos>();
    private UUID followPlayerUUID;
    private ILocation rallyLocation;
    protected BlockPos tempNextPatrolPoint = null;
    private PathResult pathResult;
    private BlockPos minePos;
    public static final String HOSTILE_LIST = "hostiles";
    private final Set<AbstractEntityCitizen> arrivedAtPatrol = new HashSet<AbstractEntityCitizen>();
    private BlockPos lastPatrolPoint;
    private int patrolTimer = 0;

    public AbstractBuildingGuards(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.BOW, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && ItemStackUtils.doesItemServeAsWeapon(itemStack), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && itemStack.m_41720_() instanceof ArmorItem && ((ArmorItem)itemStack.m_41720_()).m_40402_() == EquipmentSlot.CHEST, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && itemStack.m_41720_() instanceof ArmorItem && ((ArmorItem)itemStack.m_41720_()).m_40402_() == EquipmentSlot.HEAD, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && itemStack.m_41720_() instanceof ArmorItem && ((ArmorItem)itemStack.m_41720_()).m_40402_() == EquipmentSlot.LEGS, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && itemStack.m_41720_() instanceof ArmorItem && ((ArmorItem)itemStack.m_41720_()).m_40402_() == EquipmentSlot.FEET, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> {
            if (ItemStackUtils.isEmpty(itemStack) || !(itemStack.m_41720_() instanceof ArrowItem)) {
                return false;
            }
            return this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_USE_ARROWS) > 0.0;
        }, new Tuple((Object)128, (Object)true));
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        if (this.getAllAssignedCitizen() != null) {
            for (ICitizenData optCitizen : this.getAllAssignedCitizen()) {
                if (!optCitizen.getEntity().isPresent()) continue;
                AttributeModifier healthModBuildingHP = new AttributeModifier("MinecoloniesGuardBuildingHP", (double)this.getBonusHealth(), AttributeModifier.Operation.ADDITION);
                AttributeModifierUtils.addHealthModifier((LivingEntity)optCitizen.getEntity().get(), healthModBuildingHP);
            }
        }
        super.onUpgradeComplete(newLevel);
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag wayPointTagList = compound.m_128437_(NBT_PATROL_TARGETS, 10);
        for (int i = 0; i < wayPointTagList.size(); ++i) {
            CompoundTag blockAtPos = wayPointTagList.m_128728_(i);
            BlockPos pos = BlockPosUtil.read(blockAtPos, NBT_TARGET);
            this.patrolTargets.add(pos);
        }
        this.guardPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_(NBT_GUARD));
        if (compound.m_128441_(NBT_MINE_POS)) {
            this.minePos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_(NBT_MINE_POS));
        }
        if (compound.m_128441_(NBT_PLAYER_UUID)) {
            this.followPlayerUUID = compound.m_128342_(NBT_PLAYER_UUID);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag wayPointTagList = new ListTag();
        for (BlockPos pos : this.patrolTargets) {
            @NotNull CompoundTag wayPointCompound = new CompoundTag();
            BlockPosUtil.write(wayPointCompound, NBT_TARGET, pos);
            wayPointTagList.add((Object)wayPointCompound);
        }
        compound.m_128365_(NBT_PATROL_TARGETS, (Tag)wayPointTagList);
        compound.m_128365_(NBT_GUARD, (Tag)NbtUtils.m_129224_((BlockPos)this.guardPos));
        if (this.minePos != null) {
            compound.m_128365_(NBT_MINE_POS, (Tag)NbtUtils.m_129224_((BlockPos)this.minePos));
        }
        if (this.followPlayerUUID != null) {
            compound.m_128362_(NBT_PLAYER_UUID, this.followPlayerUUID);
        }
        return compound;
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.patrolTargets.size());
        for (BlockPos pos : this.patrolTargets) {
            buf.m_130064_(pos);
        }
        buf.writeInt(this.getAllAssignedCitizen().size());
        for (ICitizenData citizen : this.getAllAssignedCitizen()) {
            buf.writeInt(citizen.getId());
        }
        if (this.minePos != null) {
            buf.writeBoolean(true);
            buf.m_130064_(this.minePos);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public String getTask() {
        return this.getSetting(GUARD_TASK).getValue();
    }

    @Override
    @Nullable
    public Player getPlayerToFollowOrRally() {
        return this.rallyLocation != null && this.rallyLocation instanceof EntityLocation ? ((EntityLocation)this.rallyLocation).getPlayerEntity() : ServerUtils.getPlayerFromUUID(this.followPlayerUUID, this.colony.getWorld());
    }

    @Override
    public void onColonyTick(IColony colony) {
        super.onColonyTick(colony);
        if (this.patrolTimer > 0 && this.getSetting(GUARD_TASK).getValue().equals("com.minecolonies.core.guard.setting.patrol")) {
            --this.patrolTimer;
            if (this.patrolTimer <= 0 && !this.getAllAssignedCitizen().isEmpty()) {
                this.startPatrolNext();
            }
        }
    }

    @Override
    public boolean requiresManualTarget() {
        return false;
    }

    @Override
    public void arrivedAtPatrolPoint(AbstractEntityCitizen guard) {
        if (this.arrivedAtPatrol.isEmpty()) {
            this.patrolTimer = 1;
        }
        this.arrivedAtPatrol.add(guard);
        if (this.getAllAssignedCitizen().size() <= this.arrivedAtPatrol.size() || this.patrolTimer <= 0) {
            this.startPatrolNext();
        }
    }

    public void setPatrolTimer(int timer) {
        this.patrolTimer = timer;
    }

    private void startPatrolNext() {
        this.getNextPatrolTarget(true);
        this.patrolTimer = 5;
        for (ICitizenData curguard : this.getAllAssignedCitizen()) {
            IJob<?> iJob;
            if (!curguard.getEntity().isPresent() || !((iJob = curguard.getEntity().get().getCitizenJobHandler().getColonyJob()) instanceof AbstractJobGuard)) continue;
            AbstractJobGuard guardEntity = (AbstractJobGuard)iJob;
            ((AbstractEntityAIGuard)guardEntity.getWorkerAI()).setNextPatrolTarget(this.lastPatrolPoint);
        }
        this.arrivedAtPatrol.clear();
    }

    @Override
    @Nullable
    public BlockPos getNextPatrolTarget(boolean newTarget) {
        if (!newTarget && this.lastPatrolPoint != null) {
            return this.lastPatrolPoint;
        }
        if (this.tempNextPatrolPoint != null) {
            this.lastPatrolPoint = this.tempNextPatrolPoint;
            this.tempNextPatrolPoint = null;
            return this.lastPatrolPoint;
        }
        if (this.lastPatrolPoint == null) {
            this.lastPatrolPoint = this.getAllAssignedCitizen().iterator().next().getLastPosition();
            return this.lastPatrolPoint;
        }
        if (!this.getSetting(PATROL_MODE).getValue().equals("com.minecolonies.core.guard.setting.patrol.manual") || this.patrolTargets == null || this.patrolTargets.isEmpty()) {
            BlockPos pos = null;
            if (this.pathResult != null) {
                if (this.pathResult.isDone()) {
                    if (this.pathResult.getPath() != null) {
                        pos = this.pathResult.getPath().m_77406_();
                    }
                    this.pathResult = null;
                }
            } else if (this.colony.getWorld().f_46441_.m_188499_()) {
                PathJobRandomPos job = new PathJobRandomPos(this.colony.getWorld(), this.lastPatrolPoint, 20, 40, null);
                this.pathResult = job.getResult();
                Pathfinding.enqueue(job);
            } else {
                pos = this.colony.getBuildingManager().getRandomBuilding(b -> b.getBuildingLevel() >= 1);
            }
            if (pos != null) {
                if (BlockPosUtil.getDistance2D(pos, this.getPosition()) > (long)this.getPatrolDistance()) {
                    this.lastPatrolPoint = this.getPosition();
                    return this.lastPatrolPoint;
                }
                this.lastPatrolPoint = pos;
            }
            return this.lastPatrolPoint;
        }
        if (this.patrolTargets.contains(this.lastPatrolPoint)) {
            int index = this.patrolTargets.indexOf(this.lastPatrolPoint) + 1;
            if (index >= this.patrolTargets.size()) {
                index = 0;
            }
            this.lastPatrolPoint = this.patrolTargets.get(index);
            return this.lastPatrolPoint;
        }
        this.lastPatrolPoint = this.patrolTargets.get(0);
        return this.lastPatrolPoint;
    }

    @Override
    public int getPatrolDistance() {
        return 50 + this.getBuildingLevel() * 30;
    }

    @Override
    public void setTempNextPatrolPoint(BlockPos pos) {
        this.tempNextPatrolPoint = pos;
    }

    @Override
    public BlockPos getMinePos() {
        return this.minePos;
    }

    public void setMinePos(BlockPos pos) {
        if (pos == null) {
            this.minePos = null;
        } else if (this.colony.getBuildingManager().getBuilding(pos) instanceof BuildingMiner) {
            this.minePos = pos;
        }
    }

    @Override
    public boolean shallRetrieveOnLowHealth() {
        return this.getSetting(RETREAT).getValue();
    }

    @Override
    public boolean shallPatrolManually() {
        return this.getSetting(PATROL_MODE).getValue().equals("com.minecolonies.core.guard.setting.patrol.manual");
    }

    @Override
    public boolean isTightGrouping() {
        return this.getSetting(FOLLOW_MODE).getValue().equals("com.minecolonies.core.guard.setting.follow.tight");
    }

    @Override
    public BlockPos getGuardPos() {
        return this.guardPos;
    }

    @Override
    public void setGuardPos(BlockPos guardPos) {
        this.guardPos = guardPos;
    }

    @Override
    public BlockPos getPositionToFollow() {
        Player followPlayer = ServerUtils.getPlayerFromUUID(this.followPlayerUUID, this.colony.getWorld());
        if (this.getSetting(GUARD_TASK).getValue().equals("com.minecolonies.core.guard.setting.follow") && followPlayer != null && followPlayer.f_19853_.m_46472_() == this.colony.getDimension()) {
            return followPlayer.m_20183_();
        }
        return this.getPosition();
    }

    @Override
    @Nullable
    public ILocation getRallyLocation() {
        if (this.rallyLocation == null) {
            return null;
        }
        boolean outOfRange = false;
        IColony colonyAtPosition = IColonyManager.getInstance().getColonyByPosFromDim(this.rallyLocation.getDimension(), this.rallyLocation.getInDimensionLocation());
        if (!(colonyAtPosition != null && colonyAtPosition.getID() == this.colony.getID() || !(this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.TELESCOPE) <= 0.0) && BlockPosUtil.getDistance2D(this.rallyLocation.getInDimensionLocation(), this.colony.getCenter()) <= 500L)) {
            outOfRange = true;
        }
        if (this.rallyLocation instanceof EntityLocation) {
            Player player = ((EntityLocation)this.rallyLocation).getPlayerEntity();
            if (player == null) {
                this.setRallyLocation(null);
                return null;
            }
            if (outOfRange) {
                MessageUtils.format("item.minecolonies.banner_rally_guards.outofrange", new Object[0]).sendTo(player);
                this.setRallyLocation(null);
                return null;
            }
            int size = player.m_150109_().m_6643_();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (!(stack.m_41720_() instanceof ItemBannerRallyGuards) || !((ItemBannerRallyGuards)stack.m_41720_()).isActiveForGuardTower(stack, this)) continue;
                return this.rallyLocation;
            }
            return null;
        }
        if (this.rallyLocation instanceof StaticLocation && outOfRange) {
            MessageUtils.format("item.minecolonies.banner_rally_guards.outofrange", new Object[0]).sendTo(this.colony.getImportantMessageEntityPlayers());
            this.setRallyLocation(null);
            return null;
        }
        return this.rallyLocation;
    }

    @Override
    public void setRallyLocation(ILocation location) {
        boolean reduceSaturation = false;
        if (this.rallyLocation != null && location == null) {
            reduceSaturation = true;
        }
        this.rallyLocation = location;
        for (ICitizenData iCitizenData : this.getAllAssignedCitizen()) {
            if (!reduceSaturation || !(iCitizenData.getSaturation() < 6.0)) continue;
            iCitizenData.decreaseSaturation(6.0);
        }
    }

    @Override
    public void setPlayerToFollow(Player player) {
        this.followPlayerUUID = player.m_20148_();
        for (ICitizenData iCitizenData : this.getAllAssignedCitizen()) {
            AbstractJobGuard job = iCitizenData.getJob(AbstractJobGuard.class);
            if (job == null || job.getWorkerAI() == null) continue;
            ((AbstractEntityAIGuard)job.getWorkerAI()).registerTarget(new AIOneTimeEventTarget<IAIState>(AIWorkerState.PREPARING));
        }
    }

    public int getBonusHealth() {
        return this.getBuildingLevel() * 2;
    }

    @Override
    public void addPatrolTargets(BlockPos target) {
        this.patrolTargets.add(target);
        this.markDirty();
    }

    @Override
    public void resetPatrolTargets() {
        this.patrolTargets = new ArrayList<BlockPos>();
        this.markDirty();
    }

    @Override
    public int getBonusVision() {
        return 15 + this.getBuildingLevel() * 3;
    }

    @Override
    public void calculateMobs() {
    }

    public static class View
    extends AbstractBuildingView {
        private List<BlockPos> patrolTargets = new ArrayList<BlockPos>();
        @NotNull
        private final List<Integer> guards = new ArrayList<Integer>();
        private BlockPos minePos;

        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @NotNull
        public List<Integer> getGuards() {
            return Collections.unmodifiableList(this.guards);
        }

        @Override
        public void deserialize(@NotNull FriendlyByteBuf buf) {
            super.deserialize(buf);
            int targetSize = buf.readInt();
            this.patrolTargets = new ArrayList<BlockPos>();
            for (int i = 0; i < targetSize; ++i) {
                this.patrolTargets.add(buf.m_130135_());
            }
            this.guards.clear();
            int numResidents = buf.readInt();
            for (int i = 0; i < numResidents; ++i) {
                this.guards.add(buf.readInt());
            }
            this.minePos = buf.readBoolean() ? buf.m_130135_() : null;
        }

        public List<BlockPos> getPatrolTargets() {
            return new ArrayList<BlockPos>(this.patrolTargets);
        }

        public BlockPos getMinePos() {
            return this.minePos;
        }

        public void setMinePos(BlockPos pos) {
            this.minePos = pos;
        }
    }
}

