/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IAltersRequiredItems;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.buildings.modules.IHasRequiredItemsModule;
import com.minecolonies.api.colony.buildings.modules.IMinimumStockModule;
import com.minecolonies.api.colony.buildings.modules.IModuleWithExternalBlocks;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.modules.ModuleContainerUtils;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Pickup;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingContainer;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.interactionhandling.RequestBasedInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.requesters.BuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.requests.StandardRequests;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuilding;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import com.minecolonies.coremod.util.ChunkDataHelper;
import com.minecolonies.coremod.util.ColonyUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuilding
extends AbstractBuildingContainer {
    public static final ISettingKey<BoolSetting> BREEDING = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "breeding"));
    public static final ISettingKey<BoolSetting> FEEDING = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "feeding"));
    public static final ISettingKey<BoolSetting> USE_SHEARS = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "useshears"));
    private IToken<?> rsDataStoreToken;
    private IRequester requester;
    private boolean isBuilt = false;
    private String customName = "";
    private boolean guardBuildingNear = false;
    private boolean recheckGuardBuildingNear = true;
    private boolean dirty = false;
    protected List<IBuildingModule> modules = new ArrayList<IBuildingModule>();
    protected Int2ObjectOpenHashMap<IBuildingModule> modulesMap = new Int2ObjectOpenHashMap();

    protected AbstractBuilding(@NotNull IColony colony, BlockPos pos) {
        super(pos, colony);
        this.requester = (IRequester)StandardFactoryController.getInstance().getNewInstance(TypeToken.of(BuildingBasedRequester.class), this, new Object[0]);
        this.setupRsDataStore();
    }

    @Override
    public boolean hasModule(Class<? extends IBuildingModule> clazz) {
        return ModuleContainerUtils.hasModule(this.modules, clazz);
    }

    @Override
    public boolean hasModule(BuildingEntry.ModuleProducer producer) {
        return this.modulesMap.containsKey(producer.getRuntimeID());
    }

    @Override
    @NotNull
    public <T extends IBuildingModule> T getFirstModuleOccurance(Class<T> clazz) {
        return (T)((IBuildingModule)ModuleContainerUtils.getFirstModuleOccurance(this.modules, clazz, "The module of class: " + clazz.toString() + "should never be null! Building: " + this.getBuildingType().getTranslationKey() + " pos:" + this.getID().m_123344_()));
    }

    @Override
    @NotNull
    public <T extends IBuildingModule> T getModuleMatching(Class<T> clazz, Predicate<? super T> modulePredicate) {
        return (T)((IBuildingModule)ModuleContainerUtils.getModuleMatching(this.modules, clazz, modulePredicate, "no matching module for Building: " + this.getBuildingType().getTranslationKey() + " pos:" + this.getID().m_123344_()));
    }

    @Override
    public <M extends IBuildingModule, V extends IBuildingModuleView> M getModule(BuildingEntry.ModuleProducer<M, V> producer) {
        return (M)((IBuildingModule)this.modulesMap.get(producer.getRuntimeID()));
    }

    @Override
    public IBuildingModule getModule(int id) {
        return (IBuildingModule)this.modulesMap.get(id);
    }

    @Override
    @NotNull
    public <T extends IBuildingModule> List<T> getModulesByType(Class<T> clazz) {
        return ModuleContainerUtils.getModules(this.modules, clazz);
    }

    @Override
    public void registerModule(@NotNull IBuildingModule module) {
        if (this.modulesMap.containsKey(module.getProducer().getRuntimeID())) {
            Log.getLogger().error("Trying to register same module twice!" + module.getProducer().key, (Throwable)new RuntimeException());
            return;
        }
        this.modulesMap.put(module.getProducer().getRuntimeID(), (Object)module);
        this.modules.add(module);
    }

    @Override
    @NotNull
    public String getCustomName() {
        return this.customName;
    }

    @Override
    @NotNull
    public String getBuildingDisplayName() {
        if (this.customName.isEmpty()) {
            return this.getBuildingType().getTranslationKey();
        }
        return this.customName;
    }

    @Override
    public void onWakeUp() {
        this.getModulesByType((Class<T>)IBuildingEventsModule.class).forEach(IBuildingEventsModule::onWakeUp);
    }

    @Override
    public void onCleanUp(ICitizenData citizen) {
    }

    @Override
    public void onRestart(ICitizenData citizen) {
        citizen.setPaused(false);
    }

    @Override
    public void onPlayerEnterBuilding(Player player) {
        this.getModulesByType((Class<T>)IBuildingEventsModule.class).forEach(module -> module.onPlayerEnterBuilding(player));
    }

    @Override
    public void onPlayerEnterNearby(Player player) {
        if (this.getBuildingLevel() == 0 || this.getSchematicName() == null || this.getSchematicName().isEmpty()) {
            return;
        }
        if (this.isInBuilding(player.m_20183_())) {
            this.onPlayerEnterBuilding(player);
        }
    }

    @Override
    public void onPlacement() {
        if (this.getBuildingLevel() == 0) {
            ChunkDataHelper.claimBuildingChunks(this.colony, true, this.getPosition(), this.getClaimRadius(this.getBuildingLevel()), this.getCorners());
        }
    }

    @Override
    public boolean isMatchingBlock(@NotNull Block block) {
        return this.getBuildingType().getBuildingBlock() == block;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.loadRequestSystemFromNBT(compound);
        if (compound.m_128441_("isBuilt")) {
            this.isBuilt = compound.m_128471_("isBuilt");
        } else if (this.getBuildingLevel() > 0) {
            this.isBuilt = true;
        }
        if (compound.m_128441_("customName")) {
            this.customName = compound.m_128461_("customName");
        }
        if (compound.m_128441_("building_modules")) {
            for (IPersistentModule module2 : this.getModulesByType((Class<T>)IPersistentModule.class)) {
                if (compound.m_128469_("building_modules").m_128441_(module2.getProducer().key)) {
                    module2.deserializeNBT(compound.m_128469_("building_modules").m_128469_(module2.getProducer().key));
                    continue;
                }
                module2.deserializeNBT(compound);
            }
        } else {
            this.getModulesByType((Class<T>)IPersistentModule.class).forEach(module -> module.deserializeNBT(compound));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        ListTag list = new ListTag();
        for (IRequestResolver requestResolver : this.getResolvers()) {
            list.add((Object)StandardFactoryController.getInstance().serialize(requestResolver.getId()));
        }
        compound.m_128365_("Resolver", (Tag)list);
        compound.m_128359_("type", this.getBuildingType().getRegistryName().toString());
        this.writeRequestSystemToNBT(compound);
        compound.m_128379_("isBuilt", this.isBuilt);
        compound.m_128359_("customName", this.customName);
        CompoundTag modules = new CompoundTag();
        for (IPersistentModule module : this.getModulesByType((Class<T>)IPersistentModule.class)) {
            CompoundTag tag = new CompoundTag();
            module.serializeNBT(tag);
            modules.m_128365_(module.getProducer().key, (Tag)tag);
        }
        compound.m_128365_("building_modules", (Tag)modules);
        return compound;
    }

    @Override
    public final void destroy() {
        this.onDestroyed();
        this.colony.getBuildingManager().removeBuilding(this, this.colony.getPackageManager().getCloseSubscribers());
        this.colony.getRequestManager().getDataStoreManager().remove(this.rsDataStoreToken);
        for (BlockPos childpos : this.getChildren()) {
            IBuilding building = this.colony.getBuildingManager().getBuilding(childpos);
            if (building == null) continue;
            building.destroy();
        }
    }

    @Override
    public void onDestroyed() {
        AbstractTileEntityColonyBuilding tileEntityNew = this.getTileEntity();
        Level world = this.colony.getWorld();
        Block block = world.m_8055_(this.getPosition()).m_60734_();
        if (tileEntityNew != null) {
            InventoryUtils.dropItemHandler((IItemHandler)tileEntityNew.getInventory(), world, tileEntityNew.getPosition().m_123341_(), tileEntityNew.getPosition().m_123342_(), tileEntityNew.getPosition().m_123343_());
            world.m_46717_(this.getPosition(), block);
        }
        ChunkDataHelper.claimBuildingChunks(this.colony, false, this.getID(), this.getClaimRadius(this.getBuildingLevel()), this.getCorners());
        ConstructionTapeHelper.removeConstructionTape(this.getCorners(), world);
        this.getModulesByType((Class<T>)IBuildingEventsModule.class).forEach(IBuildingEventsModule::onDestroyed);
    }

    protected void requestWorkOrder(WorkOrderType type, BlockPos builder) {
        for (WorkOrderBuilding o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuilding.class)) {
            if (!o.getLocation().equals((Object)this.getID())) continue;
            return;
        }
        WorkOrderBuilding workOrder = WorkOrderBuilding.create(type, this);
        if (type == WorkOrderType.REMOVE && !this.canDeconstruct()) {
            MessageUtils.format("entity.builder.cantdeconstruct", new Object[0]).sendTo(this.colony).forAllPlayers();
            return;
        }
        if (type != WorkOrderType.REMOVE && !this.canBeBuiltByBuilder(workOrder.getTargetLevel()) && !workOrder.canBeResolved(this.colony, workOrder.getTargetLevel())) {
            MessageUtils.format("entity.builder.messagebuildernecessary", Integer.toString(workOrder.getTargetLevel())).sendTo(this.colony).forAllPlayers();
            return;
        }
        if (workOrder.tooFarFromAnyBuilder(this.colony, workOrder.getTargetLevel()) && builder.equals((Object)BlockPos.f_121853_)) {
            MessageUtils.format("entity.builder.messagebuilderstoofar", new Object[0]).sendTo(this.colony).forAllPlayers();
            return;
        }
        int max = this.colony.getWorld().m_151558_();
        if (((BlockPos)this.getCorners().m_14418_()).m_123342_() >= max || ((BlockPos)this.getCorners().m_14419_()).m_123342_() >= max) {
            MessageUtils.format("entity.builder.messagebuildtoohigh", new Object[0]).sendTo(this.colony).forAllPlayers();
            return;
        }
        if (this.getPosition().m_123342_() <= this.colony.getWorld().m_141937_()) {
            MessageUtils.format("entity.builder.messagebuildtoolow", new Object[0]).sendTo(this.colony).forAllPlayers();
            return;
        }
        if (!builder.equals((Object)BlockPos.f_121853_)) {
            IBuilding building = this.colony.getBuildingManager().getBuilding(builder);
            if (building instanceof AbstractBuildingStructureBuilder && (building.getBuildingLevel() >= workOrder.getTargetLevel() || this.canBeBuiltByBuilder(workOrder.getTargetLevel()))) {
                workOrder.setClaimedBy(builder);
            } else {
                MessageUtils.format("entity.builder.messagebuildernecessary", Integer.toString(workOrder.getTargetLevel())).sendTo(this.colony).forAllPlayers();
                return;
            }
        }
        this.colony.getWorkManager().addWorkOrder(workOrder, false);
        this.colony.getProgressManager().progressWorkOrderPlacement(workOrder);
        if (workOrder.getID() != 0) {
            MessageUtils.format("com.minecolonies.coremod.workorderadded", workOrder.getDisplayName(), this.colony.getName(), workOrder.getLocation().m_123341_(), workOrder.getLocation().m_123342_(), workOrder.getLocation().m_123343_()).sendTo(this.colony).forAllPlayers();
        }
        this.markDirty();
    }

    public boolean canDeconstruct() {
        return true;
    }

    @Override
    public boolean canBeBuiltByBuilder(int newLevel) {
        return false;
    }

    @Override
    public final void markDirty() {
        this.dirty = true;
        if (this.colony != null) {
            this.colony.getBuildingManager().markBuildingsDirty();
        }
    }

    @Override
    public final boolean isDirty() {
        for (IBuildingModule module : this.modules) {
            if (!module.checkDirty()) continue;
            return true;
        }
        return this.dirty;
    }

    @Override
    public final void clearDirty() {
        this.dirty = false;
        for (IBuildingModule module : this.modules) {
            module.clearDirty();
        }
    }

    @Override
    public void processOfflineTime(long time) {
    }

    @Override
    public boolean hasWorkOrder() {
        return this.getCurrentWorkOrderLevel() != -1;
    }

    private int getCurrentWorkOrderLevel() {
        return this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuilding.class).stream().filter(f -> f.getLocation().equals((Object)this.getID())).map(IWorkOrder::getTargetLevel).findFirst().orElse(-1);
    }

    @Override
    public void removeWorkOrder() {
        for (WorkOrderBuilding o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuilding.class)) {
            if (!o.getLocation().equals((Object)this.getID())) continue;
            this.colony.getWorkManager().removeWorkOrder(o.getID());
            this.markDirty();
            BlockPos buildingPos = o.getClaimedBy();
            IBuilding building = this.colony.getBuildingManager().getBuilding(buildingPos);
            if (building != null) {
                for (AbstractAssignedCitizenModule module : building.getModulesByType(AbstractAssignedCitizenModule.class)) {
                    for (ICitizenData citizen : module.getAssignedCitizen()) {
                        building.cancelAllRequestsOfCitizen(citizen);
                    }
                }
            }
            return;
        }
    }

    @Override
    public Set<ICitizenData> getAllAssignedCitizen() {
        HashSet<ICitizenData> citizens = new HashSet<ICitizenData>();
        for (AbstractAssignedCitizenModule module : this.getModulesByType((Class<T>)AbstractAssignedCitizenModule.class)) {
            citizens.addAll(module.getAssignedCitizen());
        }
        return citizens;
    }

    @Override
    public int getClaimRadius(int newLevel) {
        switch (newLevel) {
            case 1: 
            case 2: 
            case 3: {
                return 1;
            }
            case 4: 
            case 5: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        buf.m_130070_(this.getBuildingType().getRegistryName().toString());
        buf.writeInt(this.getBuildingLevel());
        buf.writeInt(this.getMaxBuildingLevel());
        buf.writeInt(this.getPickUpPriority());
        buf.writeInt(this.getCurrentWorkOrderLevel());
        buf.m_130070_(this.getStructurePack());
        buf.m_130070_(this.getBlueprintPath());
        buf.m_130064_(this.getParent());
        buf.m_130070_(this.customName);
        buf.writeInt(this.getRotation());
        buf.writeBoolean(this.isMirrored());
        buf.writeInt(this.getClaimRadius(this.getBuildingLevel()));
        CompoundTag requestSystemCompound = new CompoundTag();
        this.writeRequestSystemToNBT(requestSystemCompound);
        ImmutableCollection<IRequestResolver<?>> resolvers = this.getResolvers();
        buf.writeInt(resolvers.size());
        for (IRequestResolver resolver : resolvers) {
            buf.m_130079_(StandardFactoryController.getInstance().serialize(resolver.getId()));
        }
        buf.m_130079_(StandardFactoryController.getInstance().serialize(this.getId()));
        buf.writeInt(this.containerList.size());
        for (BlockPos blockPos : this.containerList) {
            buf.m_130064_(blockPos);
        }
        buf.m_130079_(requestSystemCompound);
        buf.writeBoolean(this.isDeconstructed());
        ArrayList<IBuildingModule> syncedModules = new ArrayList<IBuildingModule>();
        for (IBuildingModule module : this.modules) {
            if (!module.getProducer().hasView()) continue;
            syncedModules.add(module);
        }
        buf.writeInt(syncedModules.size());
        for (IBuildingModule module : syncedModules) {
            buf.writeInt(module.getProducer().getRuntimeID());
            module.serializeToView(buf);
        }
    }

    @Override
    public void onColonyTick(IColony colony) {
        this.getModulesByType((Class<T>)ITickingModule.class).forEach(module -> module.onColonyTick(colony));
    }

    public boolean isMinimumStockRequest(IRequest<? extends IDeliverable> request) {
        for (IMinimumStockModule module : this.getModulesByType((Class<T>)IMinimumStockModule.class)) {
            if (!module.isMinimumStockRequest(request)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setCustomBuildingName(String name) {
        this.customName = name;
        this.markDirty();
        this.colony.getWorkManager().getWorkOrders().values().stream().filter(f -> f instanceof WorkOrderBuilding).map(m -> (WorkOrderBuilding)m).filter(f -> f.getLocation().equals((Object)this.getID()) || this.getChildren().contains(f.getLocation())).forEach(f -> {
            IBuilding building = this.colony.getBuildingManager().getBuilding(f.getLocation());
            if (building != null) {
                f.setCustomName(building);
                this.colony.getWorkManager().setDirty(true);
            }
        });
    }

    @Override
    public boolean canBeGathered() {
        return true;
    }

    @Override
    public void requestUpgrade(Player player, BlockPos builder) {
        ResourceLocation hutResearch = this.colony.getResearchManager().getResearchEffectIdFrom(this.getBuildingType().getBuildingBlock());
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearchEffect(hutResearch) && this.colony.getResearchManager().getResearchEffects().getEffectStrength(hutResearch) < 1.0) {
            MessageUtils.format("com.minecolonies.coremod.research.havetounlock", new Object[0]).sendTo(player);
            return;
        }
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearchEffect(hutResearch) && this.colony.getResearchManager().getResearchEffects().getEffectStrength(hutResearch) <= (double)this.getBuildingLevel()) {
            MessageUtils.format("com.minecolonies.coremod.research.unlocktoupgrade", new Object[0]).sendTo(player);
            return;
        }
        IBuilding parentBuilding = this.colony.getBuildingManager().getBuilding(this.getParent());
        if (this.getBuildingLevel() == 0 && (parentBuilding == null || parentBuilding.getBuildingLevel() > 0)) {
            this.requestWorkOrder(WorkOrderType.BUILD, builder);
        } else if (this.getBuildingLevel() < this.getMaxBuildingLevel() && (parentBuilding == null || this.getBuildingLevel() < parentBuilding.getBuildingLevel() || parentBuilding.getBuildingLevel() >= parentBuilding.getMaxBuildingLevel())) {
            this.requestWorkOrder(WorkOrderType.UPGRADE, builder);
        } else {
            MessageUtils.format("com.minecolonies.coremod.worker.noupgrade", new Object[0]).sendTo(player);
        }
    }

    @Override
    public void requestRemoval(Player player, BlockPos builder) {
        if (this.isDeconstructed()) {
            this.pickUp(player);
        } else {
            this.requestWorkOrder(WorkOrderType.REMOVE, builder);
        }
    }

    @Override
    public void pickUp(Player player) {
        if (this.hasParent()) {
            MessageUtils.format("com.minecolonies.coremod.gui.workerhuts.pickup.denied", new Object[0]).sendTo(player);
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)this.colony.getWorld().m_8055_(this.getPosition()).m_60734_(), 1);
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128405_("colony", this.getColony().getID());
        compoundNBT.m_128405_("otherLevel", this.getBuildingLevel());
        stack.m_41751_(compoundNBT);
        if (InventoryUtils.addItemStackToProvider((ICapabilityProvider)player, stack)) {
            this.destroy();
            this.colony.getWorld().m_46961_(this.getPosition(), false);
        } else {
            MessageUtils.format("com.minecolonies.coremod.playerinvfull", new Object[0]).sendTo(player);
        }
    }

    @Override
    public void requestRepair(BlockPos builder) {
        if (this.getBuildingLevel() > 0) {
            this.requestWorkOrder(WorkOrderType.REPAIR, builder);
        }
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public void deconstruct() {
        Tuple<BlockPos, BlockPos> tuple = this.getCorners();
        for (int x = ((BlockPos)tuple.m_14418_()).m_123341_(); x < ((BlockPos)tuple.m_14419_()).m_123341_(); ++x) {
            for (int z = ((BlockPos)tuple.m_14418_()).m_123343_(); z < ((BlockPos)tuple.m_14419_()).m_123343_(); ++z) {
                for (int y = ((BlockPos)tuple.m_14418_()).m_123342_(); y < ((BlockPos)tuple.m_14419_()).m_123342_(); ++y) {
                    this.colony.getWorld().m_46961_(new BlockPos(x, y, z), false);
                }
            }
        }
    }

    @Override
    public AbstractTileEntityColonyBuilding getTileEntity() {
        if (this.tileEntity != null && this.tileEntity.m_58901_()) {
            this.tileEntity = null;
        }
        if (this.tileEntity == null && this.colony != null && this.colony.getWorld() != null && this.getPosition() != null && WorldUtil.isBlockLoaded((LevelAccessor)this.colony.getWorld(), this.getPosition()) && !(this.colony.getWorld().m_8055_(this.getPosition()).m_60734_() instanceof AirBlock) && this.colony.getWorld().m_8055_(this.getPosition()).m_60734_() instanceof AbstractBlockHut) {
            BlockEntity te = this.colony.getWorld().m_7702_(this.getPosition());
            if (te instanceof TileEntityColonyBuilding) {
                this.tileEntity = (TileEntityColonyBuilding)te;
                if (this.tileEntity.getBuilding() == null) {
                    this.tileEntity.setColony(this.colony);
                    this.tileEntity.setBuilding(this);
                }
            } else {
                Log.getLogger().error("Somehow the wrong TileEntity is at the location where the building should be!", (Throwable)new Exception());
                Log.getLogger().error("Trying to restore order!");
                TileEntityColonyBuilding tileEntityColonyBuilding = new TileEntityColonyBuilding((BlockEntityType<? extends AbstractTileEntityColonyBuilding>)((BlockEntityType)MinecoloniesTileEntities.BUILDING.get()), this.getPosition(), this.colony.getWorld().m_8055_(this.getPosition()));
                this.colony.getWorld().m_151523_((BlockEntity)tileEntityColonyBuilding);
                this.tileEntity = tileEntityColonyBuilding;
            }
        }
        return this.tileEntity;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        this.cachedRotation = -1;
        ChunkDataHelper.claimBuildingChunks(this.colony, true, this.getID(), this.getClaimRadius(newLevel), this.getCorners());
        this.recheckGuardBuildingNear = true;
        ConstructionTapeHelper.removeConstructionTape(this.getCorners(), this.colony.getWorld());
        this.colony.getProgressManager().progressBuildBuilding(this);
        this.calculateCorners();
        this.isBuilt = true;
        ImmutableList<IToken<?>> playerRequests = this.colony.getRequestManager().getPlayerResolver().getAllAssignedRequests();
        ImmutableList<IToken<?>> retryingRequests = this.colony.getRequestManager().getRetryingRequestResolver().getAllAssignedRequests();
        for (Collection<IToken<?>> requestList : new ArrayList(this.getOpenRequestsByCitizen().values())) {
            for (IToken<?> requestToken : new ArrayList(requestList)) {
                IRequest<?> request = this.colony.getRequestManager().getRequestForToken(requestToken);
                if (!(request instanceof StandardRequests.ToolRequest) || !this.isRequestStuck(request, (List<IToken<?>>)playerRequests, (List<IToken<?>>)retryingRequests)) continue;
                this.colony.getRequestManager().updateRequestState(requestToken, RequestState.CANCELLED);
            }
        }
        this.getModulesByType((Class<T>)IBuildingEventsModule.class).forEach(module -> module.onUpgradeComplete(newLevel));
        this.colony.getResearchManager().checkAutoStartResearch();
        this.colony.getBuildingManager().onBuildingUpgradeComplete(this, newLevel);
    }

    @Override
    public void calculateCorners() {
        AbstractTileEntityColonyBuilding te = this.getTileEntity();
        if (te != null && !te.getSchematicName().isEmpty()) {
            this.setCorners((BlockPos)te.getInWorldCorners().m_14418_(), (BlockPos)te.getInWorldCorners().m_14419_());
            return;
        }
        try {
            Blueprint blueprint = StructurePacks.getBlueprint((String)this.getStructurePack(), (String)this.getBlueprintPath());
            if (blueprint == null) {
                this.setCorners(this.getPosition(), this.getPosition());
                return;
            }
            Tuple<BlockPos, BlockPos> corners = ColonyUtils.calculateCorners(this.getPosition(), this.colony.getWorld(), blueprint, this.getRotation(), this.isMirrored());
            this.setCorners((BlockPos)corners.m_14418_(), (BlockPos)corners.m_14419_());
            if (te != null) {
                this.getTileEntity().setSchematicCorners(((BlockPos)corners.m_14418_()).m_121996_((Vec3i)this.getPosition()), ((BlockPos)corners.m_14419_()).m_121996_((Vec3i)this.getPosition()));
            }
        }
        catch (Exception ex) {
            this.setCorners(this.getPosition(), this.getPosition());
        }
    }

    @Override
    public boolean isGuardBuildingNear() {
        if (this.recheckGuardBuildingNear) {
            this.guardBuildingNear = this.colony.getBuildingManager().hasGuardBuildingNear(this);
            this.recheckGuardBuildingNear = false;
        }
        return this.guardBuildingNear;
    }

    @Override
    public void resetGuardBuildingNear() {
        this.recheckGuardBuildingNear = true;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory, JobEntry jobEntry) {
        for (Map.Entry<Predicate<ItemStack>, Tuple<Integer, Boolean>> entry : this.getRequiredItemsAndAmount().entrySet()) {
            if (inventory && !((Boolean)entry.getValue().m_14419_()).booleanValue() || !entry.getKey().test(stack)) continue;
            ItemStorage kept = ItemStorage.getItemStackOfListMatchingPredicate(localAlreadyKept, entry.getKey());
            int toKeep = (Integer)entry.getValue().m_14418_();
            int rest = stack.m_41613_() - toKeep;
            if (kept != null) {
                if (kept.getAmount() >= toKeep && !ItemStackUtils.isBetterTool(stack, kept.getItemStack())) {
                    return stack.m_41613_();
                }
                rest = kept.getAmount() + stack.m_41613_() - toKeep;
                localAlreadyKept.remove(kept);
                kept.setAmount(kept.getAmount() + ItemStackUtils.getSize(stack) - Math.max(0, rest));
                localAlreadyKept.add(kept);
            } else {
                ItemStorage newStorage = new ItemStorage(stack);
                newStorage.setAmount(ItemStackUtils.getSize(stack) - Math.max(0, rest));
                localAlreadyKept.add(newStorage);
            }
            if (rest <= 0) {
                return 0;
            }
            return Math.min(rest, ItemStackUtils.getSize(stack));
        }
        return stack.m_41613_();
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(this.keepX);
        HashMap<ItemStorage, Tuple> requiredItems = new HashMap<ItemStorage, Tuple>();
        ImmutableCollection<IRequestResolver<?>> resolvers = this.getResolvers();
        for (IRequestResolver resolver : resolvers) {
            IStandardRequestManager requestManager = (IStandardRequestManager)this.colony.getRequestManager();
            List deliverableRequests = requestManager.getRequestHandler().getRequestsMadeByRequester(resolver).stream().filter(iRequest -> iRequest.getRequest() instanceof IDeliverable).map(iRequest -> iRequest).collect(Collectors.toList());
            for (IRequest request : deliverableRequests) {
                for (ItemStack item : request.getDeliveries()) {
                    ItemStorage output = new ItemStorage(item);
                    int amount = output.getAmount();
                    if (requiredItems.containsKey(output)) {
                        amount += ((Integer)((Tuple)requiredItems.get(output)).m_14418_()).intValue();
                    }
                    requiredItems.put(output, new Tuple((Object)amount, (Object)false));
                }
            }
        }
        toKeep.putAll(requiredItems.entrySet().stream().collect(Collectors.toMap(key -> stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, ((ItemStorage)key.getKey()).getItemStack()), Map.Entry::getValue)));
        if (this.keepFood()) {
            toKeep.put(stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat((ItemStack)stack), new Tuple((Object)(this.getBuildingLevel() * 2), (Object)true));
        }
        for (IHasRequiredItemsModule module2 : this.getModulesByType((Class<T>)IHasRequiredItemsModule.class)) {
            toKeep.putAll(module2.getRequiredItemsAndAmount());
        }
        this.getModulesByType((Class<T>)IAltersRequiredItems.class).forEach(module -> module.alterItemsToBeKept((TriConsumer<Predicate<ItemStack>, Integer, Boolean>)((TriConsumer)(stack, qty, inv) -> toKeep.put((Predicate<ItemStack>)stack, (Tuple<Integer, Boolean>)new Tuple(qty, inv)))));
        return toKeep;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        return stack.m_41720_().getFoodProperties(stack, null).m_38744_() >= this.getBuildingLevel();
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public List<IItemHandler> getHandlers() {
        if (this.getAllAssignedCitizen().isEmpty() || this.colony == null || this.colony.getWorld() == null) {
            return Collections.emptyList();
        }
        HashSet<InventoryCitizen> handlers = new HashSet<InventoryCitizen>();
        for (ICitizenData workerEntity : this.getAllAssignedCitizen()) {
            handlers.add(workerEntity.getInventory());
        }
        BlockEntity entity = this.colony.getWorld().m_7702_(this.getID());
        if (entity != null) {
            LazyOptional handler = entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
            handler.ifPresent(handlers::add);
        }
        return ImmutableList.copyOf(handlers);
    }

    @Override
    public <T extends ISetting<S>, S> T getSetting(@NotNull ISettingKey<T> key) {
        return ((ISettingsModule)this.getFirstModuleOccurance(ISettingsModule.class)).getSetting(key);
    }

    @Override
    public <T extends ISetting<S>, S> S getSettingValueOrDefault(@NotNull ISettingKey<T> key, @NotNull S def) {
        return ((ISettingsModule)this.getFirstModuleOccurance(ISettingsModule.class)).getSettingValueOrDefault(key, def);
    }

    public ICraftingBuildingModule getCraftingModuleForRecipe(IToken<?> token) {
        for (ICraftingBuildingModule module : this.getModulesByType((Class<T>)ICraftingBuildingModule.class)) {
            if (!module.holdsRecipe(token)) continue;
            return module;
        }
        return null;
    }

    protected boolean keepFood() {
        return true;
    }

    @Override
    @Nullable
    public ItemStack forceTransferStack(ItemStack stack, Level world) {
        if (this.getTileEntity() == null) {
            for (BlockPos pos : this.containerList) {
                BlockEntity tempTileEntity = world.m_7702_(pos);
                if (!(tempTileEntity instanceof ChestBlockEntity) || InventoryUtils.isProviderFull((ICapabilityProvider)tempTileEntity)) continue;
                return this.forceItemStackToProvider((ICapabilityProvider)tempTileEntity, stack);
            }
        } else {
            return this.forceItemStackToProvider((ICapabilityProvider)this.getTileEntity(), stack);
        }
        return stack;
    }

    @Nullable
    private ItemStack forceItemStackToProvider(@NotNull ICapabilityProvider provider, @NotNull ItemStack itemStack) {
        ArrayList localAlreadyKept = new ArrayList();
        return InventoryUtils.forceItemStackToProvider(provider, itemStack, stack -> EntityAIWorkDeliveryman.workerRequiresItem(this, stack, localAlreadyKept) != stack.m_41613_());
    }

    @Override
    public boolean isItemStackInRequest(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return false;
        }
        for (AbstractAssignedCitizenModule module : this.getModulesByType((Class<T>)AbstractAssignedCitizenModule.class)) {
            for (ICitizenData citizen : module.getAssignedCitizen()) {
                for (IRequest<?> request : this.getOpenRequests(citizen.getId())) {
                    for (ItemStack deliveryStack : request.getDeliveries()) {
                        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(deliveryStack, stack, false, true)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected void writeRequestSystemToNBT(CompoundTag compound) {
        compound.m_128365_("Requestor", (Tag)StandardFactoryController.getInstance().serialize(this.requester));
        compound.m_128365_("DataStoreToken", (Tag)StandardFactoryController.getInstance().serialize(this.rsDataStoreToken));
    }

    protected void setupRsDataStore() {
        this.rsDataStoreToken = this.colony.getRequestManager().getDataStoreManager().get(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE).getId();
    }

    private void loadRequestSystemFromNBT(CompoundTag compound) {
        this.requester = compound.m_128441_("Requestor") ? (IRequester)StandardFactoryController.getInstance().deserialize(compound.m_128469_("Requestor")) : (IRequester)StandardFactoryController.getInstance().getNewInstance(TypeToken.of(BuildingBasedRequester.class), this, new Object[0]);
        if (compound.m_128441_("DataStoreToken")) {
            this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.m_128469_("DataStoreToken"));
        } else {
            this.setupRsDataStore();
        }
    }

    private IRequestSystemBuildingDataStore getDataStore() {
        return this.colony.getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE);
    }

    @Override
    public Map<TypeToken<?>, Collection<IToken<?>>> getOpenRequestsByRequestableType() {
        return this.getDataStore().getOpenRequestsByRequestableType();
    }

    protected Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.getDataStore().getOpenRequestsByCitizen();
    }

    private Map<Integer, Collection<IToken<?>>> getCompletedRequestsByCitizen() {
        return this.getDataStore().getCompletedRequestsByCitizen();
    }

    private Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.getDataStore().getCitizensByRequest();
    }

    @Override
    public <R extends IRequestable> IToken<?> createRequest(@NotNull ICitizenData citizenData, @NotNull R requested, boolean async) {
        IToken<?> requestToken = this.colony.getRequestManager().createRequest(this.requester, requested);
        IRequest<?> request = this.colony.getRequestManager().getRequestForToken(requestToken);
        if (async) {
            citizenData.getJob().getAsyncRequests().add(requestToken);
            citizenData.triggerInteraction(new RequestBasedInteraction((Component)Component.m_237110_((String)"com.minecolonies.requestsystem.playerresolver.async", (Object[])new Object[]{request.getLongDisplayString()}), ChatPriority.PENDING, (Component)Component.m_237115_((String)"com.minecolonies.requestsystem.playerresolver.async"), (IToken<?>)request.getId()));
        } else {
            citizenData.triggerInteraction(new RequestBasedInteraction((Component)Component.m_237110_((String)"com.minecolonies.requestsystem.playerresolver.normal", (Object[])new Object[]{request.getLongDisplayString()}), ChatPriority.BLOCKING, (Component)Component.m_237115_((String)"com.minecolonies.requestsystem.playerresolver.normal"), (IToken<?>)request.getId()));
        }
        this.addRequestToMaps(citizenData.getId(), requestToken, TypeToken.of(requested.getClass()));
        this.colony.getRequestManager().assignRequest(requestToken);
        this.markDirty();
        return requestToken;
    }

    @Override
    public <R extends IRequestable> IToken<?> createRequest(@NotNull R requested, boolean async) {
        IToken<?> requestToken = this.colony.getRequestManager().createRequest(this.requester, requested);
        this.addRequestToMaps(-1, requestToken, TypeToken.of(requested.getClass()));
        this.colony.getRequestManager().assignRequest(requestToken);
        this.markDirty();
        return requestToken;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(blockState, pos, world);
        this.getModulesByType((Class<T>)IModuleWithExternalBlocks.class).forEach(module -> module.onBlockPlacedInBuilding(blockState, pos, world));
    }

    private void addRequestToMaps(int citizenId, @NotNull IToken<?> requestToken, @NotNull TypeToken<?> requested) {
        if (!this.getOpenRequestsByRequestableType().containsKey(requested)) {
            this.getOpenRequestsByRequestableType().put(requested, new ArrayList());
        }
        this.getOpenRequestsByRequestableType().get(requested).add(requestToken);
        this.getCitizensByRequest().put(requestToken, citizenId);
        if (!this.getOpenRequestsByCitizen().containsKey(citizenId)) {
            this.getOpenRequestsByCitizen().put(citizenId, new ArrayList());
        }
        this.getOpenRequestsByCitizen().get(citizenId).add(requestToken);
    }

    @Override
    public boolean hasWorkerOpenRequests(int citizenId) {
        return this.getOpenRequestsByCitizen().containsKey(citizenId) && !this.getOpenRequestsByCitizen().get(citizenId).isEmpty();
    }

    @Override
    public Collection<IRequest<?>> getOpenRequests(int citizenId) {
        if (!this.getOpenRequestsByCitizen().containsKey(citizenId)) {
            return ImmutableList.of();
        }
        Collection<IToken<?>> tokens = this.getOpenRequestsByCitizen().get(citizenId);
        ArrayList requests = new ArrayList(tokens.size());
        for (IToken<?> token : tokens) {
            IRequest<?> request = this.colony.getRequestManager().getRequestForToken(token);
            if (request == null) continue;
            requests.add(request);
        }
        return Collections.unmodifiableList(requests);
    }

    @Override
    public boolean hasWorkerOpenRequestsFiltered(int citizenId, @NotNull Predicate<IRequest<?>> selectionPredicate) {
        return this.getOpenRequests(citizenId).stream().anyMatch(selectionPredicate);
    }

    @Override
    public boolean hasOpenSyncRequest(@NotNull ICitizenData citizen) {
        if (!this.hasWorkerOpenRequests(citizen.getId())) {
            return false;
        }
        for (IToken<?> token : this.getOpenRequestsByCitizen().get(citizen.getId())) {
            if (citizen.isRequestAsync(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <R> boolean hasWorkerOpenRequestsOfType(int citizenId, TypeToken<R> requestType) {
        return !this.getOpenRequestsOfType(citizenId, requestType).isEmpty();
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(int citizenId, TypeToken<R> requestType) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenId).stream().filter(request -> request.getType().isSubtypeOf(requestType)).map(request -> request).iterator());
    }

    @Override
    public boolean createPickupRequest(int scaledPriority) {
        if (scaledPriority < 0 || scaledPriority > AbstractDeliverymanRequestable.getPlayerActionPriority(true)) {
            return false;
        }
        ArrayList reqs = new ArrayList(this.getOpenRequestsByRequestableType().getOrDefault(TypeConstants.PICKUP, Collections.emptyList()));
        if (!reqs.isEmpty()) {
            for (IToken req : reqs) {
                IRequestResolver<?> resolver;
                IRequest<?> request = this.colony.getRequestManager().getRequestForToken(req);
                if (request == null || request.getState() != RequestState.IN_PROGRESS || !((resolver = this.colony.getRequestManager().getResolverForRequest(req)) instanceof IPlayerRequestResolver) && !(resolver instanceof IRetryingRequestResolver)) continue;
                this.colony.getRequestManager().reassignRequest(req, Collections.emptyList());
            }
            return false;
        }
        this.createRequest(new Pickup(scaledPriority), true);
        return true;
    }

    @Override
    public boolean hasCitizenCompletedRequests(@NotNull ICitizenData data) {
        return this.getCompletedRequestsByCitizen().containsKey(data.getId()) && !this.getCompletedRequestsByCitizen().get(data.getId()).isEmpty();
    }

    @Override
    public boolean hasCitizenCompletedRequestsToPickup(@NotNull ICitizenData data) {
        if (!this.getCompletedRequestsByCitizen().containsKey(data.getId())) {
            return false;
        }
        for (IToken<?> token : this.getCompletedRequestsByCitizen().get(data.getId())) {
            if (data.isRequestAsync(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<IRequest<?>> getCompletedRequests(@NotNull ICitizenData data) {
        Collection<IToken<?>> tokens = this.getCompletedRequestsByCitizen().get(data.getId());
        if (tokens == null || tokens.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList requests = new ArrayList(tokens.size());
        for (IToken<?> token : tokens) {
            IRequest<?> request = this.colony.getRequestManager().getRequestForToken(token);
            if (request != null) {
                requests.add(request);
                continue;
            }
            this.getCompletedRequestsByCitizen().get(data.getId()).remove(token);
            if (!this.getCompletedRequestsByCitizen().get(data.getId()).isEmpty()) continue;
            this.getCompletedRequestsByCitizen().remove(data.getId());
        }
        return Collections.unmodifiableList(requests);
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfType(@NotNull ICitizenData citizenData, TypeToken<R> requestType) {
        return ImmutableList.copyOf(this.getCompletedRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf(requestType)).map(request -> request).iterator());
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfTypeFiltered(@NotNull ICitizenData citizenData, TypeToken<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getCompletedRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf(requestType)).map(request -> request).filter(filter).iterator());
    }

    @Override
    public void markRequestAsAccepted(@NotNull ICitizenData data, @NotNull IToken<?> token) {
        if (!this.getCompletedRequestsByCitizen().containsKey(data.getId()) || !this.getCompletedRequestsByCitizen().get(data.getId()).contains(token)) {
            throw new IllegalArgumentException("The given token " + token + " is not known as a completed request waiting for acceptance by the citizen.");
        }
        this.getCompletedRequestsByCitizen().get(data.getId()).remove(token);
        if (this.getCompletedRequestsByCitizen().get(data.getId()).isEmpty()) {
            this.getCompletedRequestsByCitizen().remove(data.getId());
        }
        this.colony.getRequestManager().updateRequestState(token, RequestState.RECEIVED);
        this.markDirty();
    }

    @Override
    public void cancelAllRequestsOfCitizen(@NotNull ICitizenData data) {
        this.getOpenRequests(data.getId()).forEach(request -> {
            this.colony.getRequestManager().updateRequestState((IToken<?>)request.getId(), RequestState.CANCELLED);
            if (this.getOpenRequestsByRequestableType().containsKey(TypeToken.of(request.getRequest().getClass()))) {
                this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getId());
                if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
                    this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
                }
            }
            this.getCitizensByRequest().remove(request.getId());
        });
        this.getCompletedRequests(data).forEach(request -> this.colony.getRequestManager().updateRequestState((IToken<?>)request.getId(), RequestState.RECEIVED));
        this.getOpenRequestsByCitizen().remove(data.getId());
        this.getCompletedRequestsByCitizen().remove(data.getId());
        this.markDirty();
    }

    @Override
    public void overruleNextOpenRequestWithStack(@NotNull ItemStack stack) {
        IRequest<? extends IDeliverable> target;
        if (ItemStackUtils.isEmpty(stack)) {
            return;
        }
        ImmutableCollection<IRequestResolver<?>> resolvers = this.getResolvers();
        ImmutableList<IToken<?>> playerRequests = this.colony.getRequestManager().getPlayerResolver().getAllAssignedRequests();
        ImmutableList<IToken<?>> retryingRequests = this.colony.getRequestManager().getRetryingRequestResolver().getAllAssignedRequests();
        for (IRequestResolver resolver : resolvers) {
            IStandardRequestManager requestManager = (IStandardRequestManager)this.colony.getRequestManager();
            List<IRequest<? extends IDeliverable>> deliverableRequests = requestManager.getRequestHandler().getRequestsMadeByRequester(resolver).stream().filter(iRequest -> iRequest.getRequest() instanceof IDeliverable).map(iRequest -> iRequest).collect(Collectors.toList());
            target = this.getFirstOverullingRequestFromInputList(deliverableRequests, stack);
            if (target == null || !this.isRequestStuck(target, (List<IToken<?>>)playerRequests, (List<IToken<?>>)retryingRequests)) continue;
            this.colony.getRequestManager().overruleRequest((IToken<?>)target.getId(), stack.m_41777_());
            return;
        }
        Set<Integer> citizenIdsWithRequests = this.getOpenRequestsByCitizen().keySet();
        for (int citizenId : citizenIdsWithRequests) {
            ICitizenData data = this.colony.getCitizenManager().getCivilian(citizenId);
            if (data == null || (target = this.getFirstOverullingRequestFromInputList((Collection<IRequest<? extends IDeliverable>>)this.getOpenRequestsOfType(data.getId(), TypeConstants.DELIVERABLE), stack)) == null || !this.isRequestStuck(target, (List<IToken<?>>)playerRequests, (List<IToken<?>>)retryingRequests)) continue;
            this.colony.getRequestManager().overruleRequest((IToken<?>)target.getId(), stack.m_41777_());
            return;
        }
    }

    private boolean isRequestStuck(IRequest<?> target, List<IToken<?>> playerResolverRequests, List<IToken<?>> retryingRequests) {
        if (playerResolverRequests.contains(target.getId()) || retryingRequests.contains(target.getId())) {
            return true;
        }
        for (IToken child : target.getChildren()) {
            if (!this.isRequestStuck(this.colony.getRequestManager().getRequestForToken(child), playerResolverRequests, retryingRequests)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull ICitizenData citizenData, TypeToken<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData.getId()).stream().filter(request -> request.getType().isSubtypeOf(requestType)).map(request -> request).filter(filter).iterator());
    }

    @Override
    public boolean overruleNextOpenRequestOfCitizenWithStack(@NotNull ICitizenData citizenData, @NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return false;
        }
        IRequest<? extends IDeliverable> target = this.getFirstOverullingRequestFromInputList((Collection<IRequest<? extends IDeliverable>>)this.getOpenRequestsOfType(citizenData.getId(), TypeConstants.DELIVERABLE), stack);
        if (target == null) {
            AbstractJobCrafter crafterJob;
            if (citizenData.getJob() instanceof AbstractJobCrafter && !(crafterJob = citizenData.getJob(AbstractJobCrafter.class)).getAssignedTasks().isEmpty()) {
                List<IToken<?>> assignedTasks = crafterJob.getAssignedTasks();
                IRequest deliverableChildRequest = assignedTasks.stream().map(this.colony.getRequestManager()::getRequestForToken).map(IRequest::getChildren).flatMap(Collection::stream).map(this.colony.getRequestManager()::getRequestForToken).filter(iRequest -> iRequest.getRequest() instanceof IDeliverable).filter(iRequest -> ((IDeliverable)iRequest.getRequest()).matches(stack)).findFirst().map(iRequest -> iRequest).orElse(null);
                if (deliverableChildRequest != null) {
                    deliverableChildRequest.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.of((Object)stack));
                    this.colony.getRequestManager().overruleRequest((IToken<?>)deliverableChildRequest.getId(), stack.m_41777_());
                    return true;
                }
            }
            return false;
        }
        try {
            target.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.of((Object)stack));
            this.colony.getRequestManager().overruleRequest((IToken<?>)target.getId(), stack.m_41777_());
        }
        catch (Exception ex) {
            Log.getLogger().error("Error during overruling", (Throwable)ex);
            Log.getLogger().error(target.getId().toString() + " " + target.getState().name() + " " + target.getShortDisplayString().toString());
            return false;
        }
        return true;
    }

    private IRequest<? extends IDeliverable> getFirstOverullingRequestFromInputList(@NotNull Collection<IRequest<? extends IDeliverable>> queue, @NotNull ItemStack stack) {
        if (queue.isEmpty()) {
            return null;
        }
        ArrayList validRequesterTokens = Lists.newArrayList();
        validRequesterTokens.add(this.getId());
        this.getResolvers().forEach(iRequestResolver -> validRequesterTokens.add(iRequestResolver.getId()));
        return queue.stream().filter(request -> request.getState() == RequestState.IN_PROGRESS && validRequesterTokens.contains(request.getRequester().getId()) && ((IDeliverable)request.getRequest()).matches(stack)).findFirst().orElse(null);
    }

    @Override
    public IToken<?> getId() {
        return this.requester.getId();
    }

    @Override
    public final ImmutableCollection<IRequestResolver<?>> getResolvers() {
        IStandardRequestManager requestManager = (IStandardRequestManager)this.colony.getRequestManager();
        if (!requestManager.getProviderHandler().getRegisteredResolvers(this).isEmpty()) {
            return ImmutableList.copyOf((Collection)requestManager.getProviderHandler().getRegisteredResolvers(this).stream().map(token -> requestManager.getResolverHandler().getResolver((IToken<?>)token)).collect(Collectors.toList()));
        }
        return this.createResolvers();
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ICreatesResolversModule module : this.getModulesByType((Class<T>)ICreatesResolversModule.class)) {
            builder.addAll(module.createResolvers());
        }
        builder.add((Object)new BuildingRequestResolver(this.getRequester().getLocation(), this.colony.getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    public IRequester getRequester() {
        return this.requester;
    }

    @Override
    @NotNull
    public ILocation getLocation() {
        return this.getRequester().getLocation();
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        if (!this.getCitizensByRequest().containsKey(request.getId())) {
            return;
        }
        int citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        if (this.getOpenRequestsByCitizen().containsKey(citizenThatRequested)) {
            this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(request.getId());
            if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
                this.getOpenRequestsByCitizen().remove(citizenThatRequested);
            }
        }
        this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getId());
        if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
            this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
        }
        if (citizenThatRequested >= 0) {
            this.getCompletedRequestsByCitizen().computeIfAbsent(citizenThatRequested, ArrayList::new).add(request.getId());
        } else {
            this.colony.getRequestManager().updateRequestState((IToken<?>)request.getId(), RequestState.RECEIVED);
        }
        this.markDirty();
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        int citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        Map<Integer, Collection<IToken<?>>> openRequestsByCitizen = this.getOpenRequestsByCitizen();
        Collection<IToken<?>> byCitizenList = openRequestsByCitizen.get(citizenThatRequested);
        if (byCitizenList != null) {
            byCitizenList.remove(request.getId());
            if (byCitizenList.isEmpty()) {
                openRequestsByCitizen.remove(citizenThatRequested);
            }
        }
        if (this.getOpenRequestsByRequestableType().containsKey(TypeToken.of(request.getRequest().getClass()))) {
            this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getId());
            if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
                this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
            }
        }
        if (this.colony.getCitizenManager().getCivilian(citizenThatRequested) != null) {
            this.colony.getCitizenManager().getCivilian(citizenThatRequested).onRequestCancelled((IToken<?>)request.getId());
        }
        this.markDirty();
    }

    @Override
    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        if (!this.getCitizensByRequest().containsKey(request.getId())) {
            return Component.m_237113_((String)"<UNKNOWN>");
        }
        int citizenId = this.getCitizensByRequest().get(request.getId());
        if (citizenId == -1) {
            return Component.m_237115_((String)this.getBuildingDisplayName());
        }
        ICitizenData citizenData = this.colony.getCitizenManager().getCivilian(citizenId);
        if (citizenData.getJob() == null) {
            return Component.m_237113_((String)citizenData.getName());
        }
        MutableComponent jobName = Component.m_237115_((String)citizenData.getJob().getJobRegistryEntry().getTranslationKey().toLowerCase());
        return jobName.m_7220_((Component)Component.m_237113_((String)(" " + citizenData.getName())));
    }

    @Override
    public Optional<ICitizenData> getCitizenForRequest(@NotNull IToken<?> token) {
        if (!this.getCitizensByRequest().containsKey(token) || this.colony == null) {
            return Optional.empty();
        }
        int citizenID = this.getCitizensByRequest().get(token);
        if (citizenID == -1 || this.colony.getCitizenManager().getCivilian(citizenID) == null) {
            return Optional.empty();
        }
        return Optional.of(this.colony.getCitizenManager().getCivilian(citizenID));
    }

    @Override
    public Map<ItemStorage, Integer> reservedStacksExcluding(@NotNull IRequest<? extends IDeliverable> excluded) {
        HashMap<ItemStorage, Integer> map = new HashMap<ItemStorage, Integer>();
        for (IHasRequiredItemsModule module : this.getModulesByType((Class<T>)IHasRequiredItemsModule.class)) {
            for (Map.Entry<ItemStorage, Integer> content : module.reservedStacksExcluding(excluded).entrySet()) {
                int current = map.getOrDefault(content.getKey(), 0);
                map.put(content.getKey(), current + content.getValue());
            }
        }
        return map;
    }
}

