/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.structurize.client.gui.WindowSwitchPack;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowBannerPicker;
import com.minecolonies.coremod.client.gui.map.WindowColonyMap;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.client.gui.townhall.WindowTownHallMercenary;
import com.minecolonies.coremod.client.gui.townhall.WindowTownHallNameEntry;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.event.TextureReloadListener;
import com.minecolonies.coremod.network.messages.server.colony.ColonyNameStyleMessage;
import com.minecolonies.coremod.network.messages.server.colony.ColonyStructureStyleMessage;
import com.minecolonies.coremod.network.messages.server.colony.ColonyTextureStyleMessage;
import com.minecolonies.coremod.network.messages.server.colony.TeamColonyColorChangeMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleHelpMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleHousingMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleJobMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleMoveInMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.NotNull;

public class WindowMainPage
extends AbstractWindowTownHall {
    private static AtomicBoolean isFeatureUnlocked = new AtomicBoolean(false);
    private DropDownList colorDropDownList;
    private DropDownList textureDropDownList;
    private DropDownList nameStyleDropDownList;
    private int initialTextureIndex;
    private int initialNamePackIndex;
    private final Text title;

    public WindowMainPage(BuildingTownHall.View building) {
        super(building, "layoutactions.xml");
        this.initDropDowns();
        this.title = (Text)this.findPaneOfTypeByID("name", Text.class);
        this.registerButton("changeSpec", this::doNothing);
        this.registerButton("rename", this::renameClicked);
        this.registerButton("mercenaries", this::mercenaryClicked);
        this.registerButton("map", this::mapButtonClicked);
        this.registerButton("patreon", this::patreonClicked);
        this.registerButton("toggleJob", this::toggleHiring);
        this.registerButton("toggleHousing", this::toggleHousing);
        this.registerButton("toggleMoveIn", this::toggleMoveIn);
        this.registerButton("togglePrintProgress", this::togglePrintProgress);
        this.registerButton("colonyStylePicker", this::switchPack);
        ((ButtonImage)this.findPaneOfTypeByID("colonyStylePicker", ButtonImage.class)).setText(Component.m_237113_((String)building.getColony().getStructurePack()));
        this.registerButton("bannerPicker", this::openBannerPicker);
        this.registerButton("resettexture", this::resetTextureStyle);
        this.colorDropDownList.setSelectedIndex(building.getColony().getTeamColonyColor().ordinal());
        this.textureDropDownList.setSelectedIndex(TextureReloadListener.TEXTURE_PACKS.indexOf(building.getColony().getTextureStyleId()));
        this.initialTextureIndex = this.textureDropDownList.getSelectedIndex();
        this.nameStyleDropDownList.setSelectedIndex(building.getColony().getNameFileIds().indexOf(building.getColony().getNameStyle()));
        this.initialNamePackIndex = this.nameStyleDropDownList.getSelectedIndex();
        this.checkFeatureUnlock();
        if (building.getColony().isManualHiring()) {
            ((Button)this.findPaneOfTypeByID("toggleJob", Button.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.on"));
        }
        if (!building.getColony().isPrintingProgress()) {
            ((Button)this.findPaneOfTypeByID("togglePrintProgress", Button.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.townhall.off"));
        }
        if (building.getColony().isManualHousing()) {
            ((Button)this.findPaneOfTypeByID("toggleHousing", Button.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.on"));
        }
        if (building.getColony().canMoveIn()) {
            ((Button)this.findPaneOfTypeByID("toggleMoveIn", Button.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.townhall.on"));
        }
    }

    private void toggleHiring(@NotNull Button button) {
        boolean toggle;
        String key;
        ComponentContents componentContents = button.getText().m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            v0 = contents.m_237508_();
        } else {
            v0 = key = button.getTextAsString();
        }
        if (key.equals("com.minecolonies.coremod.gui.hiring.off")) {
            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.on"));
            toggle = true;
        } else {
            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.off"));
            toggle = false;
        }
        Network.getNetwork().sendToServer(new ToggleJobMessage(((ITownHallView)this.building).getColony(), toggle));
    }

    private void toggleHousing(@NotNull Button button) {
        boolean toggle;
        String key;
        ComponentContents componentContents = button.getText().m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            v0 = contents.m_237508_();
        } else {
            v0 = key = button.getTextAsString();
        }
        if (key.equals("com.minecolonies.coremod.gui.hiring.off")) {
            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.on"));
            toggle = true;
        } else {
            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.off"));
            toggle = false;
        }
        Network.getNetwork().sendToServer(new ToggleHousingMessage(((ITownHallView)this.building).getColony(), toggle));
    }

    private void toggleMoveIn(@NotNull Button button) {
        boolean toggle;
        String key;
        ComponentContents componentContents = button.getText().m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            v0 = contents.m_237508_();
        } else {
            v0 = key = button.getTextAsString();
        }
        if (key.equals("com.minecolonies.coremod.gui.townhall.off")) {
            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.townhall.on"));
            toggle = true;
        } else {
            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.townhall.off"));
            toggle = false;
        }
        Network.getNetwork().sendToServer(new ToggleMoveInMessage(((ITownHallView)this.building).getColony(), toggle));
    }

    private void togglePrintProgress(@NotNull Button button) {
        String key;
        ComponentContents componentContents = button.getText().m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            v0 = contents.m_237508_();
        } else {
            v0 = key = button.getTextAsString();
        }
        if (key.equals("com.minecolonies.coremod.gui.townhall.off")) {
            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.townhall.on"));
        } else {
            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.townhall.off"));
        }
        Network.getNetwork().sendToServer(new ToggleHelpMessage(((ITownHallView)this.building).getColony()));
    }

    private void switchPack() {
        new WindowSwitchPack(() -> {
            ((ITownHallView)this.building).getColony().setStructurePack(StructurePacks.selectedPack.getName());
            Network.getNetwork().sendToServer(new ColonyStructureStyleMessage(((ITownHallView)this.building).getColony(), StructurePacks.selectedPack.getName()));
            return new WindowMainPage((BuildingTownHall.View)this.building);
        }).open();
    }

    private void initDropDowns() {
        ((DropDownList)this.findPaneOfTypeByID("colorPicker", DropDownList.class)).setEnabled(this.enabled);
        this.colorDropDownList = (DropDownList)this.findPaneOfTypeByID("colorPicker", DropDownList.class);
        this.colorDropDownList.setHandler(this::onDropDownListChanged);
        final List<ChatFormatting> textColors = Arrays.stream(ChatFormatting.values()).filter(ChatFormatting::m_126664_).toList();
        this.colorDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return textColors.size();
            }

            public String getLabel(int index) {
                if (index >= 0 && index < textColors.size()) {
                    String colorName = ((ChatFormatting)textColors.get(index)).m_126666_().replace("_", " ");
                    return colorName.substring(0, 1).toUpperCase(Locale.US) + colorName.substring(1);
                }
                return "";
            }
        });
        this.textureDropDownList = (DropDownList)this.findPaneOfTypeByID("textureStylePicker", DropDownList.class);
        this.textureDropDownList.setHandler(this::toggleTexture);
        this.textureDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return TextureReloadListener.TEXTURE_PACKS.size();
            }

            public String getLabel(int index) {
                return TextureReloadListener.TEXTURE_PACKS.get(index);
            }
        });
        this.nameStyleDropDownList = (DropDownList)this.findPaneOfTypeByID("nameStylePicker", DropDownList.class);
        this.nameStyleDropDownList.setHandler(this::toggleNameFile);
        this.nameStyleDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowMainPage.this.building).getColony().getNameFileIds().size();
            }

            public String getLabel(int index) {
                return ((ITownHallView)WindowMainPage.this.building).getColony().getNameFileIds().get(index);
            }
        });
    }

    private void toggleTexture(DropDownList dropDownList) {
        if (dropDownList.getSelectedIndex() != this.initialTextureIndex) {
            Network.getNetwork().sendToServer(new ColonyTextureStyleMessage(((ITownHallView)this.building).getColony(), TextureReloadListener.TEXTURE_PACKS.get(dropDownList.getSelectedIndex())));
        }
    }

    private void toggleNameFile(DropDownList dropDownList) {
        if (dropDownList.getSelectedIndex() != this.initialNamePackIndex) {
            Network.getNetwork().sendToServer(new ColonyNameStyleMessage(((ITownHallView)this.building).getColony(), ((ITownHallView)this.building).getColony().getNameFileIds().get(dropDownList.getSelectedIndex())));
        }
    }

    private void onDropDownListChanged(DropDownList dropDownList) {
        Network.getNetwork().sendToServer(new TeamColonyColorChangeMessage(dropDownList.getSelectedIndex(), this.building));
    }

    private void openBannerPicker(@NotNull Button button) {
        WindowBannerPicker window = new WindowBannerPicker(((ITownHallView)this.building).getColony(), this, isFeatureUnlocked);
        Minecraft.m_91087_().m_91152_((Screen)window);
    }

    private void resetTextureStyle() {
        Network.getNetwork().sendToServer(new ColonyTextureStyleMessage(((ITownHallView)this.building).getColony(), TextureReloadListener.TEXTURE_PACKS.get(0)));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        Pane textPane = this.findPaneByID("textureStylePicker");
        Pane namePane = this.findPaneByID("nameStylePicker");
        Pane resetButton = this.findPaneByID("resettexture");
        if (isFeatureUnlocked.get()) {
            textPane.enable();
            namePane.enable();
            textPane.show();
            resetButton.hide();
        } else {
            textPane.disable();
            namePane.disable();
            if (!((ITownHallView)this.building).getColony().getTextureStyleId().equals("default")) {
                resetButton.show();
                textPane.hide();
            } else {
                textPane.show();
            }
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane(textPane).append(Component.m_237115_((String)"com.minecolonies.core.townhall.patreon.textures"))).paragraphBreak()).appendNL(Component.m_237119_())).appendNL(Component.m_237115_((String)"com.minecolonies.core.townhall.patreon"))).paragraphBreak()).build();
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane(namePane).append(Component.m_237115_((String)"com.minecolonies.core.townhall.patreon.names"))).paragraphBreak()).appendNL(Component.m_237119_())).appendNL(Component.m_237115_((String)"com.minecolonies.core.townhall.patreon"))).paragraphBreak()).build();
        }
    }

    public void checkFeatureUnlock() {
        String player = Minecraft.m_91087_().f_91074_.m_20149_();
        new Thread(() -> {
            try {
                String inputLine;
                SSLSocketFactory sslsocketfactory = HttpsURLConnection.getDefaultSSLSocketFactory();
                URL url = new URL("https://auth.minecolonies.com/api/minecraft/" + player + "/features");
                HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
                conn.setSSLSocketFactory(sslsocketfactory);
                InputStream responseBody = conn.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(responseBody));
                StringBuilder response = new StringBuilder();
                while ((inputLine = reader.readLine()) != null) {
                    response.append(inputLine);
                }
                reader.close();
                isFeatureUnlocked.set(Boolean.parseBoolean(response.toString()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    private void patreonClicked() {
        Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(check -> {
            if (check) {
                Util.m_137581_().m_137646_("https://www.patreon.com/Minecolonies");
            }
            Minecraft.m_91087_().m_91152_((Screen)this.screen);
        }, "https://www.patreon.com/Minecolonies", true));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.title.setText(Component.m_237113_((String)((ITownHallView)this.building).getColony().getName()));
        if (((ITownHallView)this.building).getColony().getMercenaryUseTime() != 0L && ((ITownHallView)this.building).getColony().getWorld().m_46467_() - ((ITownHallView)this.building).getColony().getMercenaryUseTime() < 48000L) {
            ((Button)this.findPaneOfTypeByID("mercenaries", Button.class)).disable();
        }
    }

    private void renameClicked() {
        @NotNull WindowTownHallNameEntry window = new WindowTownHallNameEntry(((ITownHallView)this.building).getColony());
        window.open();
    }

    private void mercenaryClicked() {
        @NotNull WindowTownHallMercenary window = new WindowTownHallMercenary(((ITownHallView)this.building).getColony());
        window.open();
    }

    private void mapButtonClicked() {
        @NotNull WindowColonyMap window = new WindowColonyMap(this.building);
        window.open();
    }

    @Override
    protected String getWindowId() {
        return "actions";
    }
}

