/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.citizen;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.constant.WindowConstants;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.citizen.JobWindowCitizen;
import com.minecolonies.coremod.client.gui.modules.WindowBuilderResModule;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class CitizenWindowUtils {
    public static final ResourceLocation HAPPINESS_ICONS_LOCATION = new ResourceLocation("minecolonies", "textures/gui/citizen/icons.png");

    private CitizenWindowUtils() {
    }

    public static void createHealthBar(ICitizenDataView citizen, View healthBarView) {
        int health = (int)citizen.getHealth();
        CitizenWindowUtils.createHealthBar(health, healthBarView);
    }

    public static void createHealthBar(int health, View healthBarView) {
        healthBarView.setAlignment(Alignment.MIDDLE_RIGHT);
        ((Text)healthBarView.findPaneOfTypeByID("healthLabel", Text.class)).setText(Component.m_237113_((String)Integer.toString(health / 2)));
        for (int i = 0; i < 10; ++i) {
            CitizenWindowUtils.addHeart(healthBarView, i, HeartsEnum.EMPTY);
        }
        int heartPos = 0;
        ArrayList<HeartsEnum> heartList = new ArrayList<HeartsEnum>();
        heartList.add(HeartsEnum.BLUE);
        heartList.add(HeartsEnum.GREEN);
        heartList.add(HeartsEnum.GOLDEN);
        heartList.add(HeartsEnum.RED);
        for (HeartsEnum heart : heartList) {
            if (heart.isHalfHeart || heart.prevHeart == null) continue;
            for (int i = heartPos; i < 10 && health > heart.prevHeart.hpValue * 10 + 1; ++i) {
                CitizenWindowUtils.addHeart(healthBarView, heartPos, heart);
                health -= heart.hpValue - heart.prevHeart.hpValue;
                ++heartPos;
            }
            if (health % 2 == 1 && heartPos < 10 && heart.halfHeart != null && health > heart.prevHeart.hpValue * 10) {
                CitizenWindowUtils.addHeart(healthBarView, heartPos, heart.prevHeart);
                CitizenWindowUtils.addHeart(healthBarView, heartPos, heart.halfHeart);
                health -= heart.halfHeart.hpValue - heart.prevHeart.hpValue;
                ++heartPos;
            }
            if (heartPos < 10) continue;
            return;
        }
    }

    private static void addHeart(View healthBarView, int heartPos, HeartsEnum heart) {
        @NotNull Image heartImage = new Image();
        heartImage.setImage(heart.Image, heart.X, heart.Y, 9, 9);
        heartImage.setMapDimensions(256, 256);
        heartImage.setSize(9, 9);
        heartImage.setPosition(heartPos * 10 + 10, 10);
        healthBarView.addChild((Pane)heartImage);
    }

    private static int getYOffset(int i) {
        return i >= 10 ? 10 : 0;
    }

    private static int getXOffsetModifier(int i) {
        return i >= 10 ? i - 10 : i;
    }

    public static void createSaturationBar(ICitizenDataView citizen, View view) {
        CitizenWindowUtils.createSaturationBar(citizen.getSaturation(), view);
    }

    public static void createSaturationBar(double curSaturation, View view) {
        int saturationPos;
        Image saturation;
        ((View)view.findPaneOfTypeByID("saturationBar", View.class)).setAlignment(Alignment.MIDDLE_RIGHT);
        for (int i = 0; i < 20; ++i) {
            saturation = new Image();
            saturation.setImage(Gui.f_279580_, 16, 27, 9, 9);
            saturation.setMapDimensions(256, 256);
            saturation.setSize(9, 9);
            saturation.setPosition(CitizenWindowUtils.getXOffsetModifier(i) * 10 + 10, 10 + CitizenWindowUtils.getYOffset(i));
            ((View)view.findPaneOfTypeByID("saturationBar", View.class)).addChild((Pane)saturation);
        }
        for (saturationPos = 0; saturationPos < (int)curSaturation; ++saturationPos) {
            saturation = new Image();
            saturation.setImage(Gui.f_279580_, 52, 27, 9, 9);
            saturation.setMapDimensions(256, 256);
            saturation.setSize(9, 9);
            saturation.setPosition(CitizenWindowUtils.getXOffsetModifier(saturationPos) * 10 + 10, 10 + CitizenWindowUtils.getYOffset(saturationPos));
            ((View)view.findPaneOfTypeByID("saturationBar", View.class)).addChild((Pane)saturation);
        }
        if (curSaturation / 2.0 % 1.0 > 0.0) {
            saturation = new Image();
            saturation.setImage(Gui.f_279580_, 61, 27, 9, 9);
            saturation.setMapDimensions(256, 256);
            saturation.setSize(9, 9);
            saturation.setPosition(CitizenWindowUtils.getXOffsetModifier(saturationPos) * 10 + 10, 10 + CitizenWindowUtils.getYOffset(saturationPos));
            ((View)view.findPaneOfTypeByID("saturationBar", View.class)).addChild((Pane)saturation);
        }
    }

    public static void createHappinessBar(ICitizenDataView citizen, View happinessParView) {
        int happiness = (int)citizen.getHappiness() * 2;
        for (int i = 0; i < 10; ++i) {
            CitizenWindowUtils.addSmiley(happinessParView, i, SmileyEnum.EMPTY);
        }
        int smileyPos = 0;
        ArrayList<SmileyEnum> heartList = new ArrayList<SmileyEnum>();
        heartList.add(SmileyEnum.RED);
        for (SmileyEnum smiley : heartList) {
            if (smiley.isHalfSmiley || smiley.prevSmiley == null) continue;
            for (int i = smileyPos; i < 10 && happiness > smiley.prevSmiley.happinessValue * 10 + 1; ++i) {
                CitizenWindowUtils.addSmiley(happinessParView, smileyPos, smiley);
                happiness -= smiley.happinessValue - smiley.prevSmiley.happinessValue;
                ++smileyPos;
            }
            if (happiness % 2 == 1 && smileyPos < 10 && smiley.halfSmiley != null && happiness > smiley.prevSmiley.happinessValue * 10) {
                CitizenWindowUtils.addSmiley(happinessParView, smileyPos, smiley.prevSmiley);
                CitizenWindowUtils.addSmiley(happinessParView, smileyPos, smiley.halfSmiley);
                happiness -= smiley.halfSmiley.happinessValue - smiley.prevSmiley.happinessValue;
                ++smileyPos;
            }
            if (smileyPos < 10) continue;
            return;
        }
    }

    private static void addSmiley(View happinessBarView, int happinessPos, SmileyEnum smiley) {
        @NotNull Image smileyImage = new Image();
        smileyImage.setImage(smiley.Image, smiley.X, smiley.Y, 9, 9);
        smileyImage.setMapDimensions(9, 87);
        smileyImage.setSize(9, 9);
        smileyImage.setPosition(happinessPos * 10 + 10, 10);
        happinessBarView.addChild((Pane)smileyImage);
    }

    public static void createHappinessBar(ICitizenDataView citizen, AbstractWindowSkeleton window) {
        ((View)window.findPaneOfTypeByID("happinessBar", View.class)).setAlignment(Alignment.MIDDLE_RIGHT);
        ((Text)window.findPaneOfTypeByID("happinessLabel", Text.class)).setText(Component.m_237113_((String)Integer.toString((int)citizen.getHappiness())));
        CitizenWindowUtils.createHappinessBar(citizen, (View)window.findPaneOfTypeByID("happinessBar", View.class));
    }

    public static void createSkillContent(ICitizenDataView citizen, AbstractWindowSkeleton window) {
        boolean isCreative = Minecraft.m_91087_().f_91074_.m_7500_();
        for (Map.Entry<Skill, Tuple<Integer, Double>> entry : citizen.getCitizenSkillHandler().getSkills().entrySet()) {
            String id = entry.getKey().name().toLowerCase(Locale.US);
            ((Text)window.findPaneOfTypeByID(id, Text.class)).setText(Component.m_237113_((String)Integer.toString((Integer)entry.getValue().m_14418_())));
            Pane buttons = window.findPaneByID(id + "_bts");
            if (buttons == null) continue;
            buttons.setEnabled(isCreative);
        }
    }

    public static void updateHappiness(ICitizenDataView citizen, AbstractWindowSkeleton window) {
        ((Text)window.findPaneOfTypeByID("happinessModifier", Text.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.happiness.happinessmodifier"));
        int yPos = 62;
        for (String name : citizen.getHappinessHandler().getModifiers()) {
            double value = citizen.getHappinessHandler().getModifier(name).getFactor(null);
            if (value == 1.0) continue;
            Image image = new Image();
            image.setSize(11, 11);
            image.setPosition(45, yPos);
            window.addChild((Pane)image);
            Text label = new Text();
            label.setSize(136, 11);
            label.setPosition(70, yPos);
            label.setColors(WindowBuilderResModule.BLACK);
            label.setText(Component.m_237115_((String)("com.minecolonies.coremod.gui.townhall.happiness." + name)));
            window.addChild((Pane)label);
            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)label).append(Component.m_237115_((String)("com.minecolonies.coremod.gui.townhall.happiness.desc." + name)))).build();
            if (value > 1.0) {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/happy_icon.png"), false);
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237115_((String)"com.minecolonies.coremod.gui.happiness.positive"))).hoverPane((Pane)image).build();
            } else if (value == 1.0) {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/satisfied_icon.png"), false);
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237115_((String)"com.minecolonies.coremod.gui.happiness.neutral"))).hoverPane((Pane)image).build();
            } else if (value > 0.75) {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/unsatisfied_icon.png"), false);
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237115_((String)"com.minecolonies.coremod.gui.happiness.slightlynegative"))).hoverPane((Pane)image).build();
            } else {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/unhappy_icon.png"), false);
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237115_((String)"com.minecolonies.coremod.gui.happiness.negative"))).hoverPane((Pane)image).build();
            }
            yPos += 12;
        }
    }

    public static void updateJobPage(ICitizenDataView citizen, JobWindowCitizen windowCitizen, IColonyView colony) {
        IBuildingView building = colony.getBuilding(citizen.getWorkBuilding());
        if (building instanceof AbstractBuildingView && building.getBuildingType() != ModBuildings.library.get() && citizen.getJobView() != null) {
            WorkerBuildingModuleView moduleView = building.getModuleViewMatching(WorkerBuildingModuleView.class, m -> m.getJobEntry() == citizen.getJobView().getEntry());
            if (moduleView == null) {
                return;
            }
            ((Text)windowCitizen.findPaneOfTypeByID("jobLabel", Text.class)).setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.citizen.job.label", (Object[])new Object[]{Component.m_237115_((String)citizen.getJob())}));
            ((Text)windowCitizen.findPaneOfTypeByID("skillexplanation", Text.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.citizen.job.desc"));
            Skill primary = moduleView.getPrimarySkill();
            ((Text)windowCitizen.findPaneOfTypeByID("primary", Text.class)).setText(Component.m_237115_((String)("com.minecolonies.coremod.gui.citizen.job.skills." + primary.name().toLowerCase(Locale.US))).m_130946_(" (100% XP)"));
            ((Image)windowCitizen.findPaneOfTypeByID("primaryimg", Image.class)).setImage(new ResourceLocation("minecolonies:textures/entity/skills/small/" + primary.name().toLowerCase(Locale.US) + ".png"), false);
            if (primary.getComplimentary() != null && primary.getAdverse() != null) {
                ((Text)windowCitizen.findPaneOfTypeByID("comp1", Text.class)).setText(Component.m_237115_((String)("com.minecolonies.coremod.gui.citizen.job.skills." + primary.getComplimentary().name().toLowerCase(Locale.US))).m_130946_(" (10% XP)"));
                ((Image)windowCitizen.findPaneOfTypeByID("comp1img", Image.class)).setImage(new ResourceLocation("minecolonies:textures/entity/skills/small/" + primary.getComplimentary().name().toLowerCase(Locale.US) + ".png"), false);
                ((Text)windowCitizen.findPaneOfTypeByID("adverse1", Text.class)).setText(Component.m_237115_((String)("com.minecolonies.coremod.gui.citizen.job.skills." + primary.getAdverse().name().toLowerCase(Locale.US))).m_130946_(" (-10% XP)"));
                ((Image)windowCitizen.findPaneOfTypeByID("adverse1img", Image.class)).setImage(new ResourceLocation("minecolonies:textures/entity/skills/small/" + primary.getAdverse().name().toLowerCase(Locale.US) + ".png"), false);
            }
            Skill secondary = moduleView.getSecondarySkill();
            ((Text)windowCitizen.findPaneOfTypeByID("secondary", Text.class)).setText(Component.m_237115_((String)("com.minecolonies.coremod.gui.citizen.job.skills." + secondary.name().toLowerCase(Locale.US))).m_130946_(" (50% XP)"));
            ((Image)windowCitizen.findPaneOfTypeByID("secondaryimg", Image.class)).setImage(new ResourceLocation("minecolonies:textures/entity/skills/small/" + secondary.name().toLowerCase(Locale.US) + ".png"), false);
            if (secondary.getComplimentary() != null && secondary.getAdverse() != null) {
                ((Text)windowCitizen.findPaneOfTypeByID("comp2", Text.class)).setText(Component.m_237115_((String)("com.minecolonies.coremod.gui.citizen.job.skills." + secondary.getComplimentary().name().toLowerCase(Locale.US))).m_130946_(" (5% XP)"));
                ((Image)windowCitizen.findPaneOfTypeByID("comp2img", Image.class)).setImage(new ResourceLocation("minecolonies:textures/entity/skills/small/" + secondary.getComplimentary().name().toLowerCase(Locale.US) + ".png"), false);
                ((Text)windowCitizen.findPaneOfTypeByID("adverse2", Text.class)).setText(Component.m_237115_((String)("com.minecolonies.coremod.gui.citizen.job.skills." + secondary.getAdverse().name().toLowerCase(Locale.US))).m_130946_(" (-5% XP)"));
                ((Image)windowCitizen.findPaneOfTypeByID("adverse2img", Image.class)).setImage(new ResourceLocation("minecolonies:textures/entity/skills/small/" + secondary.getAdverse().name().toLowerCase(Locale.US) + ".png"), false);
            }
        } else {
            ((Image)windowCitizen.findPaneOfTypeByID("primaryimg", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("comp1img", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("adverse1img", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("secondaryimg", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("comp2img", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("adverse2img", Image.class)).hide();
        }
    }

    private static enum HeartsEnum {
        EMPTY(Gui.f_279580_, 16, 0, 0, null, null),
        HALF_RED(Gui.f_279580_, 61, 0, 1, null, EMPTY),
        RED(Gui.f_279580_, 52, 0, 2, HALF_RED, EMPTY),
        HALF_GOLDEN(Gui.f_279580_, 169, 0, 3, null, RED),
        GOLDEN(Gui.f_279580_, 160, 0, 4, HALF_GOLDEN, RED),
        HALF_GREEN(WindowConstants.GREEN_BLUE_ICON, 8, 0, 5, null, GOLDEN),
        GREEN(WindowConstants.GREEN_BLUE_ICON, 0, 0, 6, HALF_GREEN, GOLDEN),
        HALF_BLUE(WindowConstants.GREEN_BLUE_ICON, 8, 8, 7, null, GREEN),
        BLUE(WindowConstants.GREEN_BLUE_ICON, 0, 8, 8, HALF_BLUE, GREEN);

        public final int X;
        public final int Y;
        public final int hpValue;
        public final HeartsEnum prevHeart;
        public final HeartsEnum halfHeart;
        public boolean isHalfHeart = false;
        public final ResourceLocation Image;

        private HeartsEnum(ResourceLocation heartImage, int x, int y, int hpValue, HeartsEnum halfHeart, HeartsEnum prevHeart) {
            this.Image = heartImage;
            this.X = x;
            this.Y = y;
            this.hpValue = hpValue;
            this.halfHeart = halfHeart;
            if (halfHeart == null) {
                this.isHalfHeart = true;
            }
            this.prevHeart = prevHeart;
        }
    }

    private static enum SmileyEnum {
        EMPTY(HAPPINESS_ICONS_LOCATION, 16, 0, 0, null, null),
        HALF_RED(HAPPINESS_ICONS_LOCATION, 61, 0, 1, null, EMPTY),
        RED(HAPPINESS_ICONS_LOCATION, 52, 0, 2, HALF_RED, EMPTY);

        public final int X;
        public final int Y;
        public final int happinessValue;
        public final SmileyEnum prevSmiley;
        public final SmileyEnum halfSmiley;
        public boolean isHalfSmiley = false;
        public final ResourceLocation Image;

        private SmileyEnum(ResourceLocation heartImage, int x, int y, int happinessValue, SmileyEnum halfSmiley, SmileyEnum prevSmiley) {
            this.Image = heartImage;
            this.X = x;
            this.Y = y;
            this.happinessValue = happinessValue;
            this.halfSmiley = halfSmiley;
            if (halfSmiley == null) {
                this.isHalfSmiley = true;
            }
            this.prevSmiley = prevSmiley;
        }
    }
}

