/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.modules.IAssignmentModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.modules.WindowBuilderResModule;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.buildings.moduleviews.PupilBuildingModuleView;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.citizen.PauseCitizenMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.RestartCitizenMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class WindowHireWorker
extends AbstractWindowSkeleton {
    protected final AbstractBuildingView building;
    protected final IColonyView colony;
    protected List<ICitizenDataView> citizens = new ArrayList<ICitizenDataView>();
    protected final ScrollingList citizenList;
    protected final List<IAssignmentModuleView> moduleViews = new ArrayList<IAssignmentModuleView>();
    protected IAssignmentModuleView selectedModule;
    protected boolean showEmployed;

    public WindowHireWorker(IColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowhireworker.xml");
        this.colony = c;
        this.building = (AbstractBuildingView)this.colony.getBuilding(buildingId);
        this.citizenList = (ScrollingList)this.findPaneOfTypeByID("unemployed", ScrollingList.class);
        super.registerButton("cancel", this::cancelClicked);
        super.registerButton("done", this::doneClicked);
        super.registerButton("fire", this::fireClicked);
        super.registerButton("pause", this::pauseClicked);
        super.registerButton("restart", this::restartClicked);
        super.registerButton("mode", this::modeClicked);
        super.registerButton("showEmployed", this::showEmployedToggled);
        this.moduleViews.addAll(this.building.getModuleViews(IAssignmentModuleView.class));
        this.selectedModule = this.moduleViews.get(0);
        this.setupSettings((Button)this.findPaneOfTypeByID("mode", Button.class));
        this.setupShowEmployed();
    }

    private void cancelClicked(@NotNull Button button) {
        if (button.getID().equals("cancel") && this.colony.getTownHall() != null) {
            this.building.openGui(false);
        }
    }

    private void modeClicked(@NotNull Button button) {
        this.switchHiringMode(button);
    }

    private void switchHiringMode(Button settingsButton) {
        int index = this.selectedModule.getHiringMode().ordinal() + 1;
        if (index == HiringMode.LOCKED.ordinal()) {
            ++index;
        }
        if (index >= HiringMode.values().length) {
            index = 0;
        }
        this.selectedModule.setHiringMode(HiringMode.values()[index]);
        this.setupSettings(settingsButton);
    }

    private void setupSettings(Button settingsButton) {
        settingsButton.setText(Component.m_237115_((String)this.selectedModule.getHiringMode().getTranslationKey()));
    }

    private void restartClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        int id = this.citizens.toArray(new CitizenDataView[0])[row].getId();
        Network.getNetwork().sendToServer(new RestartCitizenMessage(this.building, id));
        this.close();
    }

    private void pauseClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        int id = this.citizens.toArray(new CitizenDataView[0])[row].getId();
        @NotNull ICitizenDataView citizen = this.citizens.get(row);
        Network.getNetwork().sendToServer(new PauseCitizenMessage(this.building, id));
        citizen.setPaused(!citizen.isPaused());
    }

    private void fireClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        @NotNull ICitizenDataView citizen = this.citizens.get(row);
        this.selectedModule.removeCitizen(citizen);
        this.onOpened();
    }

    private void doneClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        @NotNull ICitizenDataView citizen = this.citizens.get(row);
        if (citizen.getWorkBuilding() != null && this.selectedModule instanceof WorkerBuildingModuleView) {
            IBuildingView oldJob = this.colony.getBuilding(citizen.getWorkBuilding());
            oldJob.getModuleViewMatching(IAssignmentModuleView.class, m -> m.getJobEntry() == citizen.getJobView().getEntry()).removeCitizen(citizen);
        }
        this.selectedModule.addCitizen(citizen);
        this.onOpened();
    }

    protected int getCitizenPriority(ICitizenDataView citizen) {
        if (this.building.getPosition().equals((Object)citizen.getWorkBuilding())) {
            return 0;
        }
        if (citizen.getWorkBuilding() == null) {
            return 1;
        }
        if (this.selectedModule.canAssign(citizen)) {
            return citizen.getHomeBuilding() == null ? 2 : (int)BlockPosUtil.getDistance2D(this.building.getPosition(), citizen.getHomeBuilding());
        }
        return citizen.getHomeBuilding() == null ? 3 : (int)BlockPosUtil.getDistance2D(this.building.getPosition(), citizen.getHomeBuilding());
    }

    private void jobClicked(@NotNull Button button) {
        for (IAssignmentModuleView moduleView : this.moduleViews) {
            if (!moduleView.getJobEntry().getKey().toString().equals(button.getID())) continue;
            this.selectedModule = moduleView;
            this.setupShowEmployed();
            this.setupSettings((Button)this.findPaneOfTypeByID("mode", Button.class));
            this.updateCitizens();
            this.citizenList.refreshElementPanes();
            this.setupJobButtons();
            break;
        }
    }

    protected void showEmployedToggled(@NotNull Button button) {
        button.setText(Component.m_237115_((String)(this.showEmployed ? "gui.no" : "gui.yes")));
        this.showEmployed = !this.showEmployed;
        this.onOpened();
    }

    private void setupShowEmployed() {
        Button button = (Button)this.findPaneOfTypeByID("showEmployed", Button.class);
        button.setEnabled(this.selectedModule instanceof WorkerBuildingModuleView && !(this.selectedModule instanceof PupilBuildingModuleView));
        button.setText(Component.m_237115_((String)"gui.no"));
        this.showEmployed = false;
    }

    private boolean canAssign(ICitizenDataView citizen) {
        return this.showEmployed && !citizen.isChild() || this.selectedModule.canAssign(citizen);
    }

    protected void updateCitizens() {
        this.citizens.clear();
        this.citizens = this.colony.getCitizens().values().stream().filter(this::canAssign).sorted(Comparator.comparing(this::getCitizenPriority).thenComparing(ICitizen::getName)).collect(Collectors.toList());
    }

    public void onOpened() {
        this.updateCitizens();
        this.citizenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHireWorker.this.citizens.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                @NotNull ICitizenDataView citizen = WindowHireWorker.this.citizens.get(index);
                Button isPaused = (Button)rowPane.findPaneOfTypeByID("pause", Button.class);
                if (WindowHireWorker.this.canAssign(citizen) && !WindowHireWorker.this.selectedModule.isFull() && !WindowHireWorker.this.selectedModule.getAssignedCitizens().contains(citizen.getId())) {
                    ((Button)rowPane.findPaneOfTypeByID("fire", Button.class)).off();
                    ((Button)rowPane.findPaneOfTypeByID("done", Button.class)).on();
                    isPaused.off();
                    ((Button)rowPane.findPaneOfTypeByID("restart", Button.class)).off();
                } else if (WindowHireWorker.this.selectedModule.isFull() && !WindowHireWorker.this.selectedModule.getAssignedCitizens().contains(citizen.getId())) {
                    ((Button)rowPane.findPaneOfTypeByID("fire", Button.class)).off();
                    ((Button)rowPane.findPaneOfTypeByID("done", Button.class)).off();
                    isPaused.off();
                    ((Button)rowPane.findPaneOfTypeByID("restart", Button.class)).off();
                } else {
                    ((Button)rowPane.findPaneOfTypeByID("done", Button.class)).off();
                    ((Button)rowPane.findPaneOfTypeByID("fire", Button.class)).on();
                    isPaused.on();
                    isPaused.setText(Component.m_237115_((String)(citizen.isPaused() ? "com.minecolonies.coremod.gui.hiring.buttonunpaused" : "com.minecolonies.coremod.gui.hiring.buttonpaused")));
                }
                if (citizen.isPaused()) {
                    ((Button)rowPane.findPaneOfTypeByID("restart", Button.class)).on();
                } else {
                    ((Button)rowPane.findPaneOfTypeByID("restart", Button.class)).off();
                }
                MutableComponent intermString = Component.m_237113_((String)" ");
                AbstractTextBuilder.TextBuilder textBuilder = PaneBuilders.textBuilder();
                textBuilder.append(Component.m_237113_((String)""));
                int skillCount = citizen.getCitizenSkillHandler().getSkills().entrySet().size();
                Skill primary = WindowHireWorker.this.selectedModule instanceof WorkerBuildingModuleView ? ((WorkerBuildingModuleView)WindowHireWorker.this.selectedModule).getPrimarySkill() : null;
                Skill secondary = WindowHireWorker.this.selectedModule instanceof WorkerBuildingModuleView ? ((WorkerBuildingModuleView)WindowHireWorker.this.selectedModule).getSecondarySkill() : null;
                ArrayList<Map.Entry<Skill, Tuple<Integer, Double>>> skills = new ArrayList<Map.Entry<Skill, Tuple<Integer, Double>>>(citizen.getCitizenSkillHandler().getSkills().entrySet());
                skills.sort(Comparator.comparingInt(s -> s.getKey() == primary ? 1 : (s.getKey() == secondary ? 2 : 3)));
                for (Map.Entry entry : skills) {
                    String skillName = ((Skill)((Object)entry.getKey())).name().toLowerCase(Locale.US);
                    int skillLevel = (Integer)((Tuple)entry.getValue()).m_14418_();
                    Style skillStyle = WindowHireWorker.this.createColor(primary, secondary, (Skill)((Object)entry.getKey()));
                    textBuilder.append(Component.m_237115_((String)("com.minecolonies.coremod.gui.citizen.skills." + skillName)).m_6270_(skillStyle));
                    textBuilder.append(Component.m_237113_((String)(": " + skillLevel)).m_6270_(skillStyle));
                    if (--skillCount <= 0) continue;
                    textBuilder.append(intermString);
                }
                textBuilder.newLine();
                MutableComponent citizenLabelComponent = Component.m_237115_((String)(citizen.getJob().isEmpty() ? "com.minecolonies.coremod.gui.townhall.citizens.unemployed" : citizen.getJob())).m_130946_(": ").m_130946_(citizen.getName());
                ((Text)rowPane.findPaneOfTypeByID("citizen", Text.class)).setText((Component)citizenLabelComponent);
                if (citizen.getHomeBuilding() == null) {
                    ((Text)rowPane.findPaneOfTypeByID("distance", Text.class)).setText(Component.m_237115_((String)"com.minecolonies.core.gui.hiring.homeless"));
                } else if (citizen.getHomeBuilding().equals((Object)WindowHireWorker.this.building.getPosition())) {
                    ((Text)rowPane.findPaneOfTypeByID("distance", Text.class)).setText(Component.m_237115_((String)"com.minecolonies.core.gui.hiring.liveshere"));
                } else if (citizen.getHomeBuilding().equals((Object)citizen.getWorkBuilding())) {
                    ((Text)rowPane.findPaneOfTypeByID("distance", Text.class)).setText(Component.m_237115_((String)"com.minecolonies.core.gui.hiring.livesatwork"));
                } else {
                    ((Text)rowPane.findPaneOfTypeByID("distance", Text.class)).setText(Component.m_237110_((String)"com.minecolonies.core.gui.hiring.distance", (Object[])new Object[]{BlockPosUtil.getDistance2D(citizen.getHomeBuilding(), WindowHireWorker.this.building.getPosition())}));
                }
                ((Text)rowPane.findPaneOfTypeByID("attributes", Text.class)).setText(textBuilder.getText());
                JobEntry jobEntry = WindowHireWorker.this.selectedModule.getJobEntry();
                PaneBuilders.tooltipBuilder().hoverPane(rowPane.findPaneOfTypeByID("attributes", Text.class)).build().setText(Component.m_237115_((String)(jobEntry.getKey().toString() + ".skills.desc")));
            }
        });
        this.setupJobButtons();
    }

    public void setupJobButtons() {
        int xOffset = 15;
        for (IAssignmentModuleView hireModule : this.moduleViews) {
            JobEntry entry = hireModule.getJobEntry();
            ButtonImage jobButton = new ButtonImage();
            jobButton.setImage(new ResourceLocation("minecolonies:textures/gui/builderhut/builder_button_medium.png"), false);
            jobButton.setPosition(xOffset, 30);
            if (hireModule.getAssignedCitizens().size() > 0) {
                jobButton.setText(Component.m_237115_((String)entry.getTranslationKey()).m_7220_((Component)Component.m_237113_((String)(" " + hireModule.getAssignedCitizens().size()))));
            } else {
                jobButton.setText(Component.m_237115_((String)entry.getTranslationKey()));
            }
            jobButton.setID(hireModule.getJobEntry().getKey().toString());
            jobButton.setHandler(this::jobClicked);
            jobButton.setSize(86, 17);
            jobButton.setTextSize(86, 17);
            this.addChild((Pane)jobButton);
            PaneBuilders.tooltipBuilder().hoverPane((Pane)jobButton).build().setText(Component.m_237115_((String)(entry.getKey().toString() + ".job.desc")));
            if (entry.equals(this.selectedModule.getJobEntry())) {
                jobButton.disable();
            } else {
                jobButton.enable();
            }
            jobButton.setTextColor(WindowBuilderResModule.BLACK);
            xOffset += 90;
        }
    }

    protected Style createColor(Skill primary, Skill secondary, Skill current) {
        if (primary == current) {
            return Style.f_131099_.m_131157_(ChatFormatting.DARK_GREEN).m_131157_(ChatFormatting.BOLD);
        }
        if (secondary == current) {
            return Style.f_131099_.m_131157_(ChatFormatting.GOLD).m_131157_(ChatFormatting.BOLD);
        }
        return Style.f_131099_;
    }
}

