/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowBuildDecoration
extends AbstractWindowSkeleton {
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowbuildbuilding.xml";
    private static final int WHITE = Color.getByName((String)"white", (int)0);
    @NotNull
    private final List<Tuple<String, BlockPos>> builders = new ArrayList<Tuple<String, BlockPos>>();
    private final String packMeta;
    private final String path;
    private final Rotation rotation;
    private final boolean mirror;
    private final Function<BlockPos, IMessage> buildRequestMessage;
    private DropDownList buildersDropDownList;
    private final Map<String, ItemStorage> resources = new HashMap<String, ItemStorage>();
    private final BlockPos structurePos;
    private Future<Blueprint> blueprintFuture;

    public WindowBuildDecoration(BlockPos pos, String packMeta, String path, Rotation rotation, boolean mirror, Function<BlockPos, IMessage> buildRequestMessage) {
        super("minecolonies:gui/windowbuildbuilding.xml");
        this.packMeta = packMeta;
        this.path = path;
        this.structurePos = pos;
        this.registerButton("build", this::confirmedBuild);
        this.registerButton("cancel", this::close);
        ((Button)this.findPaneOfTypeByID("build", Button.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.build"));
        ((Button)this.findPaneOfTypeByID("build", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("deconstruct", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("repair", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("nextStyle", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("previousStyle", Button.class)).hide();
        ((DropDownList)this.findPaneOfTypeByID("style", DropDownList.class)).disable();
        ((DropDownList)this.findPaneOfTypeByID("style", DropDownList.class)).hide();
        String cleanedPackName = packMeta.replace(Minecraft.m_91087_().f_91074_.m_20148_().toString(), "");
        this.blueprintFuture = StructurePacks.getBlueprintFuture((String)cleanedPackName, (String)path);
        this.rotation = rotation;
        this.mirror = mirror;
        this.buildRequestMessage = buildRequestMessage;
    }

    public void onOpened() {
        super.onOpened();
        this.updateBuilders();
        this.updateResources();
    }

    public void onUpdate() {
        super.onUpdate();
        this.updateResources();
    }

    private void updateBuilders() {
        IColonyView colony = (IColonyView)IColonyManager.getInstance().getIColony((Level)Minecraft.m_91087_().f_91073_, this.structurePos);
        if (colony == null) {
            MessageUtils.format("com.minecolonies.coremod.workorder.outofcolony", this.path, this.structurePos.m_123341_(), this.structurePos.m_123343_()).sendTo(new Player[]{Minecraft.m_91087_().f_91074_});
            this.close();
            return;
        }
        this.builders.clear();
        this.builders.add((Tuple<String, BlockPos>)new Tuple((Object)(Component.m_237115_((String)((JobEntry)ModJobs.builder.get()).getTranslationKey()).getString() + ":"), (Object)BlockPos.f_121853_));
        this.builders.addAll(colony.getBuildings().stream().filter(build -> build instanceof AbstractBuildingBuilderView && !((AbstractBuildingBuilderView)build).getWorkerName().isEmpty() && build.getBuildingType() != ModBuildings.miner.get()).map(build -> new Tuple((Object)((AbstractBuildingBuilderView)build).getWorkerName(), (Object)build.getPosition())).sorted(Comparator.comparing(item -> ((BlockPos)item.m_14419_()).m_123331_((Vec3i)this.structurePos))).collect(Collectors.toList()));
        this.initBuilderNavigation();
    }

    private void initBuilderNavigation() {
        this.buildersDropDownList = (DropDownList)this.findPaneOfTypeByID("worker", DropDownList.class);
        this.buildersDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return WindowBuildDecoration.this.builders.size();
            }

            public String getLabel(int index) {
                if (index >= 0 && index < WindowBuildDecoration.this.builders.size()) {
                    return (String)WindowBuildDecoration.this.builders.get(index).m_14418_();
                }
                return "";
            }
        });
        this.buildersDropDownList.setSelectedIndex(0);
    }

    private void updateResources() {
        if (this.blueprintFuture == null || !this.blueprintFuture.isDone()) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        this.resources.clear();
        try {
            StructurePhasePlacementResult result;
            if (this.blueprintFuture.get() == null) {
                this.blueprintFuture = null;
                return;
            }
            LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler((Level)world, this.structurePos, this.blueprintFuture.get(), new PlacementSettings(), true);
            structure.getBluePrint().rotateWithMirror(this.rotation, this.mirror ? Mirror.FRONT_BACK : Mirror.NONE, (Level)Minecraft.m_91087_().f_91073_);
            StructurePlacer placer = new StructurePlacer((IStructureHandler)structure);
            BlockPos progressPos = AbstractBlueprintIterator.NULL_POS;
            do {
                result = placer.executeStructureStep((Level)world, null, progressPos, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(), true);
                progressPos = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    this.addNeededResource(stack, stack.m_41613_());
                }
            } while (result.getBlockResult().getResult() != BlockPlacementResult.Result.FINISHED);
            ((Button)this.findPaneOfTypeByID("build", Button.class)).show();
            ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
            this.updateResourceList();
            this.blueprintFuture = null;
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (ItemStackUtils.isEmpty(res) || amount == 0) {
            return;
        }
        int hashCode = res.m_41782_() ? res.m_41783_().hashCode() : 0;
        String key = res.m_41778_() + "-" + hashCode;
        ItemStorage resource = this.resources.get(key);
        if (resource == null) {
            resource = new ItemStorage(res);
            resource.setAmount(amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.resources.put(key, resource);
    }

    public void updateResourceList() {
        ScrollingList recourseList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        recourseList.enable();
        recourseList.show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        recourseList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = (ItemStorage)tempRes.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                Text quantityLabel = (Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class);
                resourceLabel.setText(Component.m_237113_((String)resource.getItemStack().m_41786_().getString()));
                quantityLabel.setText(Component.m_237113_((String)Integer.toString(resource.getAmount())));
                resourceLabel.setColors(WHITE);
                quantityLabel.setColors(WHITE);
                ItemStack itemIcon = new ItemStack((ItemLike)resource.getItem(), 1);
                itemIcon.m_41751_(resource.getItemStack().m_41783_());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(itemIcon);
            }
        });
    }

    private void confirmedBuild() {
        BlockPos builder = this.buildersDropDownList.getSelectedIndex() == 0 ? BlockPos.f_121853_ : (BlockPos)this.builders.get(this.buildersDropDownList.getSelectedIndex()).m_14419_();
        Network.getNetwork().sendToServer(this.buildRequestMessage.apply(builder));
        this.close();
    }
}

