/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.SwitchView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.server.ClickGuiButtonTriggerMessage;
import com.minecolonies.coremod.network.messages.server.OpenGuiWindowTriggerMessage;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWindowSkeleton
extends BOWindow
implements ButtonHandler {
    @NotNull
    private final HashMap<String, Consumer<Button>> buttons;
    protected final Text pageNum;
    protected final Button buttonPrevPage;
    protected final Button buttonNextPage;
    protected SwitchView switchView;
    private String resource;
    @Nullable
    private BOWindow parent;

    public AbstractWindowSkeleton(String resource) {
        this(resource, null);
    }

    public AbstractWindowSkeleton(String resource, @Nullable BOWindow parent) {
        super(new ResourceLocation(resource));
        this.resource = resource;
        this.parent = parent;
        this.buttons = new HashMap();
        this.switchView = (SwitchView)this.findPaneOfTypeByID("pages", SwitchView.class);
        if (this.switchView != null) {
            this.buttonNextPage = (Button)this.findPaneOfTypeByID("nextPage", Button.class);
            this.buttonPrevPage = (Button)this.findPaneOfTypeByID("prevPage", Button.class);
            PaneBuilders.singleLineTooltip((MutableComponent)Component.m_237115_((String)"com.minecolonies.core.gui.nextpage"), (Pane)this.buttonNextPage);
            PaneBuilders.singleLineTooltip((MutableComponent)Component.m_237115_((String)"com.minecolonies.core.gui.prevpage"), (Pane)this.buttonPrevPage);
            this.pageNum = (Text)this.findPaneOfTypeByID("pageNum", Text.class);
            this.registerButton("nextPage", () -> this.setPage(true, 1));
            this.registerButton("prevPage", () -> this.setPage(true, -1));
        } else {
            this.buttonNextPage = null;
            this.buttonPrevPage = null;
            this.pageNum = null;
        }
        Network.getNetwork().sendToServer(new OpenGuiWindowTriggerMessage(this.resource));
    }

    public final void registerButton(String id, Runnable action) {
        this.registerButton(id, (Button button) -> action.run());
    }

    public final void registerButton(String id, Consumer<Button> action) {
        this.buttons.put(id, action);
    }

    public void onButtonClicked(@NotNull Button button) {
        if (this.buttons.containsKey(button.getID())) {
            this.buttons.get(button.getID()).accept(button);
            Network.getNetwork().sendToServer(new ClickGuiButtonTriggerMessage(button.getID(), this.resource));
        }
    }

    public final void doNothing(Button ignored) {
    }

    public void setPage(boolean relative, int page) {
        if (this.switchView == null) {
            return;
        }
        int switchPagesSize = this.switchView.getChildrenSize();
        if (switchPagesSize <= 1) {
            this.buttonPrevPage.off();
            this.buttonNextPage.off();
            this.pageNum.off();
            return;
        }
        int curPage = this.switchView.setView(relative, page) + 1;
        this.buttonNextPage.on();
        this.buttonPrevPage.on();
        if (curPage == 1 && !this.switchView.isEndlessScrollingEnabled()) {
            this.buttonPrevPage.off();
        }
        if (curPage == switchPagesSize && !this.switchView.isEndlessScrollingEnabled()) {
            this.buttonNextPage.off();
        }
        if (this.pageNum != null) {
            this.pageNum.setText(Component.m_237113_((String)(curPage + "/" + switchPagesSize)));
        }
    }

    public void close() {
        super.close();
        if (this.parent != null) {
            this.parent.open();
        }
    }
}

