/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.IColony;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;

public class MessageUtils {
    public static MessageBuilder format(String key, Object ... args) {
        return MessageUtils.format((Component)Component.m_237110_((String)key, (Object[])args));
    }

    public static MessageBuilder format(Component component) {
        return new MessageBuilder(component);
    }

    private static MutableComponent getFormattableComponent(Component component) {
        return component.m_6881_();
    }

    public static class MessageBuilder {
        private MutableComponent rootComponent;
        private MutableComponent currentComponent;

        MessageBuilder(Component component) {
            this.currentComponent = MessageUtils.getFormattableComponent(component);
        }

        public MessageBuilder with(Style style) {
            this.currentComponent.m_6270_(style.m_131146_(this.currentComponent.m_7383_()));
            return this;
        }

        public MessageBuilder with(ChatFormatting ... formatting) {
            this.currentComponent.m_6270_(this.currentComponent.m_7383_().m_131152_(formatting));
            return this;
        }

        public MessageBuilder append(String key, Object ... args) {
            return this.append((Component)Component.m_237110_((String)key, (Object[])args));
        }

        public MessageBuilder append(Component component) {
            this.mergeComponents();
            this.currentComponent = MessageUtils.getFormattableComponent(component);
            return this;
        }

        public MutableComponent create() {
            this.mergeComponents();
            return this.rootComponent;
        }

        public void sendTo(Player ... players) {
            this.sendTo(Arrays.asList(players));
        }

        public void sendTo(Collection<Player> players) {
            this.mergeComponents();
            for (Player player : players) {
                player.m_5661_((Component)this.rootComponent, false);
            }
        }

        public MessageBuilderColonyPlayerSelector sendTo(IColony colony) {
            return this.sendTo(colony, false);
        }

        public MessageBuilderColonyPlayerSelector sendTo(IColony colony, boolean alwaysShowColony) {
            this.mergeComponents();
            return new MessageBuilderColonyPlayerSelector(this.rootComponent, colony, alwaysShowColony);
        }

        private void mergeComponents() {
            if (this.rootComponent == null) {
                this.rootComponent = this.currentComponent;
            } else {
                this.rootComponent.m_7220_((Component)this.currentComponent);
            }
            this.currentComponent = null;
        }
    }

    public static class MessageBuilderColonyPlayerSelector {
        private final MutableComponent rootComponent;
        private final IColony colony;
        private final boolean alwaysShowColony;

        public MessageBuilderColonyPlayerSelector(MutableComponent rootComponent, IColony colony, boolean alwaysShowColony) {
            this.rootComponent = rootComponent;
            this.colony = colony;
            this.alwaysShowColony = alwaysShowColony;
        }

        public void forAllPlayers() {
            this.sendInternal(this.colony.getMessagePlayerEntities());
        }

        public void forManagers() {
            this.sendInternal(this.colony.getImportantMessageEntityPlayers());
        }

        private void sendInternal(Collection<Player> players) {
            for (Player player : players) {
                MutableComponent fullComponent = this.rootComponent.m_6881_();
                if (this.alwaysShowColony || !this.colony.isCoordInColony(player.m_9236_(), player.m_20183_())) {
                    fullComponent = Component.m_237113_((String)("[" + this.colony.getName() + "] ")).m_7220_((Component)this.rootComponent);
                }
                player.m_5661_((Component)fullComponent, false);
            }
        }
    }
}

