/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.google.common.collect.Lists;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.CheckedNbtKey;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtils {
    private static final Pattern TEMPLATE_PATH_PATTERN = Pattern.compile("\\[PATH(?::([^=]*)=([^]]*))?]");
    public static final ItemStack EMPTY = ItemStack.f_41583_;
    @NotNull
    public static final Predicate<ItemStack> EMPTY_PREDICATE = ItemStackUtils::isEmpty;
    @NotNull
    public static final Predicate<ItemStack> NOT_EMPTY_PREDICATE = EMPTY_PREDICATE.negate();
    private static final String NBT_TAG_ENCHANT_ID = "id";
    private static final String NBT_TAG_ENCHANT_LEVEL = "lvl";
    private static final int FORTUNE_ENCHANT_ID = 35;
    private static final int SILK_TOUCH_ENCHANT_ID = 33;
    public static HashMap<Item, Set<CheckedNbtKey>> CHECKED_NBT_KEYS = new HashMap();
    public static final Predicate<ItemStack> ISFOOD = stack -> {
        FoodProperties foodProperties = stack.m_41614_() ? stack.getFoodProperties(null) : null;
        return ItemStackUtils.isNotEmpty(stack) && foodProperties != null && foodProperties.m_38744_() > 0 && foodProperties.m_38745_() > 0.0f;
    };
    public static Predicate<ItemStack> IS_SMELTABLE;
    public static Predicate<ItemStack> CAN_EAT;
    public static Predicate<ItemStack> ISCOOKABLE;
    public static final Predicate<ItemStack> IS_COMPOST;

    private ItemStackUtils() {
    }

    @Nullable
    public static Entity getEntityFromEntityInfoOrNull(CompoundTag entityData, Level world) {
        try {
            Entity entity;
            Optional type = EntityType.m_20637_((CompoundTag)entityData);
            if (type.isPresent() && (entity = ((EntityType)type.get()).m_20615_(world)) != null) {
                entity.m_20258_(entityData);
                return entity;
            }
        }
        catch (RuntimeException e) {
            Log.getLogger().info("Couldn't restore entitiy", (Throwable)e);
            return null;
        }
        return null;
    }

    public static List<ItemStorage> getListOfStackForEntityInfo(CompoundTag entityData, Level world, Entity placer) {
        Entity entity;
        if (entityData != null && (entity = ItemStackUtils.getEntityFromEntityInfoOrNull(entityData, world)) != null) {
            if (EntityUtils.isEntityAtPosition(entity, world, placer)) {
                return Collections.emptyList();
            }
            return ItemStackUtils.getListOfStackForEntity(entity, placer);
        }
        return Collections.emptyList();
    }

    public static List<ItemStorage> getListOfStackForEntityInfo(CompoundTag entityData, Level world, AbstractEntityCitizen placer) {
        if (placer != null) {
            return ItemStackUtils.getListOfStackForEntityInfo(entityData, world, (Entity)placer);
        }
        return Lists.newArrayList();
    }

    public static List<ItemStorage> getListOfStackForEntity(Entity entity, Entity placer) {
        if (entity != null) {
            ArrayList<ItemStorage> request = new ArrayList<ItemStorage>();
            if (entity instanceof ItemFrame) {
                ItemStack stack2 = ((ItemFrame)entity).m_31822_();
                if (!ItemStackUtils.isEmpty(stack2)) {
                    ItemStackUtils.setSize(stack2, 1);
                    request.add(new ItemStorage(stack2));
                }
                request.add(new ItemStorage(new ItemStack((ItemLike)Items.f_42617_, 1)));
            } else if (entity instanceof ArmorStand) {
                request.add(new ItemStorage(entity.getPickedResult((HitResult)new EntityHitResult(placer))));
                entity.m_6168_().forEach(item -> request.add(new ItemStorage((ItemStack)item)));
                entity.m_6167_().forEach(item -> request.add(new ItemStorage((ItemStack)item)));
            }
            return request.stream().filter(stack -> !stack.getItemStack().m_41619_()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static boolean hasToolLevel(@Nullable ItemStack stack, IToolType toolType, int minimalLevel, int maximumLevel) {
        if (ItemStackUtils.isEmpty(stack)) {
            return false;
        }
        int level = Compatibility.isTinkersWeapon(stack) ? Compatibility.getToolLevel(stack) : ItemStackUtils.getMiningLevel(stack, toolType);
        return ItemStackUtils.isTool(stack, toolType) && ItemStackUtils.verifyToolLevel(stack, level, minimalLevel, maximumLevel);
    }

    public static boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack.m_41619_();
    }

    public static boolean isNotEmpty(@Nullable ItemStack stack) {
        return !ItemStackUtils.isEmpty(stack);
    }

    public static int getMiningLevel(@Nullable ItemStack stack, @Nullable IToolType toolType) {
        if (toolType == ToolType.NONE) {
            return stack == null ? 0 : 1;
        }
        if (!Compatibility.getMiningLevelCompatibility(stack, toolType.toString())) {
            return -1;
        }
        if (!ItemStackUtils.isTool(stack, toolType)) {
            return -1;
        }
        if (toolType == ToolType.SWORD && Compatibility.isTinkersWeapon(stack)) {
            return Compatibility.getToolLevel(stack);
        }
        if (Compatibility.isTinkersTool(stack, toolType)) {
            return Compatibility.getToolLevel(stack);
        }
        if (ToolType.HELMET.equals(toolType) || ToolType.BOOTS.equals(toolType) || ToolType.CHESTPLATE.equals(toolType) || ToolType.LEGGINGS.equals(toolType)) {
            Item item = stack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                return ItemStackUtils.getArmorLevel(armorItem.m_40401_());
            }
        } else {
            Item item = stack.m_41720_();
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                return tieredItem.m_43314_().m_6604_();
            }
            if (toolType.equals(ToolType.FISHINGROD)) {
                return ItemStackUtils.getFishingRodLevel(stack);
            }
            if (toolType.equals(ToolType.SHEARS)) {
                return 0;
            }
            if (!toolType.hasVariableMaterials()) {
                return 1;
            }
        }
        return -1;
    }

    public static boolean isBetterTool(ItemStack stack1, ItemStack stack2) {
        for (ToolType toolType : ToolType.values()) {
            if (!ItemStackUtils.isTool(stack1, toolType) || !ItemStackUtils.isTool(stack2, toolType) || ItemStackUtils.getMiningLevel(stack1, toolType) <= ItemStackUtils.getMiningLevel(stack2, toolType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTool(@Nullable ItemStack itemStack, IToolType toolType) {
        if (ItemStackUtils.isEmpty(itemStack)) {
            return false;
        }
        if (ToolType.AXE.equals(toolType) && itemStack.canPerformAction(ToolActions.AXE_DIG)) {
            return true;
        }
        if (ToolType.SHOVEL.equals(toolType) && itemStack.canPerformAction(ToolActions.SHOVEL_DIG)) {
            return true;
        }
        if (ToolType.PICKAXE.equals(toolType) && itemStack.canPerformAction(ToolActions.PICKAXE_DIG)) {
            return true;
        }
        if (ToolType.HOE.equals(toolType)) {
            for (ToolAction action : ToolActions.DEFAULT_HOE_ACTIONS) {
                if (itemStack.canPerformAction(action)) continue;
                return false;
            }
            return true;
        }
        if (ToolType.BOW.equals(toolType)) {
            return itemStack.m_41720_() instanceof BowItem;
        }
        if (ToolType.SWORD.equals(toolType)) {
            return itemStack.canPerformAction(ToolActions.SWORD_SWEEP) || Compatibility.isTinkersWeapon(itemStack);
        }
        if (ToolType.FISHINGROD.equals(toolType) && itemStack.canPerformAction(ToolActions.FISHING_ROD_CAST)) {
            return true;
        }
        if (ToolType.SHEARS.equals(toolType) && itemStack.canPerformAction(ToolActions.SHEARS_DIG) && itemStack.canPerformAction(ToolActions.SHEARS_HARVEST)) {
            return true;
        }
        if (ToolType.HELMET.equals(toolType)) {
            ArmorItem armor;
            Item item = itemStack.m_41720_();
            return item instanceof ArmorItem && EquipmentSlot.HEAD.equals((Object)(armor = (ArmorItem)item).m_40402_());
        }
        if (ToolType.LEGGINGS.equals(toolType)) {
            ArmorItem armor;
            Item item = itemStack.m_41720_();
            return item instanceof ArmorItem && EquipmentSlot.LEGS.equals((Object)(armor = (ArmorItem)item).m_40402_());
        }
        if (ToolType.CHESTPLATE.equals(toolType)) {
            ArmorItem armor;
            Item item = itemStack.m_41720_();
            return item instanceof ArmorItem && EquipmentSlot.CHEST.equals((Object)(armor = (ArmorItem)item).m_40402_());
        }
        if (ToolType.BOOTS.equals(toolType)) {
            ArmorItem armor;
            Item item = itemStack.m_41720_();
            return item instanceof ArmorItem && EquipmentSlot.FEET.equals((Object)(armor = (ArmorItem)item).m_40402_());
        }
        if (ToolType.SHIELD.equals(toolType)) {
            return itemStack.m_41720_() instanceof ShieldItem;
        }
        if (ToolType.FLINT_N_STEEL.equals(toolType)) {
            return itemStack.m_41720_() instanceof FlintAndSteelItem;
        }
        return false;
    }

    public static boolean verifyToolLevel(@NotNull ItemStack itemStack, int toolLevel, int minimalLevel, int maximumLevel) {
        if (toolLevel < minimalLevel) {
            return false;
        }
        return toolLevel + ItemStackUtils.getMaxEnchantmentLevel(itemStack) <= maximumLevel;
    }

    private static int getArmorLevel(ArmorMaterial material) {
        int damageReductionAmount = material.m_7366_(ArmorItem.Type.CHESTPLATE);
        if (damageReductionAmount <= ArmorMaterials.LEATHER.m_7366_(ArmorItem.Type.CHESTPLATE)) {
            return 0;
        }
        if (damageReductionAmount <= ArmorMaterials.GOLD.m_7366_(ArmorItem.Type.CHESTPLATE) && material != ArmorMaterials.CHAIN) {
            return 1;
        }
        if (damageReductionAmount <= ArmorMaterials.CHAIN.m_7366_(ArmorItem.Type.CHESTPLATE)) {
            return 2;
        }
        if (damageReductionAmount <= ArmorMaterials.IRON.m_7366_(ArmorItem.Type.CHESTPLATE)) {
            return 3;
        }
        if (damageReductionAmount <= ArmorMaterials.DIAMOND.m_7366_(ArmorItem.Type.CHESTPLATE)) {
            return 4;
        }
        return 5;
    }

    private static int getFishingRodLevel(ItemStack itemStack) {
        if (itemStack.m_41720_() == Items.f_42523_) {
            return 1;
        }
        if (!itemStack.m_41763_()) {
            return 5;
        }
        int rodDurability = itemStack.m_41776_();
        if (rodDurability <= Tiers.WOOD.m_6609_() + (Integer)MinecoloniesAPIProxy.getInstance().getConfig().getServer().fishingRodDurabilityAdjustT1.get()) {
            return 1;
        }
        if (rodDurability <= Tiers.IRON.m_6609_() + (Integer)MinecoloniesAPIProxy.getInstance().getConfig().getServer().fishingRodDurabilityAdjustT2.get()) {
            return 2;
        }
        return 3;
    }

    public static int getMaxEnchantmentLevel(ItemStack itemStack) {
        ListTag ListNBT;
        if (itemStack == null) {
            return 0;
        }
        short maxLevel = 0;
        if (itemStack != null && (ListNBT = itemStack.m_41785_()) != null) {
            for (int j = 0; j < ListNBT.size(); ++j) {
                short level = ListNBT.m_128728_(j).m_128448_(NBT_TAG_ENCHANT_LEVEL);
                maxLevel = level > maxLevel ? level : maxLevel;
            }
        }
        return Math.max(maxLevel - 1, 0);
    }

    public static int getFortuneOf(@Nullable ItemStack tool) {
        if (tool == null) {
            return 0;
        }
        int fortune = 0;
        if (tool.m_41793_()) {
            ListTag t = tool.m_41785_();
            for (int i = 0; i < t.size(); ++i) {
                short id = t.m_128728_(i).m_128448_(NBT_TAG_ENCHANT_ID);
                if (id != 35) continue;
                fortune = t.m_128728_(i).m_128448_(NBT_TAG_ENCHANT_LEVEL);
            }
        }
        return fortune;
    }

    public static boolean doesItemServeAsWeapon(@NotNull ItemStack stack) {
        return stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof DiggerItem || Compatibility.isTinkersWeapon(stack);
    }

    public static String swapArmorGrade(int toolGrade) {
        switch (toolGrade) {
            case 0: {
                return "Leather";
            }
            case 1: {
                return "Gold";
            }
            case 2: {
                return "Chain";
            }
            case 3: {
                return "Iron";
            }
            case 4: {
                return "Diamond";
            }
        }
        return "Better than Diamond";
    }

    public static String swapToolGrade(int toolGrade) {
        switch (toolGrade) {
            case 0: {
                return "Wood or Gold";
            }
            case 1: {
                return "Stone";
            }
            case 2: {
                return "Iron";
            }
            case 3: {
                return "Diamond";
            }
        }
        return "Better than Diamond";
    }

    @NotNull
    public static Boolean areItemStacksMergable(ItemStack existingStack, ItemStack mergingStack) {
        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(existingStack, mergingStack).booleanValue()) {
            return false;
        }
        return existingStack.m_41741_() >= ItemStackUtils.getSize(existingStack) + ItemStackUtils.getSize(mergingStack);
    }

    @NotNull
    public static Boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, true, true);
    }

    public static int getSize(@NotNull ItemStack stack) {
        return stack.m_41613_();
    }

    public static int getDurability(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return 0;
        }
        return stack.m_41776_() - stack.m_41773_();
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, matchDamage, matchNBT, false);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT, boolean min) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, matchDamage, matchNBT, false, false);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT, boolean min, boolean matchNBTExactly) {
        if (ItemStackUtils.isEmpty(itemStack1) && ItemStackUtils.isEmpty(itemStack2)) {
            return true;
        }
        if (ItemStackUtils.isEmpty(itemStack1) != ItemStackUtils.isEmpty(itemStack2)) {
            return false;
        }
        if (!(itemStack1.m_41720_() != itemStack2.m_41720_() || matchDamage && itemStack1.m_41773_() != itemStack2.m_41773_())) {
            if (!matchNBT) {
                return true;
            }
            if (min && itemStack1.m_41613_() > itemStack2.m_41613_()) {
                return false;
            }
            if (itemStack1.m_41782_() || itemStack2.m_41782_()) {
                if (matchNBTExactly) {
                    return Objects.equals(itemStack1.m_41783_(), itemStack2.m_41783_());
                }
                Set checkedKeys = CHECKED_NBT_KEYS.getOrDefault(itemStack1.m_41720_(), null);
                if (checkedKeys == null) {
                    return itemStack1.m_41782_() && itemStack2.m_41782_() && itemStack1.m_41783_().equals((Object)itemStack2.m_41783_());
                }
                if (itemStack1.m_41782_() != itemStack2.m_41782_() && !checkedKeys.isEmpty()) {
                    return false;
                }
                if (checkedKeys.isEmpty()) {
                    return true;
                }
                CompoundTag nbt1 = itemStack1.m_41783_();
                CompoundTag nbt2 = itemStack2.m_41783_();
                for (CheckedNbtKey key : checkedKeys) {
                    if (key.matches(nbt1, nbt2)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean compareItemStackListIgnoreStackSize(List<ItemStack> stacks, ItemStack stack) {
        return ItemStackUtils.compareItemStackListIgnoreStackSize(stacks, stack, true, true);
    }

    public static boolean compareItemStackListIgnoreStackSize(List<ItemStack> stacks, ItemStack stack, boolean matchDamage, boolean matchNBT) {
        for (ItemStack tempStack : stacks) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(tempStack, stack, matchDamage, matchNBT)) continue;
            return true;
        }
        return false;
    }

    public static void setSize(@NotNull ItemStack stack, int size) {
        stack.m_41764_(size);
    }

    public static void changeSize(@NotNull ItemStack stack, int amount) {
        stack.m_41764_(stack.m_41613_() + amount);
    }

    @NotNull
    public static ItemStack deserializeFromNBT(@NotNull CompoundTag compound) {
        return ItemStack.m_41712_((CompoundTag)compound);
    }

    public static boolean isStackSapling(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return false;
        }
        return stack.m_204117_(ItemTags.f_13180_) || stack.m_204117_(ModTags.fungi) || Compatibility.isDynamicTreeSapling(stack);
    }

    public static boolean hasSmeltableInFurnaceAndNoFuel(FurnaceBlockEntity entity) {
        return !ItemStackUtils.isEmpty(entity.m_8020_(0)) && ItemStackUtils.isEmpty(entity.m_8020_(1));
    }

    public static boolean hasNeitherFuelNorSmeltAble(FurnaceBlockEntity entity) {
        return ItemStackUtils.isEmpty(entity.m_8020_(0)) && ItemStackUtils.isEmpty(entity.m_8020_(1));
    }

    public static boolean hasFuelInFurnaceAndNoSmeltable(FurnaceBlockEntity entity) {
        return ItemStackUtils.isEmpty(entity.m_8020_(0)) && !ItemStackUtils.isEmpty(entity.m_8020_(1));
    }

    public static boolean hasBrewableAndNoFuel(BrewingStandBlockEntity entity) {
        return !ItemStackUtils.isEmpty(entity.m_8020_(3)) && ItemStackUtils.isEmpty(entity.m_8020_(4));
    }

    public static boolean hasNeitherFuelNorBrewable(BrewingStandBlockEntity entity) {
        return ItemStackUtils.isEmpty(entity.m_8020_(3)) && ItemStackUtils.isEmpty(entity.m_8020_(4));
    }

    public static boolean hasFuelAndNoBrewable(BrewingStandBlockEntity entity) {
        return ItemStackUtils.isEmpty(entity.m_8020_(3)) && !ItemStackUtils.isEmpty(entity.m_8020_(4));
    }

    public static ItemStack idToItemStack(String itemData) {
        String itemId = itemData;
        int tagIndex = itemId.indexOf("{");
        String tag = tagIndex > 0 ? itemId.substring(tagIndex) : null;
        itemId = tagIndex > 0 ? itemId.substring(0, tagIndex) : itemId;
        String[] split = itemId.split(":");
        if (split.length != 2) {
            if (split.length == 1) {
                String[] tempArray = new String[]{"minecraft", split[0]};
                split = tempArray;
            } else {
                Log.getLogger().error("Unable to parse item definition: " + itemData);
            }
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1]));
        ItemStack stack = new ItemStack((ItemLike)item);
        if (tag != null) {
            try {
                stack.m_41751_(TagParser.m_129359_((String)tag));
            }
            catch (CommandSyntaxException e1) {
                Log.getLogger().error("Unable to parse item definition: " + itemData);
            }
        }
        if (stack.m_41619_()) {
            Log.getLogger().warn("Parsed item definition returned empty: " + itemData);
        }
        return stack;
    }

    @NotNull
    public static Tuple<Boolean, String> parseIdTemplate(@Nullable String value, @NotNull ResourceLocation baseItemId) {
        if (value == null) {
            return new Tuple<Boolean, Object>(false, null);
        }
        int nbtIndex = value.indexOf(123);
        String itemId = nbtIndex < 0 ? value : value.substring(0, nbtIndex);
        itemId = itemId.replace("[NS]", baseItemId.m_135827_());
        itemId = TEMPLATE_PATH_PATTERN.matcher(itemId).replaceAll(m -> {
            if (m.group(1) != null && m.group(2) != null) {
                return baseItemId.m_135815_().replace(m.group(1), m.group(2));
            }
            return baseItemId.m_135815_();
        });
        return new Tuple<Boolean, CallSite>(ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemId)), (CallSite)((Object)(itemId + (nbtIndex >= 0 ? value.substring(nbtIndex) : ""))));
    }

    public static boolean hasTag(@NotNull ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128440_() > (stack.m_41763_() ? 1 : 0);
    }

    public static Set<ItemStack> allItemsPlusInventory(@NotNull Player player) {
        HashSet<ItemStorage> allItems = new HashSet<ItemStorage>(IColonyManager.getInstance().getCompatibilityManager().getSetOfAllItems());
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_()) continue;
            ItemStack pristine = stack.m_41777_();
            pristine.m_41764_(1);
            if (stack.m_41763_() && stack.m_41768_()) {
                pristine.m_41721_(0);
            }
            allItems.add(new ItemStorage(pristine, true));
        }
        return allItems.stream().map(ItemStorage::getItemStack).collect(Collectors.toSet());
    }

    static {
        IS_COMPOST = stack -> !stack.m_41619_() && stack.m_41720_() == ModItems.compost;
    }
}

