/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.compatibility.newstruct.BlueprintMapping;
import com.minecolonies.api.inventory.api.CombinedItemHandler;
import com.minecolonies.api.inventory.container.ContainerBuildingInventory;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.ITickable;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityColonyBuilding
extends AbstractTileEntityColonyBuilding
implements ITickable {
    private static final String TAG_COLONY = "colony";
    private static final String TAG_MIRROR = "mirror";
    private static final String TAG_STYLE = "style";
    private static final String TAG_PACK = "pack";
    private static final String TAG_PATH = "path";
    private int colonyId = 0;
    private IColony colony;
    private IBuilding building;
    private boolean mirror;
    private String packMeta = "";
    private String path = "";
    public ResourceLocation registryName;
    private LazyOptional<CombinedItemHandler> combinedInv;
    private Future<Blueprint> pendingBlueprintFuture = null;

    public TileEntityColonyBuilding(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends AbstractTileEntityColonyBuilding>)((BlockEntityType)MinecoloniesTileEntities.BUILDING.get()), pos, state);
    }

    public TileEntityColonyBuilding(BlockEntityType<? extends AbstractTileEntityColonyBuilding> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int getColonyId() {
        return this.colonyId;
    }

    @Override
    public IColony getColony() {
        if (this.colony == null) {
            this.updateColonyReferences();
        }
        return this.colony;
    }

    private void updateColonyReferences() {
        if (this.colony == null && this.m_58904_() != null) {
            this.colony = this.colonyId == 0 ? IColonyManager.getInstance().getColonyByPosFromWorld(this.m_58904_(), this.m_58899_()) : IColonyManager.getInstance().getColonyByWorld(this.colonyId, this.m_58904_());
            if (this.colony != null || !this.m_58904_().f_46443_) {
                // empty if block
            }
        }
        if (this.building == null && this.colony != null) {
            this.building = this.colony.getBuildingManager().getBuilding(this.getPosition());
            if (!(this.building == null || this.m_58904_() != null && this.m_58904_().f_46443_)) {
                this.registryName = this.building.getBuildingType().getRegistryName();
                this.building.setTileEntity(this);
            }
        }
    }

    @Override
    public BlockPos getPosition() {
        return this.f_58858_;
    }

    @Override
    @Nullable
    public BlockPos getPositionOfChestWithItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        Predicate<ItemStack> notEmptyPredicate = itemStackSelectionPredicate.and(ItemStackUtils.NOT_EMPTY_PREDICATE);
        @Nullable IBuilding theBuilding = this.getBuilding();
        if (theBuilding != null) {
            for (BlockPos pos : theBuilding.getContainers()) {
                BlockEntity entity;
                if (!WorldUtil.isBlockLoaded((LevelAccessor)this.f_58857_, pos) || !((entity = this.m_58904_().m_7702_(pos)) instanceof AbstractTileEntityRack ? ((AbstractTileEntityRack)entity).hasItemStack(notEmptyPredicate) : TileEntityColonyBuilding.isInTileEntity((ICapabilityProvider)entity, notEmptyPredicate))) continue;
                return pos;
            }
        }
        return null;
    }

    @Override
    public void setColony(IColony c) {
        this.colony = c;
        this.colonyId = c.getID();
        this.m_6596_();
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (this.building != null) {
            this.building.markDirty();
        }
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag compound = packet.m_131708_();
        this.colonyId = compound.m_128451_(TAG_COLONY);
        super.onDataPacket(net, packet);
    }

    public void onLoad() {
        if (this.building != null) {
            this.building.setTileEntity(null);
        }
    }

    @Override
    public IBuilding getBuilding() {
        if (this.building == null) {
            this.updateColonyReferences();
        }
        return this.building;
    }

    @Override
    public void setBuilding(IBuilding b) {
        this.building = b;
    }

    @Override
    @NotNull
    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Override
    public IBuildingView getBuildingView() {
        IColonyView c = IColonyManager.getInstance().getColonyView(this.colonyId, (ResourceKey<Level>)this.f_58857_.m_46472_());
        return c == null ? null : c.getBuilding(this.getPosition());
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compound) {
        Object path;
        String packName;
        super.m_142466_(compound);
        if (compound.m_128441_(TAG_COLONY)) {
            this.colonyId = compound.m_128451_(TAG_COLONY);
        }
        this.mirror = compound.m_128471_(TAG_MIRROR);
        if (compound.m_128441_(TAG_STYLE) && !compound.m_128461_(TAG_STYLE).isEmpty()) {
            packName = BlueprintMapping.getStyleMapping(compound.m_128461_(TAG_STYLE));
            if (this.getSchematicName().isEmpty()) {
                path = null;
            } else {
                String level = this.getSchematicName().substring(this.getSchematicName().length() - 1);
                path = BlueprintMapping.getPathMapping(compound.m_128461_(TAG_STYLE), this.getSchematicName().substring(0, this.getSchematicName().length() - 1)) + level + ".blueprint";
            }
        } else {
            packName = compound.m_128461_(TAG_PACK);
            path = compound.m_128461_(TAG_PATH);
        }
        if (packName == null || packName.isEmpty()) {
            ArrayList tags = new ArrayList(this.getPositionedTags().getOrDefault(BlockPos.f_121853_, new ArrayList()));
            if (!tags.isEmpty()) {
                tags.remove("deactivated");
                if (!tags.isEmpty()) {
                    packName = BlueprintMapping.getStyleMapping((String)tags.get(0));
                    if (path == null || ((String)path).isEmpty()) {
                        path = BlueprintMapping.getPathMapping((String)tags.get(0), ((AbstractBlockHut)this.m_58900_().m_60734_()).getBlueprintName()) + "1.blueprint";
                    }
                }
            } else if (StructurePacks.selectedPack != null) {
                packName = StructurePacks.selectedPack.getName();
            }
        }
        if (path == null || ((String)path).isEmpty() || ((String)path).contains("null")) {
            path = BlueprintMapping.getPathMapping("", ((AbstractBlockHut)this.m_58900_().m_60734_()).getBlueprintName()) + "1.blueprint";
        }
        if (!((String)path).endsWith(".blueprint")) {
            path = (String)path + ".blueprint";
        }
        this.packMeta = packName;
        this.path = path;
        if (compound.m_128441_("type")) {
            this.registryName = new ResourceLocation(compound.m_128461_("type"));
        }
        this.buildingPos = this.f_58858_;
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_(TAG_COLONY, this.colonyId);
        compound.m_128379_(TAG_MIRROR, this.mirror);
        compound.m_128359_(TAG_PACK, this.packMeta == null ? "" : this.packMeta);
        compound.m_128359_(TAG_PATH, this.path == null ? "" : this.path);
        if (this.registryName != null) {
            compound.m_128359_("type", this.registryName.toString());
        }
    }

    @Override
    public void tick() {
        IColony tempColony;
        if (this.combinedInv != null) {
            this.combinedInv.invalidate();
            this.combinedInv = null;
        }
        if (!this.m_58904_().f_46443_ && this.colonyId == 0 && (tempColony = IColonyManager.getInstance().getColonyByPosFromWorld(this.m_58904_(), this.getPosition())) != null) {
            this.colonyId = tempColony.getID();
        }
        if (!this.m_58904_().f_46443_ && this.colonyId != 0 && this.colony == null) {
            this.updateColonyReferences();
        }
        if (this.pendingBlueprintFuture != null && this.pendingBlueprintFuture.isDone()) {
            try {
                this.processBlueprint(this.pendingBlueprintFuture.get());
                this.pendingBlueprintFuture = null;
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isUsableByPlayer(@NotNull Player player) {
        return this.hasAccessPermission(player);
    }

    @Override
    public boolean hasAccessPermission(Player player) {
        return this.building == null || this.building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS);
    }

    @Override
    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    @Override
    public boolean isMirrored() {
        return this.mirror;
    }

    @Override
    public StructurePackMeta getStructurePack() {
        return StructurePacks.getStructurePack((String)this.packMeta);
    }

    @Override
    public void setStructurePack(StructurePackMeta style) {
        this.packMeta = style.getName();
    }

    @Override
    public void setBlueprintPath(String path) {
        this.path = path;
    }

    public void setPackName(String packName) {
        this.packMeta = packName;
    }

    public String getPackName() {
        return this.packMeta;
    }

    @Override
    public String getBlueprintPath() {
        return this.path;
    }

    @Override
    public ResourceLocation getBuildingName() {
        if (this.registryName != null && !this.registryName.m_135815_().isEmpty()) {
            return this.registryName;
        }
        return this.m_58900_().m_60734_() instanceof AbstractBlockHut ? ((AbstractBlockHut)this.m_58900_().m_60734_()).getBuildingEntry().getRegistryName() : null;
    }

    @Override
    public void updateBlockState() {
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (!this.f_58859_ && capability == ForgeCapabilities.ITEM_HANDLER && this.getBuilding() != null) {
            if (this.combinedInv == null) {
                LinkedHashSet<IItemHandlerModifiable> handlers = new LinkedHashSet<IItemHandlerModifiable>();
                Level world = this.colony.getWorld();
                if (world != null) {
                    for (BlockPos pos : this.building.getContainers()) {
                        BlockEntity te;
                        if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || pos.equals((Object)this.f_58858_) || (te = world.m_7702_(pos)) == null) continue;
                        if (te instanceof AbstractTileEntityRack) {
                            handlers.add(((AbstractTileEntityRack)te).getInventory());
                            ((AbstractTileEntityRack)te).setBuildingPos(this.m_58899_());
                            continue;
                        }
                        this.building.removeContainerPosition(pos);
                    }
                }
                handlers.add(this.getInventory());
                this.combinedInv = LazyOptional.of(() -> new CombinedItemHandler(this.building.getSchematicName(), handlers.toArray(new IItemHandlerModifiable[0])));
            }
            return this.combinedInv;
        }
        return super.getCapability(capability, side);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new ContainerBuildingInventory(id, inv, this.colonyId, this.m_58899_());
    }

    public void reactivate() {
        Object blueprintPath;
        String packName;
        ArrayList tags = new ArrayList(this.getPositionedTags().get(BlockPos.f_121853_));
        tags.remove("deactivated");
        if (tags.isEmpty()) {
            this.pendingBlueprintFuture = StructurePacks.getBlueprintFuture((String)this.packMeta, (String)this.path);
            return;
        }
        String tagName = (String)tags.get(0);
        if (tagName.contains("/")) {
            String[] split = tagName.split("/");
            packName = split[0];
            blueprintPath = tagName.replace(packName, "");
        } else {
            String level = this.getSchematicName().substring(this.getSchematicName().length() - 1);
            packName = BlueprintMapping.getStyleMapping(tagName);
            blueprintPath = BlueprintMapping.getPathMapping(tagName, this.getSchematicName().substring(0, this.getSchematicName().length() - 1)) + level + ".blueprint";
        }
        if (!StructurePacks.hasPack((String)packName)) {
            this.pendingBlueprintFuture = StructurePacks.getBlueprintFuture((String)this.packMeta, (String)this.path);
            return;
        }
        this.setStructurePack(StructurePacks.getStructurePack((String)packName));
        this.pendingBlueprintFuture = StructurePacks.getBlueprintFuture((String)packName, (String)blueprintPath);
    }

    private void processBlueprint(Blueprint blueprint) {
        if (blueprint == null) {
            Log.getLogger().error("Invalid building details for reactivation");
            return;
        }
        BlockState structureState = blueprint.m_8055_(blueprint.getPrimaryBlockOffset());
        if (structureState != null) {
            int worldRotation;
            if (!(structureState.m_60734_() instanceof AbstractBlockHut) || !(this.f_58857_.m_8055_(this.getPosition()).m_60734_() instanceof AbstractBlockHut)) {
                Log.getLogger().error(String.format("Schematic %s doesn't have a correct Primary Offset", blueprint.getName()));
                return;
            }
            int structureRotation = ((Direction)structureState.m_61143_((Property)AbstractBlockHut.FACING)).m_122416_();
            int rotation = structureRotation <= (worldRotation = ((Direction)this.f_58857_.m_8055_(this.getPosition()).m_61143_((Property)AbstractBlockHut.FACING)).m_122416_()) ? worldRotation - structureRotation : 4 + worldRotation - structureRotation;
            blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(rotation), this.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE, this.f_58857_);
            BlockInfo info = blueprint.getBlockInfoAsMap().getOrDefault(blueprint.getPrimaryBlockOffset(), null);
            if (info.getTileEntityData() != null) {
                CompoundTag teCompound = info.getTileEntityData().m_6426_();
                CompoundTag tagData = teCompound.m_128469_("blueprintDataProvider");
                tagData.m_128359_(TAG_PACK, blueprint.getPackName());
                String location = StructurePacks.getStructurePack((String)blueprint.getPackName()).getSubPath(blueprint.getFilePath().resolve(blueprint.getFileName()));
                tagData.m_128359_("name", location);
                this.readSchematicDataFromNBT(teCompound);
            }
        }
    }
}

