/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.mobs;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.colonyEvents.IColonyCampFireRaidEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.enchants.ModEnchants;
import com.minecolonies.api.entity.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.entity.CustomGoalSelector;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.combat.CombatAIStates;
import com.minecolonies.api.entity.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.combat.threat.ThreatTable;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.PathingStuckHandler;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.api.items.IChiefSwordItem;
import com.minecolonies.api.sounds.RaiderSounds;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.RaiderConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityRaiderMob
extends AbstractFastMinecoloniesEntity
implements IThreatTableEntity,
Enemy {
    private static final double TEAM_DIFFICULTY = 2.0;
    private static final float HP_PERCENT_PER_DMG = 0.03f;
    private static final int MAX_SCALED_DAMAGE = 7;
    private static final float MIN_THORNS_DAMAGE = 30.0f;
    private static final int THORNS_CHANCE = 5;
    private static final int COLONY_SET_RAIDED_CHANCE = 20;
    private AbstractAdvancedPathNavigate newNavigator;
    private IColony colony;
    private int currentCount = 0;
    private long worldTimeAtSpawn = 0L;
    private int currentTick = 0;
    private int stuckCounter = 1;
    private int ladderCounter = 0;
    private int eventID = 0;
    private boolean isRegistered = false;
    private int invulTime = 40;
    private int envDmgCooldown = 0;
    private int envDamageInterval = 5;
    private boolean envDamageImmunity = false;
    private boolean tempEnvDamageImmunity = true;
    private int collisionCounter = 0;
    private static final int COLL_THRESHOLD = 50;
    private static final String RAID_TEAM = "RAIDERS_TEAM";
    private double difficulty = 1.0;
    private ThreatTable threatTable = new ThreatTable<AbstractEntityRaiderMob>(this);
    private ChunkPos lastChunkPos = null;
    private ITickRateStateMachine<IState> ai = new TickRateStateMachine<CombatAIStates>(CombatAIStates.NO_TARGET, e -> Log.getLogger().warn(e));

    public AbstractEntityRaiderMob(EntityType<? extends AbstractEntityRaiderMob> type, Level world) {
        super(type, world);
        this.worldTimeAtSpawn = world.m_46467_();
        this.m_21530_();
        this.f_21345_ = new CustomGoalSelector(this.f_21345_);
        this.f_21346_ = new CustomGoalSelector(this.f_21346_);
        this.f_21364_ = 5;
        IMinecoloniesAPI.getInstance().getMobAIRegistry().applyToMob(this);
        this.m_20331_(true);
        RaiderMobUtils.setEquipment(this);
    }

    @Override
    public void m_6138_() {
        if (this.collisionCounter > 50) {
            return;
        }
        super.m_6138_();
    }

    public void m_7334_(@NotNull Entity entityIn) {
        if (this.invulTime > 0) {
            return;
        }
        if ((this.collisionCounter += 3) > 50) {
            if (this.collisionCounter > 150) {
                this.collisionCounter = 0;
            }
            return;
        }
        super.m_7334_(entityIn);
    }

    public void m_8032_() {
        super.m_8032_();
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null && this.m_9236_().f_46441_.m_188503_(100) <= 1) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.shouldDespawn() || this.m_9236_() != null && this.m_9236_().isAreaLoaded(this.m_20183_(), 3) && this.getColony() == null;
    }

    public abstract RaiderType getRaiderType();

    private boolean shouldDespawn() {
        return this.worldTimeAtSpawn != 0L && this.m_9236_().m_46467_() - this.worldTimeAtSpawn >= 36000L;
    }

    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.newNavigator == null) {
            this.newNavigator = IPathNavigateRegistry.getInstance().getNavigateFor((Mob)this);
            this.f_21344_ = this.newNavigator;
            this.newNavigator.m_7008_(true);
            this.newNavigator.setSwimSpeedFactor(this.getSwimSpeedFactor());
            this.newNavigator.getPathingOptions().setEnterDoors(true);
            this.newNavigator.getPathingOptions().withDropCost(1.3);
            this.newNavigator.getPathingOptions().setPassDanger(true);
            PathingStuckHandler stuckHandler = PathingStuckHandler.createStuckHandler().withTakeDamageOnStuck(0.4f).withBuildLeafBridges().withChanceToByPassMovingAway(0.2).withPlaceLadders();
            if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().doBarbariansBreakThroughWalls.get()).booleanValue()) {
                stuckHandler.withBlockBreaks();
                stuckHandler.withCompleteStuckBlockBreak(6);
            }
            this.newNavigator.setStuckHandler(stuckHandler);
        }
        return this.newNavigator;
    }

    public abstract double getSwimSpeedFactor();

    public int getStuckCounter() {
        return this.stuckCounter;
    }

    public void setStuckCounter(int stuckCounter) {
        this.stuckCounter = stuckCounter;
    }

    public int getLadderCounter() {
        return this.ladderCounter;
    }

    public void setLadderCounter(int ladderCounter) {
        this.ladderCounter = ladderCounter;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return RaiderSounds.raiderSounds.get((Object)this.getRaiderType()).get((Object)RaiderSounds.RaiderSoundTypes.HURT);
    }

    protected SoundEvent m_5592_() {
        return RaiderSounds.raiderSounds.get((Object)this.getRaiderType()).get((Object)RaiderSounds.RaiderSoundTypes.DEATH);
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return RaiderSounds.raiderSounds.get((Object)this.getRaiderType()).get((Object)RaiderSounds.RaiderSoundTypes.SAY);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128356_("time", this.worldTimeAtSpawn);
        compound.m_128405_("stuck", this.stuckCounter);
        compound.m_128405_("ladder", this.ladderCounter);
        compound.m_128405_("colony", this.colony == null ? 0 : this.colony.getID());
        compound.m_128405_("mc_event_id", this.eventID);
        super.m_7380_(compound);
    }

    @Override
    @javax.annotation.Nullable
    public Entity changeDimension(@NotNull ServerLevel serverWorld, @NotNull ITeleporter teleporter) {
        return null;
    }

    public void m_7378_(CompoundTag compound) {
        int colonyId;
        this.worldTimeAtSpawn = compound.m_128454_("time");
        this.stuckCounter = compound.m_128451_("stuck");
        this.ladderCounter = compound.m_128451_("ladder");
        this.eventID = compound.m_128451_("mc_event_id");
        if (compound.m_128441_("colony") && (colonyId = compound.m_128451_("colony")) != 0) {
            this.setColony(IColonyManager.getInstance().getColonyByWorld(colonyId, this.m_9236_()));
        }
        if (this.colony == null || this.eventID == 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_7378_(compound);
    }

    public void m_8107_() {
        if (!this.m_6084_()) {
            return;
        }
        this.m_21203_();
        if (this.invulTime > 0) {
            --this.invulTime;
        } else {
            this.m_20331_(false);
        }
        if (this.collisionCounter > 0) {
            --this.collisionCounter;
        }
        if (this.m_9236_().f_46443_) {
            super.m_8107_();
            return;
        }
        if (this.currentTick % (this.f_19796_.m_188503_(20) + 1) == 0) {
            --this.envDmgCooldown;
            if (this.worldTimeAtSpawn == 0L) {
                this.worldTimeAtSpawn = this.m_9236_().m_46467_();
            }
            if (this.m_146902_() != this.lastChunkPos) {
                this.lastChunkPos = this.m_146902_();
                if (this.f_19796_.m_188503_(20) <= 0) {
                    this.onEnterChunk(this.lastChunkPos);
                }
            }
            if (this.shouldDespawn()) {
                this.m_6667_(this.m_9236_().m_269111_().m_269079_(DamageSourceKeys.DESPAWN));
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (!this.isRegistered) {
                this.registerWithColony();
            }
            if (this.currentCount <= 0) {
                this.currentCount = 960;
                if (!this.m_21205_().m_41619_() && RaiderConstants.SPEED_EFFECT != null && this.m_21205_().m_41720_() instanceof IChiefSwordItem && (Integer)MinecoloniesAPIProxy.getInstance().getConfig().getServer().barbarianHordeDifficulty.get() >= 5) {
                    RaiderMobUtils.getBarbariansCloseToEntity((Entity)this, 7.0).stream().filter(entity -> !entity.m_21023_(MobEffects.f_19596_)).forEach(entity -> entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 1)));
                }
            } else {
                --this.currentCount;
            }
        }
        ++this.currentTick;
        if (this.isRegistered) {
            this.ai.tick();
        }
        super.m_8107_();
    }

    private void onEnterChunk(ChunkPos newChunkPos) {
        LevelChunk chunk = this.colony.getWorld().m_6325_(newChunkPos.f_45578_, newChunkPos.f_45579_);
        IColonyTagCapability chunkCapability = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (chunkCapability != null && chunkCapability.getOwningColony() != 0 && this.colony.getID() != chunkCapability.getOwningColony()) {
            IColony tempColony = IColonyManager.getInstance().getColonyByWorld(chunkCapability.getOwningColony(), this.f_19853_);
            tempColony.getRaiderManager().setPassThroughRaid();
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        RaiderMobUtils.setEquipment(this);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && this.colony != null && this.eventID > 0) {
            this.colony.getEventManager().unregisterEntity((Entity)this, this.eventID);
        }
        super.m_142687_(reason);
    }

    public IColony getColony() {
        return this.colony;
    }

    public void registerWithColony() {
        if (this.colony == null || this.eventID == 0 || this.f_20890_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        RaiderMobUtils.setMobAttributes(this, this.getColony());
        this.colony.getEventManager().registerEntity((Entity)this, this.eventID);
        this.isRegistered = true;
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_9236_().f_46443_ && this.getColony() != null) {
            this.getColony().getEventManager().onEntityDeath((LivingEntity)this, this.eventID);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6469_(@NotNull DamageSource damageSource, float damage) {
        if (damageSource.m_7639_() instanceof AbstractEntityRaiderMob) {
            return false;
        }
        if (damageSource.m_7639_() instanceof LivingEntity) {
            this.threatTable.addThreat((LivingEntity)damageSource.m_7639_(), (int)damage);
        }
        if (damageSource.m_269150_().m_203565_(DamageTypes.f_268724_)) {
            return super.m_6469_(damageSource, damage);
        }
        if (damageSource.m_7640_() == null) {
            if (this.envDamageImmunity || this.tempEnvDamageImmunity) {
                return false;
            }
            if (--this.envDmgCooldown > 0) return false;
            this.envDmgCooldown = this.envDamageInterval;
            return super.m_6469_(damageSource, damage);
        } else {
            Entity source;
            if (this.m_9236_().m_5776_()) return super.m_6469_(damageSource, damage);
            IColonyEvent event = this.colony.getEventManager().getEventByID(this.eventID);
            if (event instanceof IColonyCampFireRaidEvent) {
                ((IColonyCampFireRaidEvent)((Object)event)).setCampFireTime(0);
            }
            if (!((source = damageSource.m_7639_()) instanceof Player)) return super.m_6469_(damageSource, damage);
            if (damage > 30.0f && this.f_19796_.m_188503_(5) == 0) {
                source.m_6469_(this.m_9236_().m_269111_().m_269374_((Entity)this), damage * 0.5f);
            }
            float raiderDamageEnchantLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchants.raiderDamage.get()), (ItemStack)((Player)source).m_21205_());
            float baseScalingDamage = Math.min(damage, 7.0f);
            float totalWithScaled = Math.max(damage, damage - baseScalingDamage + baseScalingDamage * 0.03f * this.m_21233_() * (1.0f + raiderDamageEnchantLevel / 5.0f));
            return super.m_6469_(damageSource, totalWithScaled);
        }
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return LivingEntity.m_21183_().m_22266_((Attribute)RaiderMobUtils.MOB_ATTACK_DAMAGE.get()).m_22266_(Attributes.f_22276_).m_22266_(Attributes.f_22284_).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 70.0).m_22268_(Attributes.f_22281_, Attributes.f_22281_.m_22082_());
    }

    public void setColony(IColony colony) {
        if (colony != null) {
            this.colony = colony;
        }
    }

    public int getEventID() {
        return this.eventID;
    }

    public void setEventID(int eventID) {
        this.eventID = eventID;
    }

    public void setEnvDamageInterval(int interval) {
        this.envDamageInterval = interval;
    }

    public void setEnvDamageImmunity(boolean immunity) {
        this.envDamageImmunity = immunity;
    }

    public void setTempEnvDamageImmunity(boolean immunity) {
        this.tempEnvDamageImmunity = immunity;
    }

    public void initStatsFor(double baseHealth, double difficulty, double baseDamage) {
        this.m_21051_((Attribute)RaiderMobUtils.MOB_ATTACK_DAMAGE.get()).m_22100_(baseDamage);
        this.difficulty = difficulty;
        double armor = difficulty * 1.0;
        this.m_21051_(Attributes.f_22284_).m_22100_(armor);
        this.setEnvDamageInterval((int)(2.0 * difficulty));
        if (difficulty >= 1.4) {
            this.setEnvDamageImmunity(true);
        }
        if (difficulty >= 2.0) {
            this.m_9236_().m_6188_().m_6546_(this.m_6302_(), this.checkOrCreateTeam());
        }
        this.m_21051_(Attributes.f_22276_).m_22100_(baseHealth);
        this.m_21153_(this.m_21233_());
    }

    private PlayerTeam checkOrCreateTeam() {
        if (this.m_9236_().m_6188_().m_83489_(this.getTeamName()) == null) {
            this.m_9236_().m_6188_().m_83492_(this.getTeamName());
            this.m_9236_().m_6188_().m_83489_(this.getTeamName()).m_83355_(false);
        }
        return this.m_9236_().m_6188_().m_83489_(this.getTeamName());
    }

    protected String getTeamName() {
        return RAID_TEAM;
    }

    public double getDifficulty() {
        return this.difficulty;
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public ThreatTable getThreatTable() {
        return this.threatTable;
    }

    public ITickRateStateMachine<IState> getAI() {
        return this.ai;
    }
}

