/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.compatibility.dynamictrees.DynamicTreeCompat;
import com.minecolonies.api.compatibility.resourcefulbees.ResourcefulBeesCompat;
import com.minecolonies.api.compatibility.tinkers.SlimeTreeCheck;
import com.minecolonies.api.compatibility.tinkers.TinkersToolHelper;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.registry.ModRecipeSerializer;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockStateStorage;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.Disease;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Tuple;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class CompatibilityManager
implements ICompatibilityManager {
    private final Map<BlockStateStorage, ItemStorage> leavesToSaplingMap = new HashMap<BlockStateStorage, ItemStorage>();
    private final List<ItemStorage> saplings = new ArrayList<ItemStorage>();
    private final List<Property<?>> leafCompareWithoutProperties = ImmutableList.of((Object)checkDecay, (Object)decayable, (Object)DYN_PROP_HYDRO, (Object)TREE_DISTANCE);
    private static final BooleanProperty checkDecay = BooleanProperty.m_61465_((String)"check_decay");
    private static final BooleanProperty decayable = BooleanProperty.m_61465_((String)"decayable");
    public static final IntegerProperty DYN_PROP_HYDRO = IntegerProperty.m_61631_((String)"hydro", (int)1, (int)4);
    public static final IntegerProperty TREE_DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)1, (int)7);
    private final Set<Block> oreBlocks = new HashSet<Block>();
    private final Set<ItemStorage> smeltableOres = new HashSet<ItemStorage>();
    private final Map<Item, CompostRecipe> compostRecipes = new HashMap<Item, CompostRecipe>();
    private final Set<ItemStorage> plantables = new HashSet<ItemStorage>();
    private final Set<ItemStorage> fuel = new HashSet<ItemStorage>();
    private final Set<ItemStorage> food = new HashSet<ItemStorage>();
    private final Set<ItemStorage> edibles = new HashSet<ItemStorage>();
    private ImmutableSet<ItemStorage> beekeeperflowers = ImmutableSet.of();
    private final Map<String, Disease> diseases = new HashMap<String, Disease>();
    private final List<String> diseaseList = new ArrayList<String>();
    private final Map<Integer, List<ItemStorage>> luckyOres = new HashMap<Integer, List<ItemStorage>>();
    private final List<Tuple<Item, Integer>> recruitmentCostsWeights = new ArrayList<Tuple<Item, Integer>>();
    private static final Random random = new Random();
    private static ImmutableList<ItemStack> allItems = ImmutableList.of();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private ImmutableSet<ResourceLocation> monsters = ImmutableSet.of();
    private final Map<ItemStorage, CreativeModeTab> creativeModeTabMap = new HashMap<ItemStorage, CreativeModeTab>();

    private void clear() {
        this.saplings.clear();
        this.oreBlocks.clear();
        this.smeltableOres.clear();
        this.plantables.clear();
        this.beekeeperflowers = ImmutableSet.of();
        this.food.clear();
        this.edibles.clear();
        this.fuel.clear();
        this.compostRecipes.clear();
        this.luckyOres.clear();
        this.recruitmentCostsWeights.clear();
        this.diseases.clear();
        this.diseaseList.clear();
        this.freeBlocks.clear();
        this.freePositions.clear();
        this.monsters = ImmutableSet.of();
        this.creativeModeTabMap.clear();
    }

    @Override
    public void discover(@NotNull RecipeManager recipeManager, Level level) {
        this.clear();
        this.discoverAllItems(level);
        this.discoverLuckyOres();
        this.discoverRecruitCosts();
        this.discoverDiseases();
        this.discoverFreeBlocksAndPos();
        this.discoverModCompat();
        this.discoverCompostRecipes(recipeManager);
        this.discoverMobs();
    }

    @Override
    public void serialize(@NotNull FriendlyByteBuf buf) {
        CompatibilityManager.serializeItemStorageList(buf, this.saplings);
        CompatibilityManager.serializeBlockList(buf, this.oreBlocks);
        CompatibilityManager.serializeItemStorageList(buf, this.smeltableOres);
        CompatibilityManager.serializeItemStorageList(buf, this.plantables);
        CompatibilityManager.serializeItemStorageList(buf, this.beekeeperflowers);
        CompatibilityManager.serializeItemStorageList(buf, this.food);
        CompatibilityManager.serializeItemStorageList(buf, this.edibles);
        CompatibilityManager.serializeItemStorageList(buf, this.fuel);
        CompatibilityManager.serializeRegistryIds(buf, ForgeRegistries.ENTITY_TYPES, this.monsters);
        CompatibilityManager.serializeCompostRecipes(buf, this.compostRecipes);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void deserialize(@NotNull FriendlyByteBuf buf, ClientLevel level) {
        this.clear();
        this.discoverAllItems((Level)level);
        this.saplings.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.oreBlocks.addAll(CompatibilityManager.deserializeBlockList(buf));
        this.smeltableOres.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.plantables.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.beekeeperflowers = ImmutableSet.copyOf(CompatibilityManager.deserializeItemStorageList(buf));
        this.food.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.edibles.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.fuel.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.monsters = ImmutableSet.copyOf(CompatibilityManager.deserializeRegistryIds(buf, ForgeRegistries.ENTITY_TYPES));
        Log.getLogger().info("Synchronized {} saplings", (Object)this.saplings.size());
        Log.getLogger().info("Synchronized {} ore blocks with {} smeltable ores", (Object)this.oreBlocks.size(), (Object)this.smeltableOres.size());
        Log.getLogger().info("Synchronized {} plantables", (Object)this.plantables.size());
        Log.getLogger().info("Synchronized {} flowers", (Object)this.beekeeperflowers.size());
        Log.getLogger().info("Synchronized {} food types with {} edible", (Object)this.food.size(), (Object)this.edibles.size());
        Log.getLogger().info("Synchronized {} fuel types", (Object)this.fuel.size());
        Log.getLogger().info("Synchronized {} monsters", (Object)this.monsters.size());
        this.discoverCompostRecipes(CompatibilityManager.deserializeCompostRecipes(buf));
        this.discoverLuckyOres();
        this.discoverRecruitCosts();
        this.discoverDiseases();
        this.discoverFreeBlocksAndPos();
        this.discoverModCompat();
    }

    private static void serializeItemStorageList(@NotNull FriendlyByteBuf buf, @NotNull Collection<ItemStorage> list) {
        buf.m_236828_(list, StandardFactoryController.getInstance()::serialize);
    }

    @NotNull
    private static List<ItemStorage> deserializeItemStorageList(@NotNull FriendlyByteBuf buf) {
        return buf.m_236845_(StandardFactoryController.getInstance()::deserialize);
    }

    private static void serializeBlockList(@NotNull FriendlyByteBuf buf, @NotNull Collection<Block> list) {
        buf.m_236828_(list.stream().map(ItemStack::new).toList(), FriendlyByteBuf::m_130055_);
    }

    @NotNull
    private static List<Block> deserializeBlockList(@NotNull FriendlyByteBuf buf) {
        List stacks = buf.m_236845_(FriendlyByteBuf::m_130267_);
        return stacks.stream().flatMap(stack -> {
            Stream<Object> stream;
            Item patt10956$temp = stack.m_41720_();
            if (patt10956$temp instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)patt10956$temp;
                stream = Stream.of(blockItem.m_40614_());
            } else {
                stream = Stream.empty();
            }
            return stream;
        }).toList();
    }

    private static void serializeRegistryIds(@NotNull FriendlyByteBuf buf, @NotNull IForgeRegistry<?> registry, @NotNull Collection<ResourceLocation> ids) {
        buf.m_236828_(ids, (b, id) -> b.writeRegistryIdUnsafe(registry, id));
    }

    @NotNull
    private static <T> List<ResourceLocation> deserializeRegistryIds(@NotNull FriendlyByteBuf buf, @NotNull IForgeRegistry<T> registry) {
        return buf.m_236845_(b -> b.readRegistryIdUnsafe(registry)).stream().flatMap(item -> Stream.ofNullable(registry.getKey(item))).toList();
    }

    private static void serializeCompostRecipes(@NotNull FriendlyByteBuf buf, @NotNull Map<Item, CompostRecipe> compostRecipes) {
        List<CompostRecipe> recipes = compostRecipes.values().stream().distinct().toList();
        buf.m_236828_(recipes, ((CompostRecipe.Serializer)ModRecipeSerializer.CompostRecipeSerializer.get())::toNetwork);
    }

    @NotNull
    private static List<CompostRecipe> deserializeCompostRecipes(@NotNull FriendlyByteBuf buf) {
        CompostRecipe.Serializer serializer = (CompostRecipe.Serializer)ModRecipeSerializer.CompostRecipeSerializer.get();
        ResourceLocation empty = new ResourceLocation("");
        return buf.m_236845_(b -> serializer.fromNetwork(empty, (FriendlyByteBuf)b));
    }

    @Override
    public List<ItemStack> getListOfAllItems() {
        if (allItems.isEmpty()) {
            Log.getLogger().error("getListOfAllItems when empty");
        }
        return allItems;
    }

    @Override
    public Set<ItemStorage> getSetOfAllItems() {
        if (this.creativeModeTabMap.isEmpty()) {
            Log.getLogger().error("getSetOfAllItems when empty");
        }
        return this.creativeModeTabMap.keySet();
    }

    @Override
    public boolean isPlantable(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_41720_() instanceof BlockItem && itemStack.m_204117_(ModTags.floristFlowers);
    }

    @Override
    public boolean isLuckyBlock(Block block) {
        return block.m_49966_().m_204336_(ModTags.oreChanceBlocks);
    }

    @Override
    public ItemStack getSaplingForLeaf(BlockState block) {
        BlockStateStorage tempLeaf = new BlockStateStorage(block, this.leafCompareWithoutProperties, true);
        if (this.leavesToSaplingMap.containsKey(tempLeaf)) {
            return this.leavesToSaplingMap.get(tempLeaf).getItemStack();
        }
        return null;
    }

    @Override
    public Set<ItemStorage> getCopyOfSaplings() {
        if (this.saplings.isEmpty()) {
            Log.getLogger().error("getCopyOfSaplings when empty");
        }
        return new HashSet<ItemStorage>(this.saplings);
    }

    @Override
    public Set<ItemStorage> getFuel() {
        if (this.fuel.isEmpty()) {
            Log.getLogger().error("getFuel when empty");
        }
        return this.fuel;
    }

    @Override
    public Set<ItemStorage> getFood() {
        if (this.food.isEmpty()) {
            Log.getLogger().error("getFood when empty");
        }
        return this.food;
    }

    @Override
    public Set<ItemStorage> getEdibles(int minNutrition) {
        if (this.edibles.isEmpty()) {
            Log.getLogger().error("getEdibles when empty");
        }
        HashSet<ItemStorage> filteredEdibles = new HashSet<ItemStorage>();
        for (ItemStorage storage : this.edibles) {
            if (storage.getItemStack().getFoodProperties(null) == null || storage.getItemStack().getFoodProperties(null).m_38744_() < minNutrition) continue;
            filteredEdibles.add(storage);
        }
        return filteredEdibles;
    }

    @Override
    public Set<ItemStorage> getSmeltableOres() {
        if (this.smeltableOres.isEmpty()) {
            Log.getLogger().error("getSmeltableOres when empty");
        }
        return this.smeltableOres;
    }

    @Override
    public Map<Item, CompostRecipe> getCopyOfCompostRecipes() {
        if (this.compostRecipes.isEmpty()) {
            Log.getLogger().error("getCopyOfCompostRecipes when empty");
        }
        return ImmutableMap.copyOf(this.compostRecipes);
    }

    @Override
    public Set<ItemStorage> getCompostInputs() {
        if (this.compostRecipes.isEmpty()) {
            Log.getLogger().error("getCompostInputs when empty");
        }
        return this.compostRecipes.keySet().stream().map(item -> new ItemStorage(new ItemStack((ItemLike)item))).collect(Collectors.toSet());
    }

    @Override
    public Set<ItemStorage> getCopyOfPlantables() {
        if (this.plantables.isEmpty()) {
            Log.getLogger().error("getCopyOfPlantables when empty");
        }
        return new HashSet<ItemStorage>(this.plantables);
    }

    @Override
    public Set<ItemStorage> getImmutableFlowers() {
        if (this.beekeeperflowers.isEmpty()) {
            Log.getLogger().error("getImmutableFlowers when empty");
        }
        return this.beekeeperflowers;
    }

    @Override
    public String getRandomDisease() {
        return this.diseaseList.get(random.nextInt(this.diseaseList.size()));
    }

    @Override
    public Disease getDisease(String disease) {
        return this.diseases.get(disease);
    }

    @Override
    public List<Disease> getDiseases() {
        return new ArrayList<Disease>(this.diseases.values());
    }

    @Override
    public List<Tuple<Item, Integer>> getRecruitmentCostsWeights() {
        return Collections.unmodifiableList(this.recruitmentCostsWeights);
    }

    @Override
    public boolean isOre(BlockState block) {
        if (this.oreBlocks.isEmpty()) {
            Log.getLogger().error("isOre when empty");
        }
        return this.oreBlocks.contains(block.m_60734_());
    }

    @Override
    public boolean isOre(@NotNull ItemStack stack) {
        if (this.isMineableOre(stack) || stack.m_204117_(ModTags.raw_ore) || stack.m_204117_(ModTags.breakable_ore)) {
            ItemStack smeltingResult = MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack);
            return stack.m_204117_(ModTags.breakable_ore) || !smeltingResult.m_41619_();
        }
        return false;
    }

    @Override
    public boolean isMineableOre(@NotNull ItemStack stack) {
        return !ItemStackUtils.isEmpty(stack) && stack.m_204117_(Tags.Items.ORES);
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        @NotNull ListTag saplingsLeavesTagList = this.leavesToSaplingMap.entrySet().stream().filter(entry -> entry.getKey() != null).map(entry -> CompatibilityManager.writeLeafSaplingEntryToNBT(((BlockStateStorage)entry.getKey()).getState(), (ItemStorage)entry.getValue())).collect(NBTUtils.toListNBT());
        compound.m_128365_("tagSapLeaves", (Tag)saplingsLeavesTagList);
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        NBTUtils.streamCompound(compound.m_128437_("tagSapLeaves", 10)).map(CompatibilityManager::readLeafSaplingEntryFromNBT).filter(key -> !this.leavesToSaplingMap.containsKey(new BlockStateStorage((BlockState)key.getA(), this.leafCompareWithoutProperties, true)) && !this.leavesToSaplingMap.containsValue(key.getB())).forEach(key -> this.leavesToSaplingMap.put(new BlockStateStorage((BlockState)key.getA(), this.leafCompareWithoutProperties, true), (ItemStorage)key.getB()));
    }

    @Override
    public void connectLeafToSapling(BlockState leaf, ItemStack stack) {
        BlockStateStorage store = new BlockStateStorage(leaf, this.leafCompareWithoutProperties, true);
        if (!this.leavesToSaplingMap.containsKey(store)) {
            this.leavesToSaplingMap.put(store, new ItemStorage(stack, false, true));
        }
    }

    @Override
    public ItemStack getRandomLuckyOre(double chanceBonus, int buildingLevel) {
        if (random.nextDouble() * 100.0 <= (double)((Integer)MinecoloniesAPIProxy.getInstance().getConfig().getServer().luckyBlockChance.get()).intValue() * chanceBonus) {
            List<ItemStorage> luckyOresInLevel = this.luckyOres.get(0);
            if (this.luckyOres.containsKey(buildingLevel)) {
                luckyOresInLevel = this.luckyOres.get(buildingLevel);
            }
            return luckyOresInLevel.get(random.nextInt(luckyOresInLevel.size())).getItemStack().m_41777_();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean isFreeBlock(Block block) {
        return this.freeBlocks.contains(block);
    }

    @Override
    public boolean isFreePos(BlockPos block) {
        return this.freePositions.contains(block);
    }

    @Override
    public CreativeModeTab getCreativeTab(ItemStorage checkItem) {
        return this.creativeModeTabMap.get(checkItem);
    }

    @Override
    public int getCreativeTabKey(ItemStorage checkItem) {
        CreativeModeTab creativeTab = this.creativeModeTabMap.get(checkItem);
        return creativeTab == null ? 0 : this.creativeModeTabMap.get(checkItem).m_257903_();
    }

    @Override
    public ImmutableSet<ResourceLocation> getAllMonsters() {
        if (this.monsters.isEmpty()) {
            Log.getLogger().error("getAllMonsters when empty");
        }
        return this.monsters;
    }

    private void discoverMobs() {
        HashSet<ResourceLocation> monsterSet = new HashSet<ResourceLocation>();
        for (Map.Entry entry : ForgeRegistries.ENTITY_TYPES.getEntries()) {
            if (((EntityType)entry.getValue()).m_20674_() == MobCategory.MONSTER) {
                monsterSet.add(((ResourceKey)entry.getKey()).m_135782_());
                continue;
            }
            if (!((EntityType)entry.getValue()).m_204039_(ModTags.hostile)) continue;
            monsterSet.add(((ResourceKey)entry.getKey()).m_135782_());
        }
        this.monsters = ImmutableSet.copyOf(monsterSet);
    }

    private void discoverAllItems(Level level) {
        if (!this.food.isEmpty()) {
            return;
        }
        HashSet tempFlowers = new HashSet();
        CreativeModeTab.ItemDisplayParameters tempDisplayParams = new CreativeModeTab.ItemDisplayParameters(level.m_246046_(), false, (HolderLookup.Provider)level.m_9598_());
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        CraftingUtils.forEachCreativeTabItems(tempDisplayParams, (tab, stacks) -> {
            Object2IntLinkedOpenHashMap mapping = new Object2IntLinkedOpenHashMap();
            for (ItemStack item : stacks) {
                if (mapping.addTo((Object)item.m_41720_(), 1) > (Integer)IMinecoloniesAPI.getInstance().getConfig().getServer().maxItemSubTypeScan.get()) continue;
                listBuilder.add((Object)item);
                this.discoverSaplings(item);
                this.discoverOres(item);
                this.discoverPlantables(item);
                this.discoverFood(item);
                this.discoverFuel(item);
                this.discoverBeekeeperFlowers(item, tempFlowers);
                this.creativeModeTabMap.put(new ItemStorage(item), (CreativeModeTab)tab);
            }
        });
        this.beekeeperflowers = ImmutableSet.copyOf(tempFlowers);
        Log.getLogger().info("Finished discovering Ores " + this.oreBlocks.size() + " " + this.smeltableOres.size());
        Log.getLogger().info("Finished discovering saplings " + this.saplings.size());
        Log.getLogger().info("Finished discovering plantables " + this.plantables.size());
        Log.getLogger().info("Finished discovering food " + this.edibles.size() + " " + this.food.size());
        Log.getLogger().info("Finished discovering fuel " + this.fuel.size());
        Log.getLogger().info("Finished discovering flowers " + this.beekeeperflowers.size());
        allItems = listBuilder.build();
        Log.getLogger().info("Finished discovering items " + allItems.size());
    }

    private void discoverBeekeeperFlowers(ItemStack item, Set<ItemStorage> tempFlowers) {
        if (item.m_204117_(ItemTags.f_13149_)) {
            tempFlowers.add(new ItemStorage(item));
        }
    }

    private void discoverOres(ItemStack stack) {
        if (stack.m_204117_(Tags.Items.ORES) || stack.m_204117_(ModTags.breakable_ore) || stack.m_204117_(ModTags.raw_ore)) {
            if (stack.m_41720_() instanceof BlockItem) {
                this.oreBlocks.add(((BlockItem)stack.m_41720_()).m_40614_());
            }
            if (!MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack).m_41619_()) {
                this.smeltableOres.add(new ItemStorage(stack));
            }
        }
    }

    private void discoverSaplings(ItemStack stack) {
        if (stack.m_204117_(ItemTags.f_13180_)) {
            this.saplings.add(new ItemStorage(stack, false, true));
        }
    }

    private void discoverCompostRecipes(@NotNull RecipeManager recipeManager) {
        if (this.compostRecipes.isEmpty()) {
            this.discoverCompostRecipes(recipeManager.m_44054_((RecipeType)ModRecipeSerializer.CompostRecipeType.get()).values().stream().map(r -> r).toList());
            Log.getLogger().info("Finished discovering compostables " + this.compostRecipes.size());
        }
    }

    private void discoverCompostRecipes(@NotNull List<CompostRecipe> recipes) {
        for (CompostRecipe recipe : recipes) {
            for (ItemStack stack : recipe.getInput().m_43908_()) {
                this.compostRecipes.merge(stack.m_41720_(), recipe, (r1, r2) -> r1.getStrength() < r2.getStrength() ? r1 : r2);
            }
        }
    }

    private void discoverPlantables(ItemStack stack) {
        if (stack.m_204117_(ModTags.floristFlowers) && stack.m_41720_() instanceof BlockItem) {
            this.plantables.add(new ItemStorage(stack));
        }
    }

    private void discoverFuel(ItemStack stack) {
        if (FurnaceBlockEntity.m_58399_((ItemStack)stack)) {
            this.fuel.add(new ItemStorage(stack));
        }
    }

    private void discoverFood(ItemStack stack) {
        if (ItemStackUtils.ISFOOD.test(stack) || ItemStackUtils.ISCOOKABLE.test(stack)) {
            this.food.add(new ItemStorage(stack));
            if (ItemStackUtils.CAN_EAT.test(stack)) {
                this.edibles.add(new ItemStorage(stack));
            }
        }
    }

    private void discoverLuckyOres() {
        if (this.luckyOres.isEmpty()) {
            for (String ore : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().luckyOres.get()) {
                String[] split = ore.split("!");
                if (split.length < 2) {
                    Log.getLogger().warn("Wrong configured ore: " + ore);
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
                if (item == null || item == Items.f_41852_) {
                    Log.getLogger().warn("Invalid lucky block: " + ore);
                    continue;
                }
                boolean defaultMineLevel = false;
                int buildingLevel = 0;
                ItemStack stack = new ItemStack((ItemLike)item, 1);
                try {
                    if (split.length == 3) {
                        buildingLevel = Integer.parseInt(split[2]);
                    }
                    int rarity = Integer.parseInt(split[1]);
                    this.luckyOres.putIfAbsent(buildingLevel, new ArrayList());
                    for (int i = 0; i < rarity; ++i) {
                        List<ItemStorage> luckyOreOnLevel = this.luckyOres.get(buildingLevel);
                        luckyOreOnLevel.add(new ItemStorage(stack));
                    }
                }
                catch (NumberFormatException ex) {
                    Log.getLogger().warn("Ore has invalid rarity or building level: " + ore);
                }
            }
            List<ItemStorage> alternative = null;
            int mineMaxLevel = 5;
            for (int levelToTest = 0; levelToTest <= mineMaxLevel; ++levelToTest) {
                if (!this.luckyOres.containsKey(levelToTest) || this.luckyOres.get(levelToTest).isEmpty()) continue;
                alternative = this.luckyOres.get(levelToTest);
                break;
            }
            for (int levelToReplace = 0; levelToReplace <= mineMaxLevel; ++levelToReplace) {
                this.luckyOres.putIfAbsent(levelToReplace, alternative);
            }
        }
        Log.getLogger().info("Finished discovering lucky oreBlocks " + this.luckyOres.size());
    }

    private void discoverRecruitCosts() {
        if (this.recruitmentCostsWeights.isEmpty()) {
            for (String itemString : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().configListRecruitmentItems.get()) {
                String[] split = itemString.split(";");
                if (split.length < 2) {
                    Log.getLogger().warn("Wrong configured recruitment cost: " + itemString);
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
                if (item == null || item == Items.f_41852_) {
                    Log.getLogger().warn("Invalid recruitment item: " + item);
                    continue;
                }
                try {
                    int rarity = Integer.parseInt(split[split.length - 1]);
                    this.recruitmentCostsWeights.add(new Tuple<Item, Integer>(item, rarity));
                }
                catch (NumberFormatException ex) {
                    Log.getLogger().warn("Invalid recruitment weight for: " + item);
                }
            }
        }
        Log.getLogger().info("Finished discovering recruitment costs");
    }

    private void discoverDiseases() {
        if (this.diseases.isEmpty()) {
            for (String disease : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().diseases.get()) {
                String[] split = disease.split(",");
                if (split.length < 3) {
                    Log.getLogger().warn("Wrongly configured disease: " + disease);
                    continue;
                }
                try {
                    int i;
                    String name = split[0];
                    int rarity = Integer.parseInt(split[1]);
                    ArrayList<ItemStack> cure = new ArrayList<ItemStack>();
                    for (i = 2; i < split.length; ++i) {
                        String[] theItem = split[i].split(":");
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(theItem[0], theItem[1]));
                        if (item == null || item == Items.f_41852_) {
                            Log.getLogger().warn("Invalid cure item: " + disease);
                            continue;
                        }
                        ItemStack stack = new ItemStack((ItemLike)item, 1);
                        cure.add(stack);
                    }
                    this.diseases.put(name, new Disease(name, rarity, cure));
                    for (i = 0; i < rarity; ++i) {
                        this.diseaseList.add(name);
                    }
                }
                catch (NumberFormatException e) {
                    Log.getLogger().warn("Wrongly configured disease: " + disease);
                }
            }
        }
        Log.getLogger().info("Finished discovering diseases");
    }

    private static CompoundTag writeLeafSaplingEntryToNBT(BlockState state, ItemStorage storage) {
        CompoundTag compound = NbtUtils.m_129202_((BlockState)state);
        storage.getItemStack().m_41739_(compound);
        return compound;
    }

    private static Tuple<BlockState, ItemStorage> readLeafSaplingEntryFromNBT(CompoundTag compound) {
        return new Tuple<BlockState, ItemStorage>(NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)compound), new ItemStorage(ItemStack.m_41712_((CompoundTag)compound), false, true));
    }

    private void discoverFreeBlocksAndPos() {
        for (String s : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().freeToInteractBlocks.get()) {
            try {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
                if (block == null || block instanceof AirBlock) continue;
                this.freeBlocks.add(block);
            }
            catch (Exception ex) {
                BlockPos pos = BlockPosUtil.getBlockPosOfString(s);
                if (pos == null) continue;
                this.freePositions.add(pos);
            }
        }
    }

    private void discoverModCompat() {
        if (ModList.get().isLoaded("resourcefulbees")) {
            Compatibility.beeHiveCompat = new ResourcefulBeesCompat();
        }
        if (ModList.get().isLoaded("tconstruct")) {
            Compatibility.tinkersCompat = new TinkersToolHelper();
            Compatibility.tinkersSlimeCompat = new SlimeTreeCheck();
        }
        if (ModList.get().isLoaded("dynamictrees")) {
            Compatibility.dynamicTreesCompat = new DynamicTreeCompat();
        }
    }
}

