/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuildingContainer;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.modules.IModuleContainer;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverProvider;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IBuilding
extends IBuildingContainer,
IModuleContainer<IBuildingModule>,
IRequestResolverProvider,
IRequester,
ISchematicProvider {
    public static final int WOOD_HUT_LEVEL = 0;

    @NotNull
    public String getCustomName();

    @NotNull
    public String getBuildingDisplayName();

    default public void onWakeUp() {
    }

    public void onCleanUp(ICitizenData var1);

    public void onRestart(ICitizenData var1);

    public void onPlacement();

    default public void onPlayerEnterNearby(Player player) {
    }

    default public void onPlayerEnterBuilding(Player player) {
    }

    public boolean isMatchingBlock(@NotNull Block var1);

    public void destroy();

    public void onDestroyed();

    public IColony getColony();

    public boolean canBeBuiltByBuilder(int var1);

    @Override
    public void markDirty();

    public boolean hasWorkOrder();

    public void removeWorkOrder();

    public int getClaimRadius(int var1);

    public void serializeToView(@NotNull FriendlyByteBuf var1);

    public void setCustomBuildingName(String var1);

    public boolean canBeGathered();

    public void requestUpgrade(Player var1, BlockPos var2);

    public void requestRemoval(Player var1, BlockPos var2);

    public void requestRepair(BlockPos var1);

    public boolean isBuilt();

    public void deconstruct();

    public void onUpgradeComplete(int var1);

    public boolean isGuardBuildingNear();

    public void resetGuardBuildingNear();

    public int buildingRequiresCertainAmountOfItem(ItemStack var1, List<ItemStorage> var2, boolean var3, @Nullable JobEntry var4);

    default public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory) {
        return this.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory, null);
    }

    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount();

    @Nullable
    public ItemStack forceTransferStack(ItemStack var1, Level var2);

    public <R extends IRequestable> IToken<?> createRequest(@NotNull ICitizenData var1, @NotNull R var2, boolean var3);

    public <R extends IRequestable> IToken<?> createRequest(@NotNull R var1, boolean var2);

    public boolean hasWorkerOpenRequests(int var1);

    public Collection<IRequest<?>> getOpenRequests(int var1);

    public boolean hasWorkerOpenRequestsFiltered(int var1, @NotNull Predicate<IRequest<?>> var2);

    public boolean hasOpenSyncRequest(@NotNull ICitizenData var1);

    public <R> boolean hasWorkerOpenRequestsOfType(int var1, TypeToken<R> var2);

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(int var1, TypeToken<R> var2);

    public boolean hasCitizenCompletedRequests(@NotNull ICitizenData var1);

    public boolean hasCitizenCompletedRequestsToPickup(@NotNull ICitizenData var1);

    public Collection<IRequest<?>> getCompletedRequests(@NotNull ICitizenData var1);

    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfType(@NotNull ICitizenData var1, TypeToken<R> var2);

    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfTypeFiltered(@NotNull ICitizenData var1, TypeToken<R> var2, Predicate<IRequest<? extends R>> var3);

    public void markRequestAsAccepted(@NotNull ICitizenData var1, @NotNull IToken<?> var2);

    public void cancelAllRequestsOfCitizen(@NotNull ICitizenData var1);

    public void overruleNextOpenRequestWithStack(@NotNull ItemStack var1);

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull ICitizenData var1, TypeToken<R> var2, Predicate<IRequest<? extends R>> var3);

    public boolean overruleNextOpenRequestOfCitizenWithStack(@NotNull ICitizenData var1, @NotNull ItemStack var2);

    public boolean createPickupRequest(int var1);

    @Override
    public ImmutableCollection<IRequestResolver<?>> getResolvers();

    public ImmutableCollection<IRequestResolver<?>> createResolvers();

    public IRequester getRequester();

    public Optional<ICitizenData> getCitizenForRequest(@NotNull IToken<?> var1);

    public Map<ItemStorage, Integer> reservedStacksExcluding(@NotNull IRequest<? extends IDeliverable> var1);

    public void processOfflineTime(long var1);

    public void calculateCorners();

    public boolean isInBuilding(@NotNull BlockPos var1);

    public void upgradeBuildingLevelToSchematicData();

    public Map<TypeToken<?>, Collection<IToken<?>>> getOpenRequestsByRequestableType();

    public void pickUp(Player var1);

    public BuildingEntry getBuildingType();

    public void setBuildingType(BuildingEntry var1);

    public void onColonyTick(IColony var1);

    public boolean isItemStackInRequest(@Nullable ItemStack var1);

    default public int getMaxToolLevel() {
        if (this.getBuildingLevel() >= this.getMaxBuildingLevel()) {
            return Integer.MAX_VALUE;
        }
        if (this.getBuildingLevel() <= 0) {
            return 1;
        }
        return this.getBuildingLevel() - 0;
    }

    public Set<ICitizenData> getAllAssignedCitizen();

    public List<IItemHandler> getHandlers();

    public <T extends ISetting<S>, S> T getSetting(@NotNull ISettingKey<T> var1);

    public <T extends ISetting<S>, S> S getSettingValueOrDefault(@NotNull ISettingKey<T> var1, @NotNull S var2);

    public boolean canEat(ItemStack var1);
}

